/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.arrow;

import com.alibaba.fastjson2.stream.StreamReader;
import com.alibaba.fastjson2.support.csv.CSVReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

public class CSVUtils {
    public static String genMaxComputeCreateTable(File file, String tableName) throws IOException {
        CSVReader csvReader = CSVReader.of((File)file, (Type[])new Type[0]);
        csvReader.readHeader();
        csvReader.statAll();
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ").append(tableName).append(" (\n");
        List columns = csvReader.getColumnStats();
        for (int i = 0; i < columns.size(); ++i) {
            char ch;
            int j;
            StreamReader.ColumnStat columnStat = (StreamReader.ColumnStat)columns.get(i);
            StringBuffer buf = new StringBuffer();
            for (j = 0; j < columnStat.name.length(); ++j) {
                ch = columnStat.name.charAt(j);
                if (ch == '\ufffd') continue;
                if (ch == ' ' || ch == '-' || ch == '+' || ch == '.') {
                    buf.append('_');
                    continue;
                }
                buf.append(ch);
            }
            String columnName = buf.toString();
            boolean special = false;
            for (j = 0; j < columnName.length(); ++j) {
                boolean firstIdent;
                ch = columnName.charAt(j);
                boolean bl = firstIdent = ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_';
                if (j == 0 && !firstIdent) {
                    special = true;
                    break;
                }
                if (firstIdent || ch >= '0' && ch <= '9') continue;
                special = true;
                break;
            }
            if (!special && columnName.length() > 30) {
                special = true;
            }
            sql.append('\t');
            if (special) {
                sql.append("COL_" + i);
            } else {
                sql.append(columnName);
            }
            sql.append(' ');
            sql.append(columnStat.getInferSQLType());
            if (special) {
                sql.append(" COMMENT '");
                for (j = 0; j < columnStat.name.length(); ++j) {
                    ch = columnStat.name.charAt(j);
                    if (ch == '\ufffd') continue;
                    if (ch == '\'') {
                        sql.append(ch);
                    }
                    sql.append(ch);
                }
                sql.append('\'');
            }
            if (i != columns.size() - 1) {
                sql.append(',');
            }
            sql.append("\n");
        }
        sql.append(");");
        return sql.toString();
    }
}

