from taihe.parse.antlr.TaiheAST import TaiheAST

from typing import Any


class TaiheVisitor:
    def visit(self, node: TaiheAST.any) -> Any:
        return node._accept(self)

    def visit_token(self, node: TaiheAST.TOKEN) -> Any:
        raise NotImplementedError()

    def visit_spec(self, node: TaiheAST.Spec) -> Any:
        raise NotImplementedError()

    def visit_scope_attr(self, node: TaiheAST.ScopeAttr) -> Any:
        raise NotImplementedError()

    def visit_decl_attr(self, node: TaiheAST.DeclAttr) -> Any:
        raise NotImplementedError()

    def visit_use_package(self, node: TaiheAST.UsePackage) -> Any:
        return self.visit_use(node)

    def visit_use_symbol(self, node: TaiheAST.UseSymbol) -> Any:
        return self.visit_use(node)

    def visit_use(self, node: TaiheAST.Use) -> Any:
        raise NotImplementedError()

    def visit_pkg_name(self, node: TaiheAST.PkgName) -> Any:
        raise NotImplementedError()

    def visit_decl_alias_pair(self, node: TaiheAST.DeclAliasPair) -> Any:
        raise NotImplementedError()

    def visit_struct(self, node: TaiheAST.Struct) -> Any:
        return self.visit_spec_field(node)

    def visit_global_function(self, node: TaiheAST.GlobalFunction) -> Any:
        return self.visit_spec_field(node)

    def visit_union(self, node: TaiheAST.Union) -> Any:
        return self.visit_spec_field(node)

    def visit_interface(self, node: TaiheAST.Interface) -> Any:
        return self.visit_spec_field(node)

    def visit_enum(self, node: TaiheAST.Enum) -> Any:
        return self.visit_spec_field(node)

    def visit_spec_field(self, node: TaiheAST.SpecField) -> Any:
        raise NotImplementedError()

    def visit_enum_property(self, node: TaiheAST.EnumProperty) -> Any:
        return self.visit_enum_item(node)

    def visit_enum_item(self, node: TaiheAST.EnumItem) -> Any:
        raise NotImplementedError()

    def visit_struct_property(self, node: TaiheAST.StructProperty) -> Any:
        return self.visit_struct_field(node)

    def visit_struct_field(self, node: TaiheAST.StructField) -> Any:
        raise NotImplementedError()

    def visit_union_property(self, node: TaiheAST.UnionProperty) -> Any:
        return self.visit_union_field(node)

    def visit_union_field(self, node: TaiheAST.UnionField) -> Any:
        raise NotImplementedError()

    def visit_interface_function(self, node: TaiheAST.InterfaceFunction) -> Any:
        return self.visit_interface_field(node)

    def visit_interface_field(self, node: TaiheAST.InterfaceField) -> Any:
        raise NotImplementedError()

    def visit_interface_parent(self, node: TaiheAST.InterfaceParent) -> Any:
        raise NotImplementedError()

    def visit_parameter(self, node: TaiheAST.Parameter) -> Any:
        raise NotImplementedError()

    def visit_simple_attr_item(self, node: TaiheAST.SimpleAttrItem) -> Any:
        return self.visit_attr_item(node)

    def visit_tuple_attr_item(self, node: TaiheAST.TupleAttrItem) -> Any:
        return self.visit_attr_item(node)

    def visit_attr_item(self, node: TaiheAST.AttrItem) -> Any:
        raise NotImplementedError()

    def visit_float_attr_val(self, node: TaiheAST.FloatAttrVal) -> Any:
        return self.visit_attr_val(node)

    def visit_bool_attr_val(self, node: TaiheAST.BoolAttrVal) -> Any:
        return self.visit_attr_val(node)

    def visit_string_attr_val(self, node: TaiheAST.StringAttrVal) -> Any:
        return self.visit_attr_val(node)

    def visit_int_attr_val(self, node: TaiheAST.IntAttrVal) -> Any:
        return self.visit_attr_val(node)

    def visit_attr_val(self, node: TaiheAST.AttrVal) -> Any:
        raise NotImplementedError()

    def visit_short_type(self, node: TaiheAST.ShortType) -> Any:
        return self.visit_type(node)

    def visit_generic_type(self, node: TaiheAST.GenericType) -> Any:
        return self.visit_type(node)

    def visit_long_type(self, node: TaiheAST.LongType) -> Any:
        return self.visit_type(node)

    def visit_callback_type(self, node: TaiheAST.CallbackType) -> Any:
        return self.visit_type(node)

    def visit_type(self, node: TaiheAST.Type) -> Any:
        raise NotImplementedError()

    def visit_parenthesis_float_expr(self, node: TaiheAST.ParenthesisFloatExpr) -> Any:
        return self.visit_float_expr(node)

    def visit_binary_float_expr(self, node: TaiheAST.BinaryFloatExpr) -> Any:
        return self.visit_float_expr(node)

    def visit_unary_float_expr(self, node: TaiheAST.UnaryFloatExpr) -> Any:
        return self.visit_float_expr(node)

    def visit_conditional_float_expr(self, node: TaiheAST.ConditionalFloatExpr) -> Any:
        return self.visit_float_expr(node)

    def visit_literal_float_expr(self, node: TaiheAST.LiteralFloatExpr) -> Any:
        return self.visit_float_expr(node)

    def visit_float_expr(self, node: TaiheAST.FloatExpr) -> Any:
        raise NotImplementedError()

    def visit_conditional_int_expr(self, node: TaiheAST.ConditionalIntExpr) -> Any:
        return self.visit_int_expr(node)

    def visit_parenthesis_int_expr(self, node: TaiheAST.ParenthesisIntExpr) -> Any:
        return self.visit_int_expr(node)

    def visit_unary_int_expr(self, node: TaiheAST.UnaryIntExpr) -> Any:
        return self.visit_int_expr(node)

    def visit_binary_int_expr(self, node: TaiheAST.BinaryIntExpr) -> Any:
        return self.visit_int_expr(node)

    def visit_literal_int_expr(self, node: TaiheAST.LiteralIntExpr) -> Any:
        return self.visit_int_expr(node)

    def visit_binary_int_shift_expr(self, node: TaiheAST.BinaryIntShiftExpr) -> Any:
        return self.visit_int_expr(node)

    def visit_int_expr(self, node: TaiheAST.IntExpr) -> Any:
        raise NotImplementedError()

    def visit_conditional_bool_expr(self, node: TaiheAST.ConditionalBoolExpr) -> Any:
        return self.visit_bool_expr(node)

    def visit_int_comparison_bool_expr(self, node: TaiheAST.IntComparisonBoolExpr) -> Any:
        return self.visit_bool_expr(node)

    def visit_parenthesis_bool_expr(self, node: TaiheAST.ParenthesisBoolExpr) -> Any:
        return self.visit_bool_expr(node)

    def visit_unary_bool_expr(self, node: TaiheAST.UnaryBoolExpr) -> Any:
        return self.visit_bool_expr(node)

    def visit_literal_bool_expr(self, node: TaiheAST.LiteralBoolExpr) -> Any:
        return self.visit_bool_expr(node)

    def visit_float_comparison_bool_expr(self, node: TaiheAST.FloatComparisonBoolExpr) -> Any:
        return self.visit_bool_expr(node)

    def visit_binary_bool_expr(self, node: TaiheAST.BinaryBoolExpr) -> Any:
        return self.visit_bool_expr(node)

    def visit_bool_expr(self, node: TaiheAST.BoolExpr) -> Any:
        raise NotImplementedError()

    def visit_literal_string_expr(self, node: TaiheAST.LiteralStringExpr) -> Any:
        return self.visit_string_expr(node)

    def visit_parenthesis_string_expr(self, node: TaiheAST.ParenthesisStringExpr) -> Any:
        return self.visit_string_expr(node)

    def visit_string_expr(self, node: TaiheAST.StringExpr) -> Any:
        raise NotImplementedError()

