/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.globalParameters;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.DoubleGlobalParameter;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.GlobalParameter;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.GlobalParameterChangedListener;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.MultiplicativeDoubleGlobalParameter;

public class MultiplicativeDoubleGlobalParameterTest {
    private static final boolean VERBOSE = false;
    private final double eps = 1.0E-10;

    @BeforeEach
    public void setUp() {
        GlobalParameter.clearGlobalRegistry();
    }

    @AfterEach
    public void tearDown() {
        GlobalParameter.clearGlobalRegistry();
    }

    @Test
    public void testSetThrowsException() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        double valueA = 4.67;
        double valueB = -765.7654;
        DoubleGlobalParameter doubleGlobalParameterA = new DoubleGlobalParameter("testParameterA", "test description", valueA, systemOutGlobalParameterChangedListener);
        DoubleGlobalParameter doubleGlobalParameterB = new DoubleGlobalParameter("testParameterB", "test description", valueB, systemOutGlobalParameterChangedListener);
        MultiplicativeDoubleGlobalParameter multiplicativeDoubleGlobalParameter = new MultiplicativeDoubleGlobalParameter("testMulti", "multiplicative parameter", new DoubleGlobalParameter[]{doubleGlobalParameterA, doubleGlobalParameterB}, systemOutGlobalParameterChangedListener);
        try {
            multiplicativeDoubleGlobalParameter.set(10.0);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMultiplicativeDoubleGlobalParameter() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        double valueA = 4.67;
        double valueB = -765.7654;
        DoubleGlobalParameter doubleGlobalParameterA = new DoubleGlobalParameter("testParameterA", "test description", valueA, systemOutGlobalParameterChangedListener);
        DoubleGlobalParameter doubleGlobalParameterB = new DoubleGlobalParameter("testParameterB", "test description", valueB, systemOutGlobalParameterChangedListener);
        MultiplicativeDoubleGlobalParameter multiplicativeDoubleGlobalParameter = new MultiplicativeDoubleGlobalParameter("testMulti", "multiplicative parameter", new DoubleGlobalParameter[]{doubleGlobalParameterA, doubleGlobalParameterB}, systemOutGlobalParameterChangedListener);
        Assert.assertEquals((double)(valueA * valueB), (double)multiplicativeDoubleGlobalParameter.getValue(), (double)1.0E-10);
    }

    @Test
    public void testMultiplicativeDoubleGlobalParameterUpdate() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        double valueA = 4.67;
        double valueB = -765.7654;
        DoubleGlobalParameter doubleGlobalParameterA = new DoubleGlobalParameter("testParameterA", "test description", valueA, systemOutGlobalParameterChangedListener);
        DoubleGlobalParameter doubleGlobalParameterB = new DoubleGlobalParameter("testParameterB", "test description", valueB, systemOutGlobalParameterChangedListener);
        MultiplicativeDoubleGlobalParameter multiplicativeDoubleGlobalParameter = new MultiplicativeDoubleGlobalParameter("testMulti", "multiplicative parameter", new DoubleGlobalParameter[]{doubleGlobalParameterA, doubleGlobalParameterB}, systemOutGlobalParameterChangedListener);
        valueA = -795.09;
        doubleGlobalParameterA.set(valueA);
        Assert.assertEquals((double)(valueA * valueB), (double)multiplicativeDoubleGlobalParameter.getValue(), (double)1.0E-10);
        valueB = 0.58674;
        doubleGlobalParameterB.set(valueB);
        Assert.assertEquals((double)(valueA * valueB), (double)multiplicativeDoubleGlobalParameter.getValue(), (double)1.0E-10);
        valueA = 0.0;
        valueB = 345675.866;
        doubleGlobalParameterA.set(valueA);
        doubleGlobalParameterB.set(valueB);
        Assert.assertEquals((double)(valueA * valueB), (double)multiplicativeDoubleGlobalParameter.getValue(), (double)1.0E-10);
    }

    @Test
    public void testFamilyTree() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        double valueA = 4.67;
        double valueB = -765.7654;
        DoubleGlobalParameter grandParentA = new DoubleGlobalParameter("grandParentA", "test descriptionA", valueA, systemOutGlobalParameterChangedListener);
        DoubleGlobalParameter grandParentB = new DoubleGlobalParameter("grandParentB", "test descriptionB", valueB, systemOutGlobalParameterChangedListener);
        MultiplicativeDoubleGlobalParameter parentA = new MultiplicativeDoubleGlobalParameter("parentA", "multiplicative parameter", new DoubleGlobalParameter[]{grandParentA}, systemOutGlobalParameterChangedListener);
        MultiplicativeDoubleGlobalParameter parentB = new MultiplicativeDoubleGlobalParameter("parentB", "multiplicative parameter", new DoubleGlobalParameter[]{grandParentB}, systemOutGlobalParameterChangedListener);
        MultiplicativeDoubleGlobalParameter childA = new MultiplicativeDoubleGlobalParameter("childA", "multiplicative parameter", new DoubleGlobalParameter[]{grandParentA, parentA}, systemOutGlobalParameterChangedListener);
        MultiplicativeDoubleGlobalParameter childB = new MultiplicativeDoubleGlobalParameter("childB", "multiplicative parameter", new DoubleGlobalParameter[]{grandParentA, grandParentB, parentA, parentB}, systemOutGlobalParameterChangedListener);
        double expectedParentA = valueA;
        Assert.assertEquals((double)expectedParentA, (double)parentA.getValue(), (double)1.0E-10);
        double expectedParentB = valueB;
        Assert.assertEquals((double)expectedParentB, (double)parentB.getValue(), (double)1.0E-10);
        double expectedChildA = valueA * valueA;
        Assert.assertEquals((double)expectedChildA, (double)childA.getValue(), (double)1.0E-10);
        double expectedChildB = valueA * valueB * valueA * valueB;
        Assert.assertEquals((double)expectedChildB, (double)childB.getValue(), (double)1.0E-10);
        valueA = -67.835;
        grandParentA.set(valueA);
        expectedParentA = valueA;
        Assert.assertEquals((double)expectedParentA, (double)parentA.getValue(), (double)1.0E-10);
        expectedParentB = valueB;
        Assert.assertEquals((double)expectedParentB, (double)parentB.getValue(), (double)1.0E-10);
        expectedChildA = valueA * valueA;
        Assert.assertEquals((double)expectedChildA, (double)childA.getValue(), (double)1.0E-10);
        expectedChildB = valueA * valueB * valueA * valueB;
        Assert.assertEquals((double)expectedChildB, (double)childB.getValue(), (double)1.0E-10);
        valueA = -67.835;
        valueB = 96485.835;
        grandParentA.set(valueA);
        grandParentB.set(valueB);
        expectedParentA = valueA;
        Assert.assertEquals((double)expectedParentA, (double)parentA.getValue(), (double)1.0E-10);
        expectedParentB = valueB;
        Assert.assertEquals((double)expectedParentB, (double)parentB.getValue(), (double)1.0E-10);
        expectedChildA = valueA * valueA;
        Assert.assertEquals((double)expectedChildA, (double)childA.getValue(), (double)1.0E-10);
        expectedChildB = valueA * valueB * valueA * valueB;
        Assert.assertEquals((double)expectedChildB, (double)childB.getValue(), (double)1.0E-10);
    }
}

