/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.globalParameters;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.GlobalParameter;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.GlobalParameterChangedListener;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.IntGlobalParameter;

public class IntGlobalParameterTest {
    private static final boolean VERBOSE = false;
    private final int DEFAULT_VALUE = 11;

    @BeforeEach
    public void setUp() throws Exception {
        GlobalParameter.clearGlobalRegistry();
    }

    @AfterEach
    public void tearDown() throws Exception {
        GlobalParameter.clearGlobalRegistry();
    }

    @Test
    public void testGetValue() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        IntGlobalParameter intGlobalParameter = new IntGlobalParameter("testParameter", "test description", 11, systemOutGlobalParameterChangedListener);
        Assert.assertEquals((long)11L, (long)intGlobalParameter.getValue());
    }

    @Test
    public void testSetValue() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        IntGlobalParameter intGlobalParameter = new IntGlobalParameter("testParameter", "test description", 11, systemOutGlobalParameterChangedListener);
        int newValue = -1;
        intGlobalParameter.set(newValue);
        Assert.assertEquals((long)newValue, (long)intGlobalParameter.getValue());
        newValue = 1100;
        intGlobalParameter.set(newValue, "setting");
        Assert.assertEquals((long)newValue, (long)intGlobalParameter.getValue());
        newValue = 1100;
        intGlobalParameter.setOnlyIfChange(newValue, "setting");
        Assert.assertEquals((long)newValue, (long)intGlobalParameter.getValue());
        newValue = -906;
        intGlobalParameter.setOnlyIfChange(newValue, "setting");
        Assert.assertEquals((long)newValue, (long)intGlobalParameter.getValue());
    }

    @Test
    public void testThatCantHaveParentsUnlessOverwriteUpdateMethodOne() {
        IntGlobalParameter parent = new IntGlobalParameter("parent", "parent", 11, null);
        IntGlobalParameter invalidChild = new IntGlobalParameter("invalidChild", "test description", new GlobalParameter[]{parent}, null);
        Assertions.assertThrows(RuntimeException.class, () -> parent.set(1));
    }

    @Test
    public void testCantSetChild() {
        IntGlobalParameter parent = new IntGlobalParameter("parent", "", 0, null);
        IntGlobalParameter child = new IntGlobalParameter("child", "", new GlobalParameter[]{parent}, null);
        Assertions.assertThrows(RuntimeException.class, () -> child.set(2, "Shouldn't be able to change this!"));
    }
}

