/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.globalParameters;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.DoubleGlobalParameter;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.GlobalParameter;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.GlobalParameterChangedListener;

public class DoubleGlobalParameterTest {
    private static final boolean VERBOSE = false;
    private final double DEFAULT_VALUE = 11.99;
    private final double eps = 1.0E-10;

    @BeforeEach
    public void setUp() throws Exception {
        GlobalParameter.clearGlobalRegistry();
    }

    @AfterEach
    public void tearDown() throws Exception {
        GlobalParameter.clearGlobalRegistry();
    }

    @Test
    public void testGetValue() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        DoubleGlobalParameter doubleGlobalParameter = new DoubleGlobalParameter("testParameter", "test description", 11.99, systemOutGlobalParameterChangedListener);
        Assert.assertEquals((double)11.99, (double)doubleGlobalParameter.getValue(), (double)1.0E-10);
    }

    @Test
    public void testSetValue() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        DoubleGlobalParameter doubleGlobalParameter = new DoubleGlobalParameter("testParameter", "test description", 11.99, systemOutGlobalParameterChangedListener);
        double newValue = -0.045;
        doubleGlobalParameter.set(newValue);
        Assert.assertEquals((double)newValue, (double)doubleGlobalParameter.getValue(), (double)1.0E-10);
        newValue = 1100.345;
        doubleGlobalParameter.set(newValue, "setting");
        Assert.assertEquals((double)newValue, (double)doubleGlobalParameter.getValue(), (double)1.0E-10);
        newValue = 1100.345;
        doubleGlobalParameter.setOnlyIfChange(newValue, "setting");
        Assert.assertEquals((double)newValue, (double)doubleGlobalParameter.getValue(), (double)1.0E-10);
        newValue = -906.345;
        doubleGlobalParameter.setOnlyIfChange(newValue, "setting");
        Assert.assertEquals((double)newValue, (double)doubleGlobalParameter.getValue(), (double)1.0E-10);
    }

    @Test
    public void testThatCantHaveParentsUnlessOverwriteUpdateMethodOne() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            DoubleGlobalParameter parent = new DoubleGlobalParameter("parent", "parent", 11.99, null);
            new DoubleGlobalParameter("invalidChild", "test description", new GlobalParameter[]{parent}, null);
            parent.set(1.0);
        });
    }

    @Test
    public void testCantSetChild() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            DoubleGlobalParameter parent = new DoubleGlobalParameter("parent", "", 0.7, null);
            DoubleGlobalParameter child = new DoubleGlobalParameter("child", "", new GlobalParameter[]{parent}, null);
            child.set(0.99, "Shouldn't be able to change this!");
        });
    }
}

