/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.gui.EntryBoxArrayPanel;
import us.ihmc.simulationconstructionset.gui.ForcedRepaintPopupMenu;
import us.ihmc.simulationconstructionset.gui.YoEntryBoxTransferHandler;
import us.ihmc.simulationconstructionset.gui.YoGraph;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoEntryBoxNew
extends JPanel
implements MouseListener,
ActionListener,
FocusListener {
    public static final String DEFAULT_EMPTY_ENTRY_BOX_LABEL = "UNUSED";
    private static final long serialVersionUID = -3598041913472018651L;
    private static ArrayList<YoVariableChangedListener> variableChangedListeners = new ArrayList();
    private YoEntryContainer activeEntryContainer;
    private EntryBoxArrayPanel entryBoxArrayPanel;
    private JPopupMenu popupMenu;
    private SelectedVariableHolder selectedVariableHolder;
    private YoVariable variableInThisBox;

    public static void attachVariableChangedListener(YoVariableChangedListener listener) {
        variableChangedListeners.add(listener);
    }

    public static void removeVariableChangedListener(YoVariableChangedListener listener) {
        variableChangedListeners.remove(listener);
    }

    public YoEntryBoxNew(EntryBoxArrayPanel entryBoxArrayPanel, SelectedVariableHolder holder) {
        super(new GridLayout(1, 2));
        this.selectedVariableHolder = holder;
        this.entryBoxArrayPanel = entryBoxArrayPanel;
        this.setOpaque(true);
        this.activeEntryContainer = new YoTextEntryBox(this, DEFAULT_EMPTY_ENTRY_BOX_LABEL);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.setTransferHandler((TransferHandler)new YoEntryBoxTransferHandler());
        this.popupMenu = new ForcedRepaintPopupMenu();
        JMenuItem delete = new JMenuItem("Delete Entry Box");
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (YoEntryBoxNew.this.variableInThisBox != null) {
                    YoEntryBoxNew.this.removeVariable(YoEntryBoxNew.this.variableInThisBox);
                }
            }
        });
        this.popupMenu.add(delete);
        this.setToolTipText(this.activeEntryContainer.getToolTipText());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.activeEntryContainer.actionPerformed(evt);
    }

    public void addVariable(YoVariable variable) {
        if (this.entryBoxArrayPanel != null && this.entryBoxArrayPanel.isHoldingVariable(variable)) {
            return;
        }
        this.activeEntryContainer.bindToVariable(variable);
        this.variableInThisBox = variable;
        String toolTip = this.variableInThisBox.getDescription();
        if (toolTip == null || toolTip.equals("")) {
            toolTip = this.variableInThisBox.getFullNameString();
        }
        this.setToolTipText(toolTip);
        if (this.entryBoxArrayPanel != null) {
            this.entryBoxArrayPanel.checkStatus();
        }
    }

    @Override
    public void focusGained(FocusEvent evt) {
        this.activeEntryContainer.focusGained(evt);
        if (this.entryBoxArrayPanel != null) {
            this.entryBoxArrayPanel.requestFocus();
        } else {
            this.getParent().requestFocus();
        }
    }

    @Override
    public void focusLost(FocusEvent evt) {
        this.activeEntryContainer.focusLost(evt);
        if (evt.getSource().equals(this) && this.popupMenu.isVisible()) {
            this.popupMenu.setVisible(false);
        }
    }

    public int getNumVars() {
        if (this.variableInThisBox != null) {
            return 1;
        }
        return 0;
    }

    public SelectedVariableHolder getSelectedVariableHolder() {
        return this.selectedVariableHolder;
    }

    public YoVariable getVariableInThisBox() {
        return this.variableInThisBox;
    }

    public boolean isHoldingVariable(YoVariable v) {
        return this.variableInThisBox == v;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    public void update() {
        this.activeEntryContainer.update();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.requestFocus();
        if (evt.isMetaDown() && !evt.isAltDown()) {
            this.popupMenu.setLocation(evt.getXOnScreen(), evt.getYOnScreen());
            this.popupMenu.setVisible(true);
        } else if (this.variableInThisBox == null) {
            YoVariable v = this.selectedVariableHolder.getSelectedVariable();
            if (v != null) {
                this.addVariable(v);
            }
        } else {
            this.selectedVariableHolder.setSelectedVariable(this.variableInThisBox);
            if (!evt.isControlDown()) {
                this.getTransferHandler().exportAsDrag(this, evt, 2);
                YoGraph.setActionPerformedByDragAndDrop((int)2);
            } else if (evt.isControlDown()) {
                this.getTransferHandler().exportAsDrag(this, evt, 1);
                YoGraph.setActionPerformedByDragAndDrop((int)1);
            }
            YoGraph.setSourceOfDrag((Object)this);
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    public void removeVariable(YoVariable variable) {
        if (this.variableInThisBox == variable) {
            this.variableInThisBox = null;
            this.activeEntryContainer.removeVariable();
        }
        this.setToolTipText(DEFAULT_EMPTY_ENTRY_BOX_LABEL);
        if (this.entryBoxArrayPanel != null) {
            this.entryBoxArrayPanel.checkStatus();
        }
        if (this.popupMenu.isVisible()) {
            this.popupMenu.setVisible(false);
        }
        this.updateUI();
    }

    public void setVariableInThisBox(YoVariable variableInThisBox) {
        this.activeEntryContainer.bindToVariable(variableInThisBox);
        this.variableInThisBox = variableInThisBox;
        String toolTip = variableInThisBox.getDescription();
        if (toolTip == null || toolTip.equals("")) {
            toolTip = variableInThisBox.getFullNameString();
        }
        this.setToolTipText(toolTip);
    }

    public class YoTextEntryBox
    implements YoEntryContainer,
    ActionListener {
        private YoEntryBoxNew entryBox;
        private JTextField jTextField;
        private JLabel label;
        private NumberFormat numFormat;
        private YoVariable variableInThisBox;

        public YoTextEntryBox(YoEntryBoxNew entryBox, String label) {
            this.entryBox = entryBox;
            this.label = new JLabel(label);
            this.label.setHorizontalAlignment(4);
            this.numFormat = NumberFormat.getInstance();
            this.numFormat.setMaximumFractionDigits(4);
            this.numFormat.setMinimumFractionDigits(1);
            this.numFormat.setGroupingUsed(false);
            this.jTextField = new JTextField("0.0");
            this.jTextField.setHorizontalAlignment(2);
            this.jTextField.addActionListener(this);
            this.jTextField.addFocusListener(entryBox);
            entryBox.add(this.jTextField);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String text = this.jTextField.getText();
            try {
                double val = Double.valueOf(text);
                if (this.variableInThisBox != null) {
                    this.variableInThisBox.setValueFromDouble(val);
                    this.setTextField();
                    this.entryBox.repaint();
                    for (int i = 0; i < variableChangedListeners.size(); ++i) {
                        YoVariableChangedListener listener = (YoVariableChangedListener)variableChangedListeners.get(i);
                        listener.changed(this.variableInThisBox);
                    }
                }
                if (YoEntryBoxNew.this.entryBoxArrayPanel != null) {
                    YoEntryBoxNew.this.entryBoxArrayPanel.requestFocus();
                } else {
                    this.entryBox.getParent().requestFocus();
                }
            }
            catch (NumberFormatException e) {
                this.setTextField();
            }
        }

        @Override
        public void bindToVariable(YoVariable variable) {
            String textName = variable.getName();
            this.label.setText(textName);
            this.setTextField();
        }

        @Override
        public void focusGained(FocusEvent evt) {
            if (this.variableInThisBox != null) {
                this.setTextField();
                this.jTextField.setCaretPosition(1);
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (evt.getSource().equals(this.jTextField) && this.variableInThisBox != null) {
                this.setTextField();
                this.jTextField.setCaretPosition(1);
            }
        }

        public JTextField getjTextField() {
            return this.jTextField;
        }

        public JLabel getLabel() {
            return this.label;
        }

        @Override
        public String getToolTipText() {
            return this.label.getText();
        }

        @Override
        public void removeVariable() {
            this.variableInThisBox = null;
            this.label.setText(YoEntryBoxNew.DEFAULT_EMPTY_ENTRY_BOX_LABEL);
        }

        public void setjTextField(JTextField jTextField) {
            this.jTextField = jTextField;
        }

        public void setLabel(JLabel label) {
            this.label = label;
        }

        @Override
        public void update() {
            this.setTextField();
        }

        public synchronized void setTextField() {
            if (!this.jTextField.hasFocus()) {
                if (this.variableInThisBox != null) {
                    double varInBoxValue = this.variableInThisBox.getValueAsDouble();
                    String textForTextField = this.numFormat.format(varInBoxValue) + " ";
                    if (textForTextField.length() < 15) {
                        for (int i = 0; i < 15 - textForTextField.length(); ++i) {
                            textForTextField = textForTextField + " ";
                        }
                    }
                    this.jTextField.setText(textForTextField);
                } else {
                    this.jTextField.setText(this.numFormat.format(0.0));
                }
                this.jTextField.setCaretPosition(0);
                this.entryBox.updateUI();
            }
        }
    }

    public static interface YoEntryContainer {
        public void bindToVariable(YoVariable var1);

        public void focusGained(FocusEvent var1);

        public void focusLost(FocusEvent var1);

        public void update();

        public String getToolTipText();

        public void removeVariable();

        public void actionPerformed(ActionEvent var1);
    }
}

