/*
 * Decompiled with CFR 0.152.
 */
package jassimp;

import jassimp.AiBone;
import jassimp.AiPrimitiveType;
import jassimp.AiWrapperProvider;
import jassimp.Jassimp;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class AiMesh {
    private final int SIZEOF_FLOAT = Jassimp.NATIVE_FLOAT_SIZE;
    private final int SIZEOF_INT = Jassimp.NATIVE_INT_SIZE;
    private final int SIZEOF_V3D = Jassimp.NATIVE_AIVEKTOR3D_SIZE;
    private static final int NORMALS = 0;
    private static final int TANGENTS = 1;
    private static final int BITANGENTS = 2;
    private static final int COLORSET = 3;
    private static final int TEXCOORDS_1D = 4;
    private static final int TEXCOORDS_2D = 5;
    private static final int TEXCOORDS_3D = 6;
    private final Set<AiPrimitiveType> m_primitiveTypes = EnumSet.noneOf(AiPrimitiveType.class);
    private int m_numVertices = 0;
    private int m_numFaces = 0;
    private int m_materialIndex = -1;
    private String m_name = "";
    private ByteBuffer m_vertices = null;
    private ByteBuffer m_faces = null;
    private ByteBuffer m_faceOffsets = null;
    private ByteBuffer m_normals = null;
    private ByteBuffer m_tangents = null;
    private ByteBuffer m_bitangents = null;
    private ByteBuffer[] m_colorsets = new ByteBuffer[8];
    private int[] m_numUVComponents = new int[8];
    private ByteBuffer[] m_texcoords = new ByteBuffer[8];
    private final List<AiBone> m_bones = new ArrayList<AiBone>();

    private AiMesh() {
    }

    public Set<AiPrimitiveType> getPrimitiveTypes() {
        return this.m_primitiveTypes;
    }

    public boolean isPureTriangle() {
        return this.m_primitiveTypes.contains((Object)AiPrimitiveType.TRIANGLE) && this.m_primitiveTypes.size() == 1;
    }

    public boolean hasPositions() {
        return this.m_vertices != null;
    }

    public boolean hasFaces() {
        return this.m_faces != null;
    }

    public boolean hasNormals() {
        return this.m_normals != null;
    }

    public boolean hasTangentsAndBitangents() {
        return this.m_tangents != null && this.m_tangents != null;
    }

    public boolean hasColors(int colorset) {
        return this.m_colorsets[colorset] != null;
    }

    public boolean hasVertexColors() {
        for (ByteBuffer buf : this.m_colorsets) {
            if (buf == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasTexCoords(int coords) {
        return this.m_texcoords[coords] != null;
    }

    public boolean hasTexCoords() {
        for (ByteBuffer buf : this.m_texcoords) {
            if (buf == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasBones() {
        return !this.m_bones.isEmpty();
    }

    public List<AiBone> getBones() {
        return this.m_bones;
    }

    public int getNumVertices() {
        return this.m_numVertices;
    }

    public int getNumFaces() {
        return this.m_numFaces;
    }

    public int getFaceNumIndices(int face) {
        if (null == this.m_faceOffsets) {
            if (face >= this.m_numFaces || face < 0) {
                throw new IndexOutOfBoundsException("Index: " + face + ", Size: " + this.m_numFaces);
            }
            return 3;
        }
        if (face == this.m_numFaces - 1) {
            return this.m_faces.capacity() / 4 - this.m_faceOffsets.getInt(face * 4);
        }
        return this.m_faceOffsets.getInt((face + 1) * 4) - this.m_faceOffsets.getInt(face * 4);
    }

    public int getNumUVComponents(int coords) {
        return this.m_numUVComponents[coords];
    }

    public int getMaterialIndex() {
        return this.m_materialIndex;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Mesh(").append(this.m_numVertices).append(" vertices, ").append(this.m_numFaces).append(" faces");
        if (this.hasNormals()) {
            buf.append(", normals");
        }
        if (this.hasTangentsAndBitangents()) {
            buf.append(", (bi-)tangents");
        }
        if (this.hasVertexColors()) {
            buf.append(", colors");
        }
        if (this.hasTexCoords()) {
            buf.append(", texCoords");
        }
        buf.append(")");
        return buf.toString();
    }

    public FloatBuffer getPositionBuffer() {
        if (this.m_vertices == null) {
            return null;
        }
        return this.m_vertices.asFloatBuffer();
    }

    public IntBuffer getFaceBuffer() {
        if (this.m_faces == null) {
            return null;
        }
        return this.m_faces.asIntBuffer();
    }

    public IntBuffer getFaceOffsets() {
        if (this.m_faceOffsets == null) {
            return null;
        }
        return this.m_faceOffsets.asIntBuffer();
    }

    public IntBuffer getIndexBuffer() {
        if (!this.isPureTriangle()) {
            throw new UnsupportedOperationException("mesh is not a pure triangle mesh");
        }
        return this.getFaceBuffer();
    }

    public FloatBuffer getNormalBuffer() {
        if (this.m_normals == null) {
            return null;
        }
        return this.m_normals.asFloatBuffer();
    }

    public FloatBuffer getTangentBuffer() {
        if (this.m_tangents == null) {
            return null;
        }
        return this.m_tangents.asFloatBuffer();
    }

    public FloatBuffer getBitangentBuffer() {
        if (this.m_bitangents == null) {
            return null;
        }
        return this.m_bitangents.asFloatBuffer();
    }

    public FloatBuffer getColorBuffer(int colorset) {
        if (this.m_colorsets[colorset] == null) {
            return null;
        }
        return this.m_colorsets[colorset].asFloatBuffer();
    }

    public FloatBuffer getTexCoordBuffer(int coords) {
        if (this.m_texcoords[coords] == null) {
            return null;
        }
        return this.m_texcoords[coords].asFloatBuffer();
    }

    public float getPositionX(int vertex) {
        if (!this.hasPositions()) {
            throw new IllegalStateException("mesh has no positions");
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_vertices.getFloat(vertex * 3 * this.SIZEOF_FLOAT);
    }

    public float getPositionY(int vertex) {
        if (!this.hasPositions()) {
            throw new IllegalStateException("mesh has no positions");
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_vertices.getFloat((vertex * 3 + 1) * this.SIZEOF_FLOAT);
    }

    public float getPositionZ(int vertex) {
        if (!this.hasPositions()) {
            throw new IllegalStateException("mesh has no positions");
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_vertices.getFloat((vertex * 3 + 2) * this.SIZEOF_FLOAT);
    }

    public int getFaceVertex(int face, int n) {
        if (!this.hasFaces()) {
            throw new IllegalStateException("mesh has no faces");
        }
        if (face >= this.m_numFaces || face < 0) {
            throw new IndexOutOfBoundsException("Index: " + face + ", Size: " + this.m_numFaces);
        }
        if (n >= this.getFaceNumIndices(face) || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.getFaceNumIndices(face));
        }
        int faceOffset = 0;
        faceOffset = this.m_faceOffsets == null ? 3 * face * this.SIZEOF_INT : this.m_faceOffsets.getInt(face * this.SIZEOF_INT) * this.SIZEOF_INT;
        return this.m_faces.getInt(faceOffset + n * this.SIZEOF_INT);
    }

    public float getNormalX(int vertex) {
        if (!this.hasNormals()) {
            throw new IllegalStateException("mesh has no normals");
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_normals.getFloat(vertex * 3 * this.SIZEOF_FLOAT);
    }

    public float getNormalY(int vertex) {
        if (!this.hasNormals()) {
            throw new IllegalStateException("mesh has no normals");
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_normals.getFloat((vertex * 3 + 1) * this.SIZEOF_FLOAT);
    }

    public float getNormalZ(int vertex) {
        if (!this.hasNormals()) {
            throw new IllegalStateException("mesh has no normals");
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_normals.getFloat((vertex * 3 + 2) * this.SIZEOF_FLOAT);
    }

    public float getTangentX(int vertex) {
        if (!this.hasTangentsAndBitangents()) {
            throw new IllegalStateException("mesh has no tangents");
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_tangents.getFloat(vertex * 3 * this.SIZEOF_FLOAT);
    }

    public float getTangentY(int vertex) {
        if (!this.hasTangentsAndBitangents()) {
            throw new IllegalStateException("mesh has no bitangents");
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_tangents.getFloat((vertex * 3 + 1) * this.SIZEOF_FLOAT);
    }

    public float getTangentZ(int vertex) {
        if (!this.hasTangentsAndBitangents()) {
            throw new IllegalStateException("mesh has no tangents");
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_tangents.getFloat((vertex * 3 + 2) * this.SIZEOF_FLOAT);
    }

    public float getBitangentX(int vertex) {
        if (!this.hasTangentsAndBitangents()) {
            throw new IllegalStateException("mesh has no bitangents");
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_bitangents.getFloat(vertex * 3 * this.SIZEOF_FLOAT);
    }

    public float getBitangentY(int vertex) {
        if (!this.hasTangentsAndBitangents()) {
            throw new IllegalStateException("mesh has no bitangents");
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_bitangents.getFloat((vertex * 3 + 1) * this.SIZEOF_FLOAT);
    }

    public float getBitangentZ(int vertex) {
        if (!this.hasTangentsAndBitangents()) {
            throw new IllegalStateException("mesh has no bitangents");
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_bitangents.getFloat((vertex * 3 + 2) * this.SIZEOF_FLOAT);
    }

    public float getColorR(int vertex, int colorset) {
        if (!this.hasColors(colorset)) {
            throw new IllegalStateException("mesh has no colorset " + colorset);
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_colorsets[colorset].getFloat(vertex * 4 * this.SIZEOF_FLOAT);
    }

    public float getColorG(int vertex, int colorset) {
        if (!this.hasColors(colorset)) {
            throw new IllegalStateException("mesh has no colorset " + colorset);
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_colorsets[colorset].getFloat((vertex * 4 + 1) * this.SIZEOF_FLOAT);
    }

    public float getColorB(int vertex, int colorset) {
        if (!this.hasColors(colorset)) {
            throw new IllegalStateException("mesh has no colorset " + colorset);
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_colorsets[colorset].getFloat((vertex * 4 + 2) * this.SIZEOF_FLOAT);
    }

    public float getColorA(int vertex, int colorset) {
        if (!this.hasColors(colorset)) {
            throw new IllegalStateException("mesh has no colorset " + colorset);
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_colorsets[colorset].getFloat((vertex * 4 + 3) * this.SIZEOF_FLOAT);
    }

    public float getTexCoordU(int vertex, int coords) {
        if (!this.hasTexCoords(coords)) {
            throw new IllegalStateException("mesh has no texture coordinate set " + coords);
        }
        this.checkVertexIndexBounds(vertex);
        return this.m_texcoords[coords].getFloat(vertex * this.m_numUVComponents[coords] * this.SIZEOF_FLOAT);
    }

    public float getTexCoordV(int vertex, int coords) {
        if (!this.hasTexCoords(coords)) {
            throw new IllegalStateException("mesh has no texture coordinate set " + coords);
        }
        this.checkVertexIndexBounds(vertex);
        if (this.getNumUVComponents(coords) < 2) {
            throw new IllegalArgumentException("coordinate set " + coords + " does not contain 2D texture coordinates");
        }
        return this.m_texcoords[coords].getFloat((vertex * this.m_numUVComponents[coords] + 1) * this.SIZEOF_FLOAT);
    }

    public float getTexCoordW(int vertex, int coords) {
        if (!this.hasTexCoords(coords)) {
            throw new IllegalStateException("mesh has no texture coordinate set " + coords);
        }
        this.checkVertexIndexBounds(vertex);
        if (this.getNumUVComponents(coords) < 3) {
            throw new IllegalArgumentException("coordinate set " + coords + " does not contain 3D texture coordinates");
        }
        return this.m_texcoords[coords].getFloat((vertex * this.m_numUVComponents[coords] + 1) * this.SIZEOF_FLOAT);
    }

    public <V3, M4, C, N, Q> V3 getWrappedPosition(int vertex, AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        if (!this.hasPositions()) {
            throw new IllegalStateException("mesh has no positions");
        }
        this.checkVertexIndexBounds(vertex);
        return wrapperProvider.wrapVector3f(this.m_vertices, vertex * 3 * this.SIZEOF_FLOAT, 3);
    }

    public <V3, M4, C, N, Q> V3 getWrappedNormal(int vertex, AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        if (!this.hasNormals()) {
            throw new IllegalStateException("mesh has no positions");
        }
        this.checkVertexIndexBounds(vertex);
        return wrapperProvider.wrapVector3f(this.m_normals, vertex * 3 * this.SIZEOF_FLOAT, 3);
    }

    public <V3, M4, C, N, Q> V3 getWrappedTangent(int vertex, AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        if (!this.hasTangentsAndBitangents()) {
            throw new IllegalStateException("mesh has no tangents");
        }
        this.checkVertexIndexBounds(vertex);
        return wrapperProvider.wrapVector3f(this.m_tangents, vertex * 3 * this.SIZEOF_FLOAT, 3);
    }

    public <V3, M4, C, N, Q> V3 getWrappedBitangent(int vertex, AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        if (!this.hasTangentsAndBitangents()) {
            throw new IllegalStateException("mesh has no bitangents");
        }
        this.checkVertexIndexBounds(vertex);
        return wrapperProvider.wrapVector3f(this.m_bitangents, vertex * 3 * this.SIZEOF_FLOAT, 3);
    }

    public <V3, M4, C, N, Q> C getWrappedColor(int vertex, int colorset, AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        if (!this.hasColors(colorset)) {
            throw new IllegalStateException("mesh has no colorset " + colorset);
        }
        this.checkVertexIndexBounds(vertex);
        return wrapperProvider.wrapColor(this.m_colorsets[colorset], vertex * 4 * this.SIZEOF_FLOAT);
    }

    public <V3, M4, C, N, Q> V3 getWrappedTexCoords(int vertex, int coords, AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        if (!this.hasTexCoords(coords)) {
            throw new IllegalStateException("mesh has no texture coordinate set " + coords);
        }
        this.checkVertexIndexBounds(vertex);
        return wrapperProvider.wrapVector3f(this.m_texcoords[coords], vertex * 3 * this.SIZEOF_FLOAT, this.getNumUVComponents(coords));
    }

    private void checkVertexIndexBounds(int vertex) {
        if (vertex >= this.m_numVertices || vertex < 0) {
            throw new IndexOutOfBoundsException("Index: " + vertex + ", Size: " + this.m_numVertices);
        }
    }

    private void setPrimitiveTypes(int types) {
        AiPrimitiveType.fromRawValue(this.m_primitiveTypes, types);
    }

    private void allocateBuffers(int numVertices, int numFaces, boolean optimizedFaces, int faceBufferSize) {
        if (optimizedFaces && !this.isPureTriangle()) {
            throw new IllegalArgumentException("mesh is not purely triangular");
        }
        this.m_numVertices = numVertices;
        this.m_numFaces = numFaces;
        if (this.m_numVertices > 0) {
            this.m_vertices = ByteBuffer.allocateDirect(numVertices * 3 * this.SIZEOF_FLOAT);
            this.m_vertices.order(ByteOrder.nativeOrder());
        }
        if (this.m_numFaces > 0) {
            if (optimizedFaces) {
                this.m_faces = ByteBuffer.allocateDirect(numFaces * 3 * this.SIZEOF_INT);
                this.m_faces.order(ByteOrder.nativeOrder());
            } else {
                this.m_faces = ByteBuffer.allocateDirect(faceBufferSize);
                this.m_faces.order(ByteOrder.nativeOrder());
                this.m_faceOffsets = ByteBuffer.allocateDirect(numFaces * this.SIZEOF_INT);
                this.m_faceOffsets.order(ByteOrder.nativeOrder());
            }
        }
    }

    private void allocateDataChannel(int channelType, int channelIndex) {
        switch (channelType) {
            case 0: {
                this.m_normals = ByteBuffer.allocateDirect(this.m_numVertices * 3 * this.SIZEOF_FLOAT);
                this.m_normals.order(ByteOrder.nativeOrder());
                break;
            }
            case 1: {
                this.m_tangents = ByteBuffer.allocateDirect(this.m_numVertices * 3 * this.SIZEOF_FLOAT);
                this.m_tangents.order(ByteOrder.nativeOrder());
                break;
            }
            case 2: {
                this.m_bitangents = ByteBuffer.allocateDirect(this.m_numVertices * 3 * this.SIZEOF_FLOAT);
                this.m_bitangents.order(ByteOrder.nativeOrder());
                break;
            }
            case 3: {
                this.m_colorsets[channelIndex] = ByteBuffer.allocateDirect(this.m_numVertices * 4 * this.SIZEOF_FLOAT);
                this.m_colorsets[channelIndex].order(ByteOrder.nativeOrder());
                break;
            }
            case 4: {
                this.m_numUVComponents[channelIndex] = 1;
                this.m_texcoords[channelIndex] = ByteBuffer.allocateDirect(this.m_numVertices * 1 * this.SIZEOF_FLOAT);
                this.m_texcoords[channelIndex].order(ByteOrder.nativeOrder());
                break;
            }
            case 5: {
                this.m_numUVComponents[channelIndex] = 2;
                this.m_texcoords[channelIndex] = ByteBuffer.allocateDirect(this.m_numVertices * 2 * this.SIZEOF_FLOAT);
                this.m_texcoords[channelIndex].order(ByteOrder.nativeOrder());
                break;
            }
            case 6: {
                this.m_numUVComponents[channelIndex] = 3;
                this.m_texcoords[channelIndex] = ByteBuffer.allocateDirect(this.m_numVertices * 3 * this.SIZEOF_FLOAT);
                this.m_texcoords[channelIndex].order(ByteOrder.nativeOrder());
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported channel type");
            }
        }
    }
}

