/*
 * Decompiled with CFR 0.152.
 */
package jassimp;

import jassimp.AiBlendMode;
import jassimp.AiShadingMode;
import jassimp.AiTextureInfo;
import jassimp.AiTextureMapMode;
import jassimp.AiTextureOp;
import jassimp.AiTextureType;
import jassimp.AiWrapperProvider;
import jassimp.Jassimp;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AiMaterial {
    private Map<PropertyKey, Object> m_defaults = new EnumMap<PropertyKey, Object>(PropertyKey.class);
    private final List<Property> m_properties;
    private final Map<AiTextureType, Integer> m_numTextures;

    AiMaterial() {
        this.setDefault(PropertyKey.NAME, "");
        this.setDefault(PropertyKey.TWO_SIDED, 0);
        this.setDefault(PropertyKey.SHADING_MODE, (Object)AiShadingMode.FLAT);
        this.setDefault(PropertyKey.WIREFRAME, 0);
        this.setDefault(PropertyKey.BLEND_MODE, (Object)AiBlendMode.DEFAULT);
        this.setDefault(PropertyKey.OPACITY, Float.valueOf(1.0f));
        this.setDefault(PropertyKey.BUMP_SCALING, Float.valueOf(1.0f));
        this.setDefault(PropertyKey.SHININESS, Float.valueOf(1.0f));
        this.setDefault(PropertyKey.REFLECTIVITY, Float.valueOf(0.0f));
        this.setDefault(PropertyKey.SHININESS_STRENGTH, Float.valueOf(0.0f));
        this.setDefault(PropertyKey.REFRACTI, Float.valueOf(0.0f));
        this.m_defaults.put(PropertyKey.COLOR_DIFFUSE, null);
        this.m_defaults.put(PropertyKey.COLOR_AMBIENT, null);
        this.m_defaults.put(PropertyKey.COLOR_SPECULAR, null);
        this.m_defaults.put(PropertyKey.COLOR_EMISSIVE, null);
        this.m_defaults.put(PropertyKey.COLOR_TRANSPARENT, null);
        this.m_defaults.put(PropertyKey.COLOR_REFLECTIVE, null);
        this.setDefault(PropertyKey.GLOBAL_BACKGROUND_IMAGE, "");
        this.setDefault(PropertyKey.TEX_FILE, "");
        this.setDefault(PropertyKey.TEX_UV_INDEX, 0);
        this.setDefault(PropertyKey.TEX_BLEND, Float.valueOf(1.0f));
        this.setDefault(PropertyKey.TEX_OP, (Object)AiTextureOp.ADD);
        this.setDefault(PropertyKey.TEX_MAP_MODE_U, (Object)AiTextureMapMode.CLAMP);
        this.setDefault(PropertyKey.TEX_MAP_MODE_V, (Object)AiTextureMapMode.CLAMP);
        this.setDefault(PropertyKey.TEX_MAP_MODE_W, (Object)AiTextureMapMode.CLAMP);
        for (PropertyKey key : PropertyKey.values()) {
            if (this.m_defaults.containsKey((Object)key)) continue;
            throw new IllegalStateException("missing default for: " + (Object)((Object)key));
        }
        this.m_properties = new ArrayList<Property>();
        this.m_numTextures = new EnumMap<AiTextureType, Integer>(AiTextureType.class);
    }

    public boolean hasProperties(Set<PropertyKey> keys) {
        for (PropertyKey key : keys) {
            if (null != this.getProperty(key.m_key)) continue;
            return false;
        }
        return true;
    }

    public void setDefault(PropertyKey key, Object defaultValue) {
        if (null == defaultValue) {
            throw new IllegalArgumentException("defaultValue may not be null");
        }
        if (key.m_type != defaultValue.getClass()) {
            throw new IllegalArgumentException("defaultValue has wrong type, expected: " + key.m_type + ", found: " + defaultValue.getClass());
        }
        this.m_defaults.put(key, defaultValue);
    }

    public String getName() {
        return this.getTyped(PropertyKey.NAME, String.class);
    }

    public int getTwoSided() {
        return this.getTyped(PropertyKey.TWO_SIDED, Integer.class);
    }

    public AiShadingMode getShadingMode() {
        Property p = this.getProperty(PropertyKey.SHADING_MODE.m_key);
        if (null == p || null == p.getData()) {
            return (AiShadingMode)((Object)this.m_defaults.get((Object)PropertyKey.SHADING_MODE));
        }
        return AiShadingMode.fromRawValue((Integer)p.getData());
    }

    public int getWireframe() {
        return this.getTyped(PropertyKey.WIREFRAME, Integer.class);
    }

    public AiBlendMode getBlendMode() {
        Property p = this.getProperty(PropertyKey.BLEND_MODE.m_key);
        if (null == p || null == p.getData()) {
            return (AiBlendMode)((Object)this.m_defaults.get((Object)PropertyKey.BLEND_MODE));
        }
        return AiBlendMode.fromRawValue((Integer)p.getData());
    }

    public float getOpacity() {
        return this.getTyped(PropertyKey.OPACITY, Float.class).floatValue();
    }

    public float getBumpScaling() {
        return this.getTyped(PropertyKey.BUMP_SCALING, Float.class).floatValue();
    }

    public float getShininess() {
        return this.getTyped(PropertyKey.SHININESS, Float.class).floatValue();
    }

    public float getReflectivity() {
        return this.getTyped(PropertyKey.REFLECTIVITY, Float.class).floatValue();
    }

    public float getShininessStrength() {
        return this.getTyped(PropertyKey.SHININESS_STRENGTH, Float.class).floatValue();
    }

    public float getRefractIndex() {
        return this.getTyped(PropertyKey.REFRACTI, Float.class).floatValue();
    }

    public <V3, M4, C, N, Q> C getDiffuseColor(AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        Property p = this.getProperty(PropertyKey.COLOR_DIFFUSE.m_key);
        if (null == p || null == p.getData()) {
            Object def = this.m_defaults.get((Object)PropertyKey.COLOR_DIFFUSE);
            if (def == null) {
                return (C)Jassimp.wrapColor4(1.0f, 1.0f, 1.0f, 1.0f);
            }
            return (C)def;
        }
        return (C)p.getData();
    }

    public <V3, M4, C, N, Q> C getAmbientColor(AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        Property p = this.getProperty(PropertyKey.COLOR_AMBIENT.m_key);
        if (null == p || null == p.getData()) {
            Object def = this.m_defaults.get((Object)PropertyKey.COLOR_AMBIENT);
            if (def == null) {
                return (C)Jassimp.wrapColor4(1.0f, 1.0f, 1.0f, 1.0f);
            }
            return (C)def;
        }
        return (C)p.getData();
    }

    public <V3, M4, C, N, Q> C getSpecularColor(AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        Property p = this.getProperty(PropertyKey.COLOR_SPECULAR.m_key);
        if (null == p || null == p.getData()) {
            Object def = this.m_defaults.get((Object)PropertyKey.COLOR_SPECULAR);
            if (def == null) {
                return (C)Jassimp.wrapColor4(1.0f, 1.0f, 1.0f, 1.0f);
            }
            return (C)def;
        }
        return (C)p.getData();
    }

    public <V3, M4, C, N, Q> C getEmissiveColor(AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        Property p = this.getProperty(PropertyKey.COLOR_EMISSIVE.m_key);
        if (null == p || null == p.getData()) {
            Object def = this.m_defaults.get((Object)PropertyKey.COLOR_EMISSIVE);
            if (def == null) {
                return (C)Jassimp.wrapColor4(1.0f, 1.0f, 1.0f, 1.0f);
            }
            return (C)def;
        }
        return (C)p.getData();
    }

    public <V3, M4, C, N, Q> C getTransparentColor(AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        Property p = this.getProperty(PropertyKey.COLOR_TRANSPARENT.m_key);
        if (null == p || null == p.getData()) {
            Object def = this.m_defaults.get((Object)PropertyKey.COLOR_TRANSPARENT);
            if (def == null) {
                return (C)Jassimp.wrapColor4(1.0f, 1.0f, 1.0f, 1.0f);
            }
            return (C)def;
        }
        return (C)p.getData();
    }

    public <V3, M4, C, N, Q> C getReflectiveColor(AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        Property p = this.getProperty(PropertyKey.COLOR_REFLECTIVE.m_key);
        if (null == p || null == p.getData()) {
            Object def = this.m_defaults.get((Object)PropertyKey.COLOR_REFLECTIVE);
            if (def == null) {
                return (C)Jassimp.wrapColor4(1.0f, 1.0f, 1.0f, 1.0f);
            }
            return (C)def;
        }
        return (C)p.getData();
    }

    public String getGlobalBackgroundImage() {
        return this.getTyped(PropertyKey.GLOBAL_BACKGROUND_IMAGE, String.class);
    }

    public int getNumTextures(AiTextureType type) {
        return this.m_numTextures.get((Object)type);
    }

    public String getTextureFile(AiTextureType type, int index) {
        this.checkTexRange(type, index);
        return this.getTyped(PropertyKey.TEX_FILE, type, index, String.class);
    }

    public int getTextureUVIndex(AiTextureType type, int index) {
        this.checkTexRange(type, index);
        return this.getTyped(PropertyKey.TEX_UV_INDEX, type, index, Integer.class);
    }

    public float getBlendFactor(AiTextureType type, int index) {
        this.checkTexRange(type, index);
        return this.getTyped(PropertyKey.TEX_BLEND, type, index, Float.class).floatValue();
    }

    public AiTextureOp getTextureOp(AiTextureType type, int index) {
        this.checkTexRange(type, index);
        Property p = this.getProperty(PropertyKey.TEX_OP.m_key);
        if (null == p || null == p.getData()) {
            return (AiTextureOp)((Object)this.m_defaults.get((Object)PropertyKey.TEX_OP));
        }
        return AiTextureOp.fromRawValue((Integer)p.getData());
    }

    public AiTextureMapMode getTextureMapModeU(AiTextureType type, int index) {
        this.checkTexRange(type, index);
        Property p = this.getProperty(PropertyKey.TEX_MAP_MODE_U.m_key);
        if (null == p || null == p.getData()) {
            return (AiTextureMapMode)((Object)this.m_defaults.get((Object)PropertyKey.TEX_MAP_MODE_U));
        }
        return AiTextureMapMode.fromRawValue((Integer)p.getData());
    }

    public AiTextureMapMode getTextureMapModeV(AiTextureType type, int index) {
        this.checkTexRange(type, index);
        Property p = this.getProperty(PropertyKey.TEX_MAP_MODE_V.m_key);
        if (null == p || null == p.getData()) {
            return (AiTextureMapMode)((Object)this.m_defaults.get((Object)PropertyKey.TEX_MAP_MODE_V));
        }
        return AiTextureMapMode.fromRawValue((Integer)p.getData());
    }

    public AiTextureMapMode getTextureMapModeW(AiTextureType type, int index) {
        this.checkTexRange(type, index);
        Property p = this.getProperty(PropertyKey.TEX_MAP_MODE_W.m_key);
        if (null == p || null == p.getData()) {
            return (AiTextureMapMode)((Object)this.m_defaults.get((Object)PropertyKey.TEX_MAP_MODE_W));
        }
        return AiTextureMapMode.fromRawValue((Integer)p.getData());
    }

    public AiTextureInfo getTextureInfo(AiTextureType type, int index) {
        return new AiTextureInfo(type, index, this.getTextureFile(type, index), this.getTextureUVIndex(type, index), this.getBlendFactor(type, index), this.getTextureOp(type, index), this.getTextureMapModeW(type, index), this.getTextureMapModeW(type, index), this.getTextureMapModeW(type, index));
    }

    public Property getProperty(String key) {
        for (Property property : this.m_properties) {
            if (!property.getKey().equals(key)) continue;
            return property;
        }
        return null;
    }

    public Property getProperty(String key, int semantic, int index) {
        for (Property property : this.m_properties) {
            if (!property.getKey().equals(key) || property.m_semantic != semantic || property.m_index != index) continue;
            return property;
        }
        return null;
    }

    public List<Property> getProperties() {
        return this.m_properties;
    }

    private <T> T getTyped(PropertyKey key, Class<T> clazz) {
        Property p = this.getProperty(key.m_key);
        if (null == p || null == p.getData()) {
            return clazz.cast(this.m_defaults.get((Object)key));
        }
        return clazz.cast(p.getData());
    }

    private <T> T getTyped(PropertyKey key, AiTextureType type, int index, Class<T> clazz) {
        Property p = this.getProperty(key.m_key, AiTextureType.toRawValue(type), index);
        if (null == p || null == p.getData()) {
            return clazz.cast(this.m_defaults.get((Object)key));
        }
        return clazz.cast(p.getData());
    }

    private void checkTexRange(AiTextureType type, int index) {
        if (index < 0 || index > this.m_numTextures.get((Object)type)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.m_numTextures.get((Object)type));
        }
    }

    private void setTextureNumber(int type, int number) {
        this.m_numTextures.put(AiTextureType.fromRawValue(type), number);
    }

    public static enum PropertyKey {
        NAME("?mat.name", String.class),
        TWO_SIDED("$mat.twosided", Integer.class),
        SHADING_MODE("$mat.shadingm", AiShadingMode.class),
        WIREFRAME("$mat.wireframe", Integer.class),
        BLEND_MODE("$mat.blend", AiBlendMode.class),
        OPACITY("$mat.opacity", Float.class),
        BUMP_SCALING("$mat.bumpscaling", Float.class),
        SHININESS("$mat.shininess", Float.class),
        REFLECTIVITY("$mat.reflectivity", Float.class),
        SHININESS_STRENGTH("$mat.shinpercent", Float.class),
        REFRACTI("$mat.refracti", Float.class),
        COLOR_DIFFUSE("$clr.diffuse", Object.class),
        COLOR_AMBIENT("$clr.ambient", Object.class),
        COLOR_SPECULAR("$clr.specular", Object.class),
        COLOR_EMISSIVE("$clr.emissive", Object.class),
        COLOR_TRANSPARENT("$clr.transparent", Object.class),
        COLOR_REFLECTIVE("$clr.reflective", Object.class),
        GLOBAL_BACKGROUND_IMAGE("?bg.global", String.class),
        TEX_FILE("$tex.file", String.class),
        TEX_UV_INDEX("$tex.uvwsrc", Integer.class),
        TEX_BLEND("$tex.blend", Float.class),
        TEX_OP("$tex.op", AiTextureOp.class),
        TEX_MAP_MODE_U("$tex.mapmodeu", AiTextureMapMode.class),
        TEX_MAP_MODE_V("$tex.mapmodev", AiTextureMapMode.class),
        TEX_MAP_MODE_W("$tex.mapmodew", AiTextureMapMode.class);

        private final String m_key;
        private final Class<?> m_type;

        private PropertyKey(String key, Class<?> type) {
            this.m_key = key;
            this.m_type = type;
        }
    }

    public static final class Property {
        private final String m_key;
        private final int m_semantic;
        private final int m_index;
        private final PropertyType m_type;
        private final Object m_data;

        Property(String key, int semantic, int index, int type, Object data) {
            this.m_key = key;
            this.m_semantic = semantic;
            this.m_index = index;
            this.m_type = PropertyType.fromRawValue(type);
            this.m_data = data;
        }

        Property(String key, int semantic, int index, int type, int dataLen) {
            this.m_key = key;
            this.m_semantic = semantic;
            this.m_index = index;
            this.m_type = PropertyType.fromRawValue(type);
            ByteBuffer b = ByteBuffer.allocateDirect(dataLen);
            b.order(ByteOrder.nativeOrder());
            this.m_data = b;
        }

        public String getKey() {
            return this.m_key;
        }

        public int getSemantic() {
            return this.m_semantic;
        }

        public int getIndex() {
            return this.m_index;
        }

        public PropertyType getType() {
            return this.m_type;
        }

        Object getData() {
            return this.m_data;
        }
    }

    public static enum PropertyType {
        FLOAT(1),
        STRING(3),
        INTEGER(4),
        BUFFER(5);

        private final int m_rawValue;

        static PropertyType fromRawValue(int rawValue) {
            for (PropertyType type : PropertyType.values()) {
                if (type.m_rawValue != rawValue) continue;
                return type;
            }
            throw new IllegalArgumentException("unexptected raw value: " + rawValue);
        }

        private PropertyType(int rawValue) {
            this.m_rawValue = rawValue;
        }
    }
}

