/*
 * Decompiled with CFR 0.152.
 */
package jassimp;

import jassimp.AiLightType;
import jassimp.AiWrapperProvider;

public final class AiLight {
    private final String m_name;
    private final AiLightType m_type;
    private final Object m_position;
    private final Object m_direction;
    private final float m_attenuationConstant;
    private final float m_attenuationLinear;
    private final float m_attenuationQuadratic;
    private final Object m_diffuse;
    private final Object m_specular;
    private final Object m_ambient;
    private final float m_innerCone;
    private final float m_outerCone;

    AiLight(String name, int type, Object position, Object direction, float attenuationConstant, float attenuationLinear, float attenuationQuadratic, Object diffuse, Object specular, Object ambient, float innerCone, float outerCone) {
        this.m_name = name;
        this.m_type = AiLightType.fromRawValue(type);
        this.m_position = position;
        this.m_direction = direction;
        this.m_attenuationConstant = attenuationConstant;
        this.m_attenuationLinear = attenuationLinear;
        this.m_attenuationQuadratic = attenuationQuadratic;
        this.m_diffuse = diffuse;
        this.m_specular = specular;
        this.m_ambient = ambient;
        this.m_innerCone = innerCone;
        this.m_outerCone = outerCone;
    }

    public String getName() {
        return this.m_name;
    }

    public AiLightType getType() {
        return this.m_type;
    }

    public <V3, M4, C, N, Q> V3 getPosition(AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        return (V3)this.m_position;
    }

    public <V3, M4, C, N, Q> V3 getDirection(AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        return (V3)this.m_direction;
    }

    public float getAttenuationConstant() {
        return this.m_attenuationConstant;
    }

    public float getAttenuationLinear() {
        return this.m_attenuationLinear;
    }

    public float getAttenuationQuadratic() {
        return this.m_attenuationQuadratic;
    }

    public <V3, M4, C, N, Q> C getColorDiffuse(AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        return (C)this.m_diffuse;
    }

    public <V3, M4, C, N, Q> C getColorSpecular(AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        return (C)this.m_specular;
    }

    public <V3, M4, C, N, Q> C getColorAmbient(AiWrapperProvider<V3, M4, C, N, Q> wrapperProvider) {
        return (C)this.m_ambient;
    }

    public float getAngleInnerCone() {
        return this.m_innerCone;
    }

    public float getAngleOuterCone() {
        return this.m_outerCone;
    }
}

