/*
 * Decompiled with CFR 0.152.
 */
package jassimp;

import jassimp.AiIOStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;

public class AiInputStreamIOStream
implements AiIOStream {
    private final ByteArrayOutputStream os = new ByteArrayOutputStream();

    public AiInputStreamIOStream(URI uri) throws IOException {
        this(uri.toURL());
    }

    public AiInputStreamIOStream(URL url) throws IOException {
        this(url.openStream());
    }

    public AiInputStreamIOStream(InputStream is) throws IOException {
        int read;
        byte[] data = new byte[1024];
        while ((read = is.read(data, 0, data.length)) != -1) {
            this.os.write(data, 0, read);
        }
        this.os.flush();
        is.close();
    }

    @Override
    public int getFileSize() {
        return this.os.size();
    }

    @Override
    public boolean read(ByteBuffer buffer) {
        ByteBufferOutputStream bos = new ByteBufferOutputStream(buffer);
        try {
            this.os.writeTo(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static class ByteBufferOutputStream
    extends OutputStream {
        private final ByteBuffer buffer;

        public ByteBufferOutputStream(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.put((byte)b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.buffer.put(b, off, len);
        }
    }
}

