/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.realtime;

import us.ihmc.affinity.CPUTopology;
import us.ihmc.affinity.Processor;
import us.ihmc.realtime.CPUDMALatency;
import us.ihmc.realtime.MonotonicTime;
import us.ihmc.realtime.PeriodicParameters;
import us.ihmc.realtime.PriorityParameters;
import us.ihmc.realtime.RealtimeThread;

public class TestCyclic {
    public static void main(String[] args) throws InterruptedException {
        boolean endless;
        int periodInNS = 1000000;
        int iterations = 60000;
        double duration = 60.0;
        boolean bl = endless = args.length > 0 && args[0].equals("--endless");
        if (endless) {
            System.out.println("You can cancel this test by pressing Ctrl+C");
        } else {
            System.out.println("Iteration count: 60000");
            System.out.println("Estimated duration: 60.0 seconds");
        }
        CPUDMALatency.setLatency(0);
        PriorityParameters priorityParameters = new PriorityParameters(99);
        PeriodicParameters periodicParameters = new PeriodicParameters(new MonotonicTime(0L, 1000000L));
        RealtimeThread periodicRealtimeThread = new RealtimeThread(priorityParameters, periodicParameters){

            private void perform(int run) {
                long previousTime = 0L;
                long avgJitter = 0L;
                long maxJitter = 0L;
                for (int i = -1; i < 60000; ++i) {
                    super.waitForNextPeriod();
                    if (i < 0) {
                        previousTime = System.nanoTime();
                        continue;
                    }
                    long newTime = System.nanoTime();
                    long jitter = Math.abs(newTime - previousTime - 1000000L);
                    if (jitter > maxJitter) {
                        maxJitter = jitter;
                    }
                    avgJitter += jitter;
                    previousTime = newTime;
                }
                double usAvgJitter = (double)avgJitter / 60000.0 / 1000.0;
                double usMaxJitter = (double)maxJitter / 1000.0;
                System.out.format("[%d] Jitter: avg = %.4f us, max = %.4f us%n", run, usAvgJitter, usMaxJitter);
            }

            @Override
            public void run() {
                int run = 1;
                do {
                    this.perform(run++);
                } while (endless);
            }
        };
        System.out.println("Pinning the periodic thread to processor 1");
        Processor testProcessor = new CPUTopology().getPackage(0).getCore(1).getDefaultProcessor();
        periodicRealtimeThread.setAffinity(testProcessor);
        periodicRealtimeThread.start();
        periodicRealtimeThread.join();
    }
}

