/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.realtime;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CPUDMALatency {
    private final FileOutputStream dev;
    private final byte[] converterData = new byte[4];
    private final ByteBuffer converter = ByteBuffer.wrap(this.converterData);
    private static CPUDMALatency cpudmaLatency = null;

    private CPUDMALatency(int latency) throws IOException {
        this.dev = new FileOutputStream("/dev/cpu_dma_latency");
        this.converter.order(ByteOrder.nativeOrder());
        this.converter.putInt(0, latency);
        this.dev.write(this.converterData);
    }

    private void close() throws IOException {
        this.dev.close();
    }

    public static synchronized boolean setLatency(int latencyInUs) {
        if (cpudmaLatency == null) {
            try {
                cpudmaLatency = new CPUDMALatency(latencyInUs);
            }
            catch (IOException e) {
                System.err.println("Cannot set desired CPU DMA latency");
                return false;
            }
            return true;
        }
        throw new RuntimeException("CPU DMA Latency has already been set");
    }

    public static synchronized void unsetLatency() {
        if (cpudmaLatency != null) {
            try {
                cpudmaLatency.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } else {
            throw new RuntimeException("CPU DMA Latency has not been set");
        }
        cpudmaLatency = null;
    }
}

