/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.affinity;

import java.io.IOException;
import java.util.ArrayList;
import us.ihmc.affinity.Package;
import us.ihmc.affinity.SysFSTools;

public class CPUTopology {
    private final ArrayList<Package> packages = new ArrayList();

    public CPUTopology() {
        int[] online;
        for (int cpu : online = this.getOnline()) {
            int cpuPackage = this.getCPUPackage(cpu);
            if (cpuPackage == -1) continue;
            while (this.packages.size() <= cpuPackage) {
                this.packages.add(new Package(this.packages.size()));
            }
            this.packages.get(cpuPackage).addCore(cpu);
        }
    }

    private int[] getOnline() {
        try {
            String range = SysFSTools.readFirstLine("/sys/devices/system/cpu/online");
            return SysFSTools.range(range);
        }
        catch (IOException | NumberFormatException e) {
            return new int[0];
        }
    }

    private int getCPUPackage(int cpu) {
        try {
            String id = SysFSTools.readFirstLine("/sys/devices/system/cpu/cpu" + cpu + "/topology/physical_package_id");
            return Integer.parseInt(id);
        }
        catch (IOException | NumberFormatException e) {
            return -1;
        }
    }

    public Package getPackage(int packageID) {
        return this.packages.get(packageID);
    }

    public int getNumberOfPackages() {
        return this.packages.size();
    }

    public int getNumberOfCores() {
        int cores = 0;
        for (Package pack : this.packages) {
            cores += pack.getNumberOfCores();
        }
        return cores;
    }

    public int getNumberOfProcessors() {
        int processors = 0;
        for (Package pack : this.packages) {
            processors += pack.getNumberOfProcessors();
        }
        return processors;
    }

    public boolean isHyperThreadingEnabled() {
        return this.getNumberOfCores() != this.getNumberOfProcessors();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Cores: ");
        builder.append(this.getNumberOfCores());
        builder.append('\n');
        builder.append("Processors: ");
        builder.append(this.getNumberOfProcessors());
        builder.append('\n');
        if (this.isHyperThreadingEnabled()) {
            builder.append("Hyper-Threading enabled\n");
        } else {
            builder.append("Hyper-Threading disabled\n");
        }
        builder.append("CPU Topology:\n");
        for (Package pack : this.packages) {
            builder.append(pack);
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        System.out.println(new CPUTopology());
    }
}

