/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rtps.impl.fastRTPS;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.OwnerShipPolicyKind;
import us.ihmc.pubsub.attributes.PublishModeKind;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.attributes.WriterQosHolder;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSCommonFunctions;
import us.ihmc.rtps.impl.fastRTPS.WriterQos;
import us.ihmc.rtps.impl.fastRTPS.stringVector;

public class FastRTPSWriterQosHolder
implements WriterQosHolder {
    private final boolean ownMemory;
    private final WriterQos writerQos = new WriterQos();

    public WriterQos getWriterQos() {
        return this.writerQos;
    }

    FastRTPSWriterQosHolder() {
        this.ownMemory = true;
    }

    FastRTPSWriterQosHolder(WriterQos writerQos) {
        this();
        this.writerQos.setQos(writerQos, true);
    }

    public void delete() {
        if (this.ownMemory) {
            this.getWriterQos().delete();
        }
    }

    public void finalize() {
        this.delete();
    }

    @Override
    public void setReliabilityKind(ReliabilityKind reliabilityKind) {
        this.getWriterQos().getM_reliability().setKind(FastRTPSCommonFunctions.toCppReliabilityQosPolicyKind(reliabilityKind));
    }

    @Override
    public ReliabilityKind getReliabilityKind() {
        return FastRTPSCommonFunctions.toJavaReliabilityKind(this.getWriterQos().getM_reliability().getKind());
    }

    @Override
    public DurabilityKind getDurabilityKind() {
        return FastRTPSCommonFunctions.toJavaDurabilityKind(this.getWriterQos().getM_durability().getKind());
    }

    @Override
    public void setDurabilityKind(DurabilityKind durabilityKind) {
        this.getWriterQos().getM_durability().setKind(FastRTPSCommonFunctions.toCppDurabilityKind(durabilityKind));
    }

    @Override
    public OwnerShipPolicyKind getOwnershipPolicyKind() {
        return FastRTPSCommonFunctions.toJavaOwnershipQosPolicyKind(this.getWriterQos().getM_ownership().getKind());
    }

    @Override
    public void setOwnershipPolicyKind(OwnerShipPolicyKind ownerShipPolicyKind) {
        this.getWriterQos().getM_ownership().setKind(FastRTPSCommonFunctions.toCppOwnershipQosPolicyKind(ownerShipPolicyKind));
    }

    @Override
    public void addPartition(String name) {
        this.getWriterQos().getM_partition().push_back(name);
    }

    @Override
    public List<String> getPartitions() {
        ArrayList<String> partitions = new ArrayList<String>();
        stringVector CppPartitions = this.getWriterQos().getM_partition().getNames();
        int i = 0;
        while ((long)i < CppPartitions.size()) {
            partitions.add(CppPartitions.get(i));
            ++i;
        }
        return Collections.unmodifiableList(partitions);
    }

    @Override
    public void setPublishMode(PublishModeKind publishMode) {
        this.getWriterQos().getM_publishMode().setKind(FastRTPSCommonFunctions.toCppPublishModeKind(publishMode));
    }

    @Override
    public PublishModeKind getPublishMode() {
        return FastRTPSCommonFunctions.toJavaPublishModeKind(this.getWriterQos().getM_publishMode().getKind());
    }
}

