/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rtps.impl.fastRTPS;

import java.io.IOException;
import java.nio.ByteBuffer;
import us.ihmc.idl.CDR;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.ChangeKind;
import us.ihmc.pubsub.common.Guid;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleIdentity;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSCommonFunctions;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSSubscriberAttributes;
import us.ihmc.rtps.impl.fastRTPS.LocatorList_t;
import us.ihmc.rtps.impl.fastRTPS.MatchingStatus;
import us.ihmc.rtps.impl.fastRTPS.MemoryManagementPolicy_t;
import us.ihmc.rtps.impl.fastRTPS.NativeParticipantImpl;
import us.ihmc.rtps.impl.fastRTPS.NativeSubscriberImpl;
import us.ihmc.rtps.impl.fastRTPS.NativeSubscriberListener;
import us.ihmc.rtps.impl.fastRTPS.OwnershipQosPolicyKind;
import us.ihmc.rtps.impl.fastRTPS.ReaderQos;
import us.ihmc.rtps.impl.fastRTPS.SampleInfoMarshaller;
import us.ihmc.rtps.impl.fastRTPS.TopicAttributes;
import us.ihmc.rtps.impl.fastRTPS.TopicKind_t;

class FastRTPSSubscriber<T>
implements Subscriber<T> {
    private final Object destructorLock = new Object();
    private NativeSubscriberImpl impl;
    private final FastRTPSSubscriberAttributes attributes;
    private final TopicDataType<T> topicDataType;
    private final SubscriberListener<T> listener;
    private final SerializedPayload payload;
    private TopicAttributes fastRTPSAttributes;
    private final Guid guid = new Guid();
    private final MatchingInfo matchingInfo = new MatchingInfo();
    private final ByteBuffer keyBuffer = ByteBuffer.allocateDirect(16);
    private final SampleInfoMarshaller sampleInfoMarshaller = new SampleInfoMarshaller();
    private final TopicKind_t topicKind;
    private final OwnershipQosPolicyKind ownershipQosPolicyKind;
    private final NativeSubscriberListenerImpl nativeListenerImpl = new NativeSubscriberListenerImpl();

    private void preparePayload(short encapsulation, int dataLength) {
        this.payload.getData().clear();
        this.payload.setEncapsulation(encapsulation);
        if (CDR.getTypeSize(dataLength) <= this.payload.getMax_size()) {
            dataLength = CDR.getTypeSize(dataLength);
        }
        this.payload.setLength(dataLength);
        this.payload.getData().limit(dataLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FastRTPSSubscriber(TopicDataType<T> topicDataTypeIn, FastRTPSSubscriberAttributes attributes, SubscriberListener<T> listener, NativeParticipantImpl participantImpl) throws IOException {
        Object object = this.destructorLock;
        synchronized (object) {
            LocatorList_t unicastLocatorList = new LocatorList_t();
            FastRTPSCommonFunctions.convertToCPPLocatorList(attributes.getUnicastLocatorList(), unicastLocatorList);
            LocatorList_t multicastLocatorList = new LocatorList_t();
            FastRTPSCommonFunctions.convertToCPPLocatorList(attributes.getMulticastLocatorList(), multicastLocatorList);
            LocatorList_t outLocatorList = new LocatorList_t();
            FastRTPSCommonFunctions.convertToCPPLocatorList(attributes.getOutLocatorList(), outLocatorList);
            if (!unicastLocatorList.isValid()) {
                throw new IllegalArgumentException("Unicast Locator List for Subscriber contains invalid Locator");
            }
            if (!multicastLocatorList.isValid()) {
                throw new IllegalArgumentException(" Multicast Locator List for Subscriber contains invalid Locator");
            }
            if (!outLocatorList.isValid()) {
                throw new IllegalArgumentException("Output Locator List for Subscriber contains invalid Locator");
            }
            ReaderQos qos = attributes.getQos().getReaderQos();
            this.attributes = attributes;
            this.topicDataType = topicDataTypeIn.newInstance();
            this.listener = listener;
            this.payload = new SerializedPayload(this.topicDataType.getTypeSize() + 3);
            this.topicKind = TopicKind_t.swigToEnum(attributes.getTopic().getTopicKind().ordinal());
            this.ownershipQosPolicyKind = qos.getM_ownership().getKind();
            this.fastRTPSAttributes = attributes.createFastRTPSTopicAttributes();
            if (!qos.checkQos() || !this.fastRTPSAttributes.checkQos()) {
                throw new IllegalArgumentException("Invalid QoS settings");
            }
            this.impl = new NativeSubscriberImpl(attributes.getEntityID(), attributes.getUserDefinedID(), this.topicDataType.getTypeSize(), MemoryManagementPolicy_t.swigToEnum(attributes.getHistoryMemoryPolicy().ordinal()), this.fastRTPSAttributes, qos, attributes.getTimes(), unicastLocatorList, multicastLocatorList, outLocatorList, attributes.isExpectsInlineQos(), participantImpl, this.nativeListenerImpl);
            if (!this.impl.createSubscriber()) {
                throw new IOException("Cannot create subscriber");
            }
            this.guid.fromPrimitives(this.impl.getGuidHigh(), this.impl.getGuidLow());
            unicastLocatorList.delete();
            multicastLocatorList.delete();
            outLocatorList.delete();
        }
    }

    @Override
    public Guid getGuid() {
        return this.guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForUnreadMessage(int timeoutInMilliseconds) {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new RuntimeException("This subscriber has been removed from the domain");
            }
            this.impl.waitForUnreadMessage();
        }
    }

    private void updateSampleInfo(SampleInfoMarshaller marshaller, SampleInfo info, ByteBuffer keyBuffer) {
        marshaller.getInstanceHandleValue(keyBuffer);
        keyBuffer.clear();
        info.setDataLength(marshaller.getDataLength());
        info.setOwnershipStrength(marshaller.getOwnershipStrength());
        info.setSampleKind(ChangeKind.values[marshaller.getChangeKind()]);
        Time time = info.getSourceTimestamp();
        time.setSeconds(marshaller.getTime_seconds());
        time.setFraction(marshaller.getTime_fraction());
        SampleIdentity id = info.getSampleIdentity();
        id.getGuid().fromPrimitives(marshaller.getSampleIdentity_GuidHigh(), marshaller.getSampleIdentity_GuidLow());
        id.getSequenceNumber().set(marshaller.getSampleIdentity_sequenceNumberHigh(), marshaller.getSampleIdentity_sequenceNumberLow());
        SampleIdentity relatedId = info.getRelatedSampleIdentity();
        relatedId.getGuid().fromPrimitives(marshaller.getRelatedSampleIdentity_GuidHigh(), marshaller.getRelatedSampleIdentity_GuidLow());
        relatedId.getSequenceNumber().set(marshaller.getRelatedSampleIdentity_sequenceNumberHigh(), marshaller.getRelatedSampleIdentity_sequenceNumberLow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readNextData(T data, SampleInfo info) {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                System.err.println("This subscriber has been removed from the domain");
                return false;
            }
            if (this.impl.readnextData(this.payload.getData().capacity(), this.payload.getData(), this.sampleInfoMarshaller, this.topicKind, this.ownershipQosPolicyKind)) {
                if (info != null) {
                    this.updateSampleInfo(this.sampleInfoMarshaller, info, this.keyBuffer);
                }
                this.preparePayload(this.sampleInfoMarshaller.getEncapsulation(), this.sampleInfoMarshaller.getDataLength());
                try {
                    this.topicDataType.deserialize(this.payload, data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public T readNextData() {
        return this.readNextData(null);
    }

    @Override
    public T readNextData(SampleInfo info) {
        T nextData = this.topicDataType.createData();
        if (this.readNextData(nextData, info)) {
            return nextData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean takeNextData(T data, SampleInfo info) {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                System.err.println("This subscriber has been removed from the domain");
                return false;
            }
            if (this.impl.takeNextData(this.payload.getData().capacity(), this.payload.getData(), this.sampleInfoMarshaller, this.topicKind, this.ownershipQosPolicyKind)) {
                if (info != null) {
                    this.updateSampleInfo(this.sampleInfoMarshaller, info, this.keyBuffer);
                }
                this.preparePayload(this.sampleInfoMarshaller.getEncapsulation(), this.sampleInfoMarshaller.getDataLength());
                try {
                    this.topicDataType.deserialize(this.payload, data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public T takeNextData() {
        return this.takeNextData(null);
    }

    @Override
    public T takeNextData(SampleInfo info) {
        T nextData = this.topicDataType.createData();
        if (this.takeNextData(nextData, info)) {
            return nextData;
        }
        return null;
    }

    @Override
    public SubscriberAttributes getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInCleanState() {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new RuntimeException("This subscriber has been removed from the domain");
            }
            return this.impl.isInCleanState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() {
        Object object = this.destructorLock;
        synchronized (object) {
            this.impl.delete();
            this.fastRTPSAttributes.delete();
            this.nativeListenerImpl.delete();
            this.impl = null;
        }
    }

    TopicDataType<T> getTopicDataType() {
        return this.topicDataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable() {
        Object object = this.destructorLock;
        synchronized (object) {
            return this.impl != null;
        }
    }

    private class NativeSubscriberListenerImpl
    extends NativeSubscriberListener {
        private NativeSubscriberListenerImpl() {
        }

        @Override
        public void onSubscriptionMatched(MatchingStatus status, long guidHigh, long guidLow) {
            try {
                if (FastRTPSSubscriber.this.listener != null) {
                    FastRTPSSubscriber.this.matchingInfo.getGuid().fromPrimitives(guidHigh, guidLow);
                    FastRTPSSubscriber.this.matchingInfo.setStatus(MatchingInfo.MatchingStatus.values[status.swigValue()]);
                    FastRTPSSubscriber.this.listener.onSubscriptionMatched(FastRTPSSubscriber.this, FastRTPSSubscriber.this.matchingInfo);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onNewDataMessage() {
            try {
                if (FastRTPSSubscriber.this.listener != null) {
                    FastRTPSSubscriber.this.listener.onNewDataMessage(FastRTPSSubscriber.this);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

