/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rtps.impl.fastRTPS;

import java.net.Inet4Address;
import java.net.InetAddress;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.common.Time;
import us.ihmc.rtps.impl.fastRTPS.BuiltinAttributes;
import us.ihmc.rtps.impl.fastRTPS.Locator_t;
import us.ihmc.rtps.impl.fastRTPS.RTPSParticipantAttributes;
import us.ihmc.rtps.impl.fastRTPS.Time_t;

public class FastRTPSParticipantAttributes
extends ParticipantAttributes {
    private final RTPSParticipantAttributes rtps = new RTPSParticipantAttributes();
    private final BuiltinAttributes builtin = this.rtps.getBuiltin();
    private final Time_t time = new Time_t();

    FastRTPSParticipantAttributes() {
    }

    public RTPSParticipantAttributes rtps() {
        return this.rtps;
    }

    @Override
    public void setName(String name) {
        this.rtps().setName(name);
    }

    @Override
    public void setDomainId(int domain) {
        this.builtin.setDomainId(domain);
    }

    @Override
    public void setLeaseDuration(Time time) {
        this.time.setSeconds(time.getSeconds());
        this.time.setFraction(time.getFraction());
        this.builtin.setLeaseDuration(this.time);
    }

    @Override
    public void bindToAddress(InetAddress ... addresses) {
        for (InetAddress address : addresses) {
            Locator_t locator = new Locator_t();
            if (!(address instanceof Inet4Address)) {
                throw new RuntimeException("Only IPv4 addresses are tested and supported");
            }
            locator.setKind(1);
            locator.set_IP4_address(address.getHostAddress());
            this.rtps.getDefaultOutLocatorList().push_back(locator);
            this.rtps.getDefaultUnicastLocatorList().push_back(locator);
        }
    }

    public void delete() {
        this.rtps().delete();
        this.time.delete();
    }

    public void finalize() {
        this.delete();
    }
}

