/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rtps.impl.fastRTPS;

import java.io.IOException;
import java.util.ArrayList;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.Locator;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.attributes.TopicAttributes;
import us.ihmc.pubsub.common.Guid;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.participant.PublisherEndpointDiscoveryListener;
import us.ihmc.pubsub.participant.SubscriberEndpointDiscoveryListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.rtps.impl.fastRTPS.DISCOVERY_STATUS;
import us.ihmc.rtps.impl.fastRTPS.FastRTPS;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSCommonFunctions;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSParticipantAttributes;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSParticipantDiscoveryInfo;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSPublisher;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSPublisherAttributes;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSReaderQosHolder;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSSubscriber;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSSubscriberAttributes;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSWriterQosHolder;
import us.ihmc.rtps.impl.fastRTPS.LocatorList_t;
import us.ihmc.rtps.impl.fastRTPS.NativeParticipantImpl;
import us.ihmc.rtps.impl.fastRTPS.NativeParticipantListener;
import us.ihmc.rtps.impl.fastRTPS.NativeParticipantPublisherEDPListener;
import us.ihmc.rtps.impl.fastRTPS.NativeParticipantSubscriberEDPListener;
import us.ihmc.rtps.impl.fastRTPS.ReaderQos;
import us.ihmc.rtps.impl.fastRTPS.TopicKind_t;
import us.ihmc.rtps.impl.fastRTPS.WriterQos;

class FastRTPSParticipant
implements Participant {
    private final NativeParticipantImpl impl;
    private final ArrayList<TopicDataType<?>> types = new ArrayList();
    private final ArrayList<FastRTPSPublisher> publishers = new ArrayList();
    private final ArrayList<FastRTPSSubscriber> subscribers = new ArrayList();
    private final FastRTPSParticipantAttributes attributes;
    private final ParticipantListener participantListener;
    private final Guid guid = new Guid();
    private final NativeParticipantListenerImpl nativeListener = new NativeParticipantListenerImpl();
    private NativeParticipantPublisherEDPListenerImpl nativeParticipantPublisherEDPListenerImpl = null;
    private NativeParticipantSubscriberEDPListenerImpl nativeParticipantSubscriberEDPListenerImpl = null;

    FastRTPSParticipant(ParticipantAttributes att, ParticipantListener participantListener) throws IOException, IllegalArgumentException {
        this.participantListener = participantListener;
        if (!(att instanceof FastRTPSParticipantAttributes)) {
            throw new IllegalArgumentException("ParticipantAttributes<?> is not of base class FastRTPSParticipantAttributes");
        }
        this.attributes = (FastRTPSParticipantAttributes)att;
        this.impl = new NativeParticipantImpl(this.attributes.rtps(), this.nativeListener);
        this.getGuid(this.guid);
    }

    synchronized void delete() {
        int i;
        for (i = 0; i < this.publishers.size(); ++i) {
            this.publishers.get(i).delete();
        }
        for (i = 0; i < this.subscribers.size(); ++i) {
            this.subscribers.get(i).delete();
        }
        this.impl.delete();
        this.nativeListener.delete();
        if (this.nativeParticipantPublisherEDPListenerImpl != null) {
            this.nativeParticipantPublisherEDPListenerImpl.delete();
        }
        if (this.nativeParticipantSubscriberEDPListenerImpl != null) {
            this.nativeParticipantSubscriberEDPListenerImpl.delete();
        }
    }

    private void getGuid(Guid guid) {
        guid.fromPrimitives(this.impl.getGuidHigh(), this.impl.getGuidLow());
    }

    @Override
    public Guid getGuid() {
        return this.guid;
    }

    @Override
    public FastRTPSParticipantAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public synchronized int get_no_publisher(String target_topic) {
        int count = 0;
        for (int i = 0; i < this.publishers.size(); ++i) {
            if (!this.publishers.get(i).getAttributes().getTopic().getTopicName().equals(target_topic)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public synchronized int get_no_subscribers(String target_topic) {
        int count = 0;
        for (int i = 0; i < this.subscribers.size(); ++i) {
            if (!this.subscribers.get(i).getAttributes().getTopic().getTopicName().equals(target_topic)) continue;
            ++count;
        }
        return count;
    }

    synchronized void registerType(TopicDataType<?> topicDataType) throws IllegalArgumentException {
        if (topicDataType.getTypeSize() <= 0) {
            throw new IllegalArgumentException("Registered type must have maximum byte size > 0");
        }
        if (topicDataType.getName().isEmpty()) {
            throw new IllegalArgumentException("Registered type must have a name");
        }
        for (int i = 0; i < this.types.size(); ++i) {
            if (!this.types.get(i).getName().equals(topicDataType.getName())) continue;
            throw new IllegalArgumentException("Type with the same name already exists: " + topicDataType.getName());
        }
        this.impl.registerType(topicDataType.getName(), topicDataType.getTypeSize(), topicDataType.isGetKeyDefined());
        this.types.add(topicDataType);
    }

    synchronized TopicDataType<?> getRegisteredType(String name) {
        for (int i = 0; i < this.types.size(); ++i) {
            if (!this.types.get(i).getName().equals(name)) continue;
            return this.types.get(i);
        }
        return null;
    }

    synchronized FastRTPSPublisher createPublisher(PublisherAttributes publisherAttributes, PublisherListener listener) throws IOException, IllegalArgumentException {
        TopicDataType<?> topicDataType = this.getRegisteredType(publisherAttributes.getTopic().getTopicDataType());
        if (topicDataType == null) {
            throw new IllegalArgumentException("Type: " + publisherAttributes.getTopic().getTopicDataType() + " is not registered");
        }
        if (publisherAttributes.getTopic().getTopicKind() == TopicAttributes.TopicKind.WITH_KEY && !topicDataType.isGetKeyDefined()) {
            throw new IllegalArgumentException("Keyed topic needs getKey function");
        }
        if (this.attributes.rtps().getBuiltin().getUse_STATIC_EndpointDiscoveryProtocol() && publisherAttributes.getUserDefinedID() <= 0) {
            throw new IllegalArgumentException("Static EDP requires user defined EDP");
        }
        if (publisherAttributes instanceof FastRTPSPublisherAttributes) {
            FastRTPSPublisher publisher = new FastRTPSPublisher(topicDataType, (FastRTPSPublisherAttributes)publisherAttributes, listener, this.impl);
            this.publishers.add(publisher);
            return publisher;
        }
        throw new IllegalArgumentException("publisherAttributes are not an instance of FastRTPSPublisherAttributes");
    }

    synchronized Subscriber createSubscriber(SubscriberAttributes subscriberAttributes, SubscriberListener listener) throws IOException {
        TopicDataType<?> topicDataType = this.getRegisteredType(subscriberAttributes.getTopic().getTopicDataType());
        if (topicDataType == null) {
            throw new IllegalArgumentException("Type: " + subscriberAttributes.getTopic().getTopicDataType() + " is not registered");
        }
        if (subscriberAttributes.getTopic().getTopicKind() == TopicAttributes.TopicKind.WITH_KEY && !topicDataType.isGetKeyDefined()) {
            throw new IllegalArgumentException("Keyed topic needs getKey function");
        }
        if (this.attributes.rtps().getBuiltin().getUse_STATIC_EndpointDiscoveryProtocol() && subscriberAttributes.getUserDefinedID() <= 0) {
            throw new IllegalArgumentException("Static EDP requires user defined EDP");
        }
        if (subscriberAttributes instanceof FastRTPSSubscriberAttributes) {
            FastRTPSSubscriber subscriber = new FastRTPSSubscriber(topicDataType, (FastRTPSSubscriberAttributes)subscriberAttributes, listener, this.impl);
            this.subscribers.add(subscriber);
            return subscriber;
        }
        throw new IllegalArgumentException("subscriberAttributes are not an instance of FastRTPSSubscriberAttributes");
    }

    synchronized boolean removePublisher(Publisher publisher) {
        for (int i = 0; i < this.publishers.size(); ++i) {
            if (this.publishers.get(i) != publisher) continue;
            this.publishers.get(i).delete();
            this.publishers.remove(i);
            return true;
        }
        return false;
    }

    synchronized boolean removeSubscriber(Subscriber subscriber) {
        for (int i = 0; i < this.subscribers.size(); ++i) {
            if (this.subscribers.get(i) != subscriber) continue;
            this.subscribers.get(i).delete();
            this.subscribers.remove(i);
            return true;
        }
        return false;
    }

    synchronized void unregisterType(String typeName) throws IOException {
        int i;
        TopicDataType<?> type = null;
        for (i = 0; i < this.types.size(); ++i) {
            if (!this.types.get(i).getName().equals(typeName)) continue;
            type = this.types.get(i);
        }
        if (type == null) {
            throw new IllegalArgumentException(typeName + " is not registered with participant");
        }
        for (i = 0; i < this.publishers.size(); ++i) {
            if (!this.publishers.get(i).getTopicDataType().equals(type)) continue;
            throw new IOException("TopicDataType in use by publisher " + this.publishers.get(i).getAttributes().getTopic().getTopicName());
        }
        for (i = 0; i < this.subscribers.size(); ++i) {
            if (!this.subscribers.get(i).getTopicDataType().equals(type)) continue;
            throw new IOException("TopicDataType in use by subscriber " + this.subscribers.get(i).getAttributes().getTopic().getTopicName());
        }
        this.publishers.remove(type);
    }

    @Override
    public void registerEndpointDiscoveryListeners(PublisherEndpointDiscoveryListener publisherEndpointDiscoveryListener, SubscriberEndpointDiscoveryListener subscriberEndpointDiscoveryListener) throws IOException {
        this.nativeParticipantPublisherEDPListenerImpl = publisherEndpointDiscoveryListener == null ? null : new NativeParticipantPublisherEDPListenerImpl(publisherEndpointDiscoveryListener);
        this.nativeParticipantSubscriberEDPListenerImpl = subscriberEndpointDiscoveryListener == null ? null : new NativeParticipantSubscriberEDPListenerImpl(subscriberEndpointDiscoveryListener);
        this.impl.registerEDPReaderListeners(this.nativeParticipantPublisherEDPListenerImpl, this.nativeParticipantSubscriberEDPListenerImpl);
    }

    @Override
    public synchronized boolean isAvailable() {
        return this.impl != null;
    }

    private class NativeParticipantListenerImpl
    extends NativeParticipantListener {
        private final FastRTPSParticipantDiscoveryInfo discoveryInfo = new FastRTPSParticipantDiscoveryInfo();

        private NativeParticipantListenerImpl() {
        }

        @Override
        public void onParticipantDiscovery(long infoPtr, long guidHigh, long guidLow, DISCOVERY_STATUS status) {
            try {
                if (FastRTPSParticipant.this.participantListener != null) {
                    this.discoveryInfo.updateInfo(status, this, infoPtr, guidHigh, guidLow);
                    FastRTPSParticipant.this.participantListener.onParticipantDiscovery(FastRTPSParticipant.this, this.discoveryInfo);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private class NativeParticipantPublisherEDPListenerImpl
    extends NativeParticipantPublisherEDPListener {
        private final PublisherEndpointDiscoveryListener listener;

        public NativeParticipantPublisherEDPListenerImpl(PublisherEndpointDiscoveryListener listener) {
            this.listener = listener;
        }

        @Override
        public void publisherTopicChange(boolean isAlive, long guidHigh, long guidLow, LocatorList_t unicastLocatorList, LocatorList_t multicastLocatorList, long participantGuidHigh, long participantGuidLow, String typeName, String topicName, int userDefinedId, long typeMaxSerialized, TopicKind_t topicKind, WriterQos writerQoS) {
            try {
                Locator out;
                Guid guid = new Guid();
                guid.fromPrimitives(guidHigh, guidLow);
                Guid participantGuid = new Guid();
                participantGuid.fromPrimitives(participantGuidHigh, participantGuidLow);
                ArrayList<Locator> unicastLocatorListOut = new ArrayList<Locator>();
                ArrayList<Locator> multicastLocatorListOut = new ArrayList<Locator>();
                int i = 0;
                while ((long)i < unicastLocatorList.size()) {
                    out = new Locator();
                    FastRTPSCommonFunctions.convertToJavaLocator(FastRTPS.getLocator(unicastLocatorList, i), out);
                    unicastLocatorListOut.add(out);
                    ++i;
                }
                i = 0;
                while ((long)i < multicastLocatorList.size()) {
                    out = new Locator();
                    FastRTPSCommonFunctions.convertToJavaLocator(FastRTPS.getLocator(multicastLocatorList, i), out);
                    multicastLocatorListOut.add(out);
                    ++i;
                }
                FastRTPSWriterQosHolder writerQosOut = new FastRTPSWriterQosHolder(writerQoS);
                this.listener.publisherTopicChange(isAlive, guid, unicastLocatorListOut, multicastLocatorListOut, participantGuid, typeName, topicName, userDefinedId, typeMaxSerialized, FastRTPSCommonFunctions.toJavaTopicKind(topicKind), writerQosOut);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private class NativeParticipantSubscriberEDPListenerImpl
    extends NativeParticipantSubscriberEDPListener {
        private final SubscriberEndpointDiscoveryListener listener;

        public NativeParticipantSubscriberEDPListenerImpl(SubscriberEndpointDiscoveryListener listener) {
            this.listener = listener;
        }

        @Override
        public void subscriberTopicChange(boolean isAlive, long guidHigh, long guidLow, boolean expectsInlineQos, LocatorList_t unicastLocatorList, LocatorList_t multicastLocatorList, long participantGuidHigh, long participantGuidLow, String typeName, String topicName, int userDefinedId, TopicKind_t topicKind, ReaderQos readerQoS) {
            try {
                Locator out;
                Guid guid = new Guid();
                guid.fromPrimitives(guidHigh, guidLow);
                Guid participantGuid = new Guid();
                participantGuid.fromPrimitives(participantGuidHigh, participantGuidLow);
                ArrayList<Locator> unicastLocatorListOut = new ArrayList<Locator>();
                ArrayList<Locator> multicastLocatorListOut = new ArrayList<Locator>();
                int i = 0;
                while ((long)i < unicastLocatorList.size()) {
                    out = new Locator();
                    FastRTPSCommonFunctions.convertToJavaLocator(FastRTPS.getLocator(unicastLocatorList, i), out);
                    unicastLocatorListOut.add(out);
                    ++i;
                }
                i = 0;
                while ((long)i < multicastLocatorList.size()) {
                    out = new Locator();
                    FastRTPSCommonFunctions.convertToJavaLocator(FastRTPS.getLocator(multicastLocatorList, i), out);
                    multicastLocatorListOut.add(out);
                    ++i;
                }
                FastRTPSReaderQosHolder readerQosOut = new FastRTPSReaderQosHolder(readerQoS);
                this.listener.subscriberTopicChange(isAlive, guid, expectsInlineQos, unicastLocatorListOut, multicastLocatorListOut, participantGuid, typeName, topicName, userDefinedId, FastRTPSCommonFunctions.toJavaTopicKind(topicKind), readerQosOut);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

