/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.common;

public class Time {
    public static final Time Infinite = new Time(Integer.MAX_VALUE, -1L);
    public static final Time Zero = new Time(0, 0L);
    public static final Time Invalid = new Time(-1, -1L);
    private int seconds;
    private long fraction;

    public Time(int seconds, long fraction) {
        this.seconds = seconds;
        this.fraction = fraction;
    }

    public Time() {
    }

    public void set(long nanoseconds) {
        this.seconds = (int)(nanoseconds / 1000000000L);
        this.fraction = nanoseconds % 1000000000L * 0x100000000L / 1000000000L;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public long getFraction() {
        return this.fraction;
    }

    public void setFraction(long fraction) {
        this.fraction = fraction;
    }

    public String toString() {
        return String.format("%.2f", (double)this.seconds + (double)this.fraction / Math.pow(2.0, 32.0));
    }

    public void set(Time sourceTimestamp) {
        this.seconds = sourceTimestamp.seconds;
        this.fraction = sourceTimestamp.fraction;
    }
}

