/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.attributes;

public class Locator {
    private final byte[] address = new byte[16];
    private Kind kind = Kind.LOCATOR_KIND_UDPv4;
    private int port = 0;

    public void setIPv4Adress(byte o1, byte o2, byte o3, byte o4) {
        if (this.kind != Kind.LOCATOR_KIND_UDPv4) {
            throw new RuntimeException("Trying to set IPv4 address on locator that is not of kind LOCATOR_KIND_UDPv4");
        }
        this.address[12] = o1;
        this.address[13] = o2;
        this.address[14] = o3;
        this.address[15] = o4;
    }

    public void setIPv6Address(int group0, int group1, int group2, int group3, int group4, int group5, int group6, int group7) {
        if (this.kind != Kind.LOCATOR_KIND_UDPv6) {
            throw new RuntimeException("Trying to set IPv4 address on locator that is not of kind LOCATOR_KIND_UDPv6");
        }
        this.address[0] = (byte)(group0 >> 8);
        this.address[1] = (byte)group0;
        this.address[2] = (byte)(group1 >> 8);
        this.address[3] = (byte)group1;
        this.address[4] = (byte)(group2 >> 8);
        this.address[5] = (byte)group2;
        this.address[6] = (byte)(group3 >> 8);
        this.address[7] = (byte)group3;
        this.address[8] = (byte)(group4 >> 8);
        this.address[9] = (byte)group4;
        this.address[10] = (byte)(group5 >> 8);
        this.address[11] = (byte)group5;
        this.address[12] = (byte)(group6 >> 8);
        this.address[13] = (byte)group6;
        this.address[14] = (byte)(group7 >> 8);
        this.address[15] = (byte)group7;
    }

    public byte getOctet(int octet) {
        return this.address[octet];
    }

    public Kind getKind() {
        return this.kind;
    }

    public int getPort() {
        return this.port;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setOctet(int i, byte locatorOctet) {
        this.address[i] = locatorOctet;
    }

    public String toString() {
        switch (this.kind) {
            case LOCATOR_KIND_UDPv4: {
                StringBuilder builder = new StringBuilder();
                builder.append(Kind.LOCATOR_KIND_UDPv4.toString());
                builder.append(" ");
                for (int i = 12; i < 16; ++i) {
                    builder.append(this.address[i] & 0xFF);
                    if (i >= 15) continue;
                    builder.append(".");
                }
                builder.append(":");
                builder.append(this.port);
                return builder.toString();
            }
            case LOCATOR_KIND_UDPv6: {
                StringBuilder builder = new StringBuilder();
                builder.append(Kind.LOCATOR_KIND_UDPv6.toString());
                builder.append(" ");
                for (int i = 0; i < 16; i += 2) {
                    int group = (this.address[i] & 0xFF) << 8;
                    builder.append(group += this.address[i + 1] & 0xFF);
                    if (i >= 15) continue;
                    builder.append("::");
                }
                builder.append(":");
                builder.append(this.port);
                return builder.toString();
            }
        }
        return Kind.LOCATOR_KIND_RESERVED.toString();
    }

    public static enum Kind {
        LOCATOR_KIND_RESERVED,
        LOCATOR_KIND_UDPv4,
        LOCATOR_KIND_UDPv6;

    }
}

