/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.perception.slamWrapper;

import us.ihmc.log.LogTools;
import us.ihmc.tools.nativelibraries.NativeLibraryDescription;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;
import us.ihmc.tools.nativelibraries.NativeLibraryWithDependencies;

public class SlamWrapperNativeLibrary
implements NativeLibraryDescription {
    private static boolean loaded = false;

    public String getPackage(NativeLibraryDescription.OperatingSystem os, NativeLibraryDescription.Architecture arch) {
        String archPackage = "";
        if (arch == NativeLibraryDescription.Architecture.x64) {
            archPackage = switch (os) {
                case NativeLibraryDescription.OperatingSystem.WIN64 -> "windows-x86_64";
                case NativeLibraryDescription.OperatingSystem.LINUX64 -> "linux-x86_64";
                default -> "unknown";
            };
        }
        return "slamWrapper." + archPackage;
    }

    public NativeLibraryWithDependencies getLibraryWithDependencies(NativeLibraryDescription.OperatingSystem os, NativeLibraryDescription.Architecture arch) {
        switch (os) {
            case WIN64: {
                return NativeLibraryWithDependencies.fromFilename((String)"jniSlamWrapper.dll", (String[])new String[]{"gtsam.dll", "slam-wrapper.dll"});
            }
            case LINUX64: {
                return NativeLibraryWithDependencies.fromFilename((String)"libjniSlamWrapper.so", (String[])new String[]{"libtbbmalloc.so", "libtbb.so", "libboost_filesystem.so", "libboost_chrono.so", "libboost_timer.so", "libboost_serialization.so", "libgtsam.so", "libslam-wrapper.so"});
            }
        }
        LogTools.warn((String)("Unsupported platform: " + os.name() + "-" + arch.name()));
        return null;
    }

    public static boolean load() {
        if (!loaded) {
            SlamWrapperNativeLibrary slamWrapperNativeLibrary = new SlamWrapperNativeLibrary();
            loaded = NativeLibraryLoader.loadLibrary((NativeLibraryDescription)slamWrapperNativeLibrary);
        }
        return loaded;
    }
}

