/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public abstract class AbstractQpOASESWrapper {
    double[] cputime = new double[1];
    int[] nWSR = new int[1];
    double[] objVal = new double[1];
    private DMatrixRMaj A = null;
    private DMatrixRMaj lbA = null;
    private DMatrixRMaj ubA = null;
    int nvar;
    int ncon;
    boolean coldStart;

    protected abstract int solveNative(double[] var1, double[] var2, double[] var3, double[] var4, double[] var5, double[] var6, double[] var7, int[] var8, double[] var9, double[] var10, double[] var11);

    protected abstract int hotstartNative(double[] var1, double[] var2, double[] var3, double[] var4, double[] var5, double[] var6, double[] var7, int[] var8, double[] var9, double[] var10, double[] var11);

    protected abstract void initializeNative(int var1, int var2);

    public AbstractQpOASESWrapper() {
        this(1, 1);
    }

    public AbstractQpOASESWrapper(int nvar, int ncon) {
        this.initialize(nvar, ncon);
    }

    private void initialize(int nvar, int ncon) {
        if (this.nvar != nvar || this.ncon != ncon) {
            this.initializeNative(nvar, ncon);
            this.nvar = nvar;
            this.ncon = ncon;
            this.A = new DMatrixRMaj(this.ncon, this.nvar);
            this.lbA = new DMatrixRMaj(ncon, 1);
            this.ubA = new DMatrixRMaj(ncon, 1);
            this.coldStart = true;
            this.cputime[0] = Double.MAX_VALUE;
            this.nWSR[0] = Integer.MAX_VALUE;
        }
    }

    public int solve(DMatrixRMaj Q, DMatrixRMaj f, DMatrixRMaj Aeq, DMatrixRMaj beq, DMatrixRMaj Ain, DMatrixRMaj bin, DMatrixRMaj lb, DMatrixRMaj ub, DMatrixRMaj x, boolean initialize) {
        if (Aeq.numCols != Ain.numCols || Aeq.numCols != x.numRows) {
            throw new RuntimeException("inconsistent constraints");
        }
        if (initialize) {
            this.coldStart = true;
        }
        this.initialize(Aeq.numCols, Aeq.numRows + Ain.numRows);
        CommonOps_DDRM.insert((DMatrix)Aeq, (DMatrix)this.A, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)Ain, (DMatrix)this.A, (int)Aeq.numRows, (int)0);
        CommonOps_DDRM.fill((DMatrixD1)this.lbA, (double)Double.NEGATIVE_INFINITY);
        CommonOps_DDRM.insert((DMatrix)beq, (DMatrix)this.lbA, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)beq, (DMatrix)this.ubA, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)bin, (DMatrix)this.ubA, (int)beq.numRows, (int)0);
        double[] lbData = lb == null ? null : lb.getData();
        double[] ubData = ub == null ? null : ub.getData();
        int retCode = 0;
        retCode = this.coldStart ? this.solveNative(Q.getData(), f.getData(), this.A.getData(), lbData, ubData, this.lbA.getData(), this.ubA.getData(), this.nWSR, this.cputime, x.getData(), this.objVal) : this.hotstartNative(Q.getData(), f.getData(), this.A.getData(), lbData, ubData, this.lbA.getData(), this.ubA.getData(), this.nWSR, this.cputime, x.getData(), this.objVal);
        this.coldStart = false;
        return retCode;
    }

    public double getLastCpuTime() {
        return this.cputime[0];
    }

    public void setMaxCpuTime(double maxCpuTime) {
        this.cputime[0] = maxCpuTime;
    }

    public int getLastWorkingSetChanges() {
        return this.nWSR[0];
    }

    public void setMaxWorkingSetChanges(int maxWorkingSetChanges) {
        this.nWSR[0] = maxWorkingSetChanges;
    }

    public boolean isColdStart() {
        return this.coldStart;
    }

    public double getOptVal() {
        return this.objVal[0];
    }
}

