/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders.SdfLoader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import us.ihmc.simulationconstructionset.util.XMLReaderUtility;

public class SdfToMaxXML {
    String finalXML = "";
    int currentLocation = 0;

    public SdfToMaxXML() {
        File file = new File("C:/RobotControl/SDFLoader/Models/Polaris_ranger/polaris_ranger_ev/model.sdf");
        String xml = this.loadFile(file);
        this.finalXML = this.finalXML + "<Root>\n";
        if (!xml.equals("")) {
            this.convert(xml);
        }
        this.finalXML = this.finalXML + "\n</Root>";
        System.out.println(this.finalXML);
        System.exit(0);
    }

    private String loadFile(File sdfFile) {
        if (sdfFile == null) {
            return "";
        }
        try {
            if (sdfFile.exists()) {
                String tempLine;
                BufferedReader reader = new BufferedReader(new FileReader(sdfFile));
                String xmlRepresentation = "";
                String fileEnding = ".xml";
                String name = sdfFile.getName().substring(0, sdfFile.getName().length() - fileEnding.length());
                while ((tempLine = reader.readLine()) != null) {
                    xmlRepresentation = xmlRepresentation + tempLine;
                }
                reader.close();
                return xmlRepresentation;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private void convert(String xmlRepresentation) {
        String tmp = "";
        do {
            tmp = XMLReaderUtility.getMiddleString((int)this.currentLocation, (String)xmlRepresentation, (String)"<collision", (String)"</collision>");
            this.currentLocation = XMLReaderUtility.getEndIndexOfSubString((int)this.currentLocation, (String)xmlRepresentation, (String)"</collision>");
            if (tmp == null) continue;
            if (tmp.contains("<box>")) {
                this.createBox(tmp);
            }
            if (!tmp.contains("<cylinder>")) continue;
            this.createCylinder(tmp);
        } while (tmp != null);
    }

    private void createBox(String xmlForBox) {
        String name = XMLReaderUtility.getMiddleString((int)0, (String)xmlForBox, (String)"name=", (String)">");
        String xmlToAdd = "";
        xmlToAdd = xmlToAdd + "<node ";
        if (name != null && !name.equals("")) {
            xmlToAdd = xmlToAdd + "name=" + name + " ";
        }
        xmlToAdd = xmlToAdd + " class=\"Box\" ";
        String pose = XMLReaderUtility.getMiddleString((int)0, (String)xmlForBox, (String)"<pose>", (String)"</pose>");
        if (pose != null) {
            pose.trim();
            StringTokenizer poseTok = new StringTokenizer(pose, " ");
            if (poseTok.countTokens() == 6) {
                xmlToAdd = xmlToAdd + "x=\"" + poseTok.nextToken().trim() + "\" ";
                xmlToAdd = xmlToAdd + "y=\"" + poseTok.nextToken().trim() + "\" ";
                xmlToAdd = xmlToAdd + "z=\"" + poseTok.nextToken().trim() + "\" ";
                xmlToAdd = xmlToAdd + "yaw=\"" + poseTok.nextToken().trim() + "\" ";
                xmlToAdd = xmlToAdd + "pitch=\"" + poseTok.nextToken().trim() + "\" ";
                xmlToAdd = xmlToAdd + "roll=\"" + poseTok.nextToken().trim() + "\" ";
            } else {
                System.out.println("invalid post values " + pose);
            }
        } else {
            xmlToAdd = xmlToAdd + "x=\"0.0\" ";
            xmlToAdd = xmlToAdd + "y=\"0.0\" ";
            xmlToAdd = xmlToAdd + "z=\"0.0\" ";
            xmlToAdd = xmlToAdd + "yaw=\"0.0\" ";
            xmlToAdd = xmlToAdd + "pitch=\"0.0\" ";
            xmlToAdd = xmlToAdd + "roll=\"0.0\" ";
        }
        xmlToAdd = xmlToAdd + " ";
        String size = XMLReaderUtility.getMiddleString((int)0, (String)xmlForBox, (String)"<size>", (String)"</size>");
        size.trim();
        StringTokenizer sizeTok = new StringTokenizer(size, " ");
        if (sizeTok.countTokens() == 3) {
            xmlToAdd = xmlToAdd + "sx=\"" + sizeTok.nextToken().trim() + "\" ";
            xmlToAdd = xmlToAdd + "sy=\"" + sizeTok.nextToken().trim() + "\" ";
            xmlToAdd = xmlToAdd + "sz=\"" + sizeTok.nextToken().trim() + "\" ";
        } else {
            System.out.println("invalid size values " + size);
        }
        xmlToAdd = xmlToAdd + "/>\n";
        this.finalXML = this.finalXML + xmlToAdd;
    }

    private void createCylinder(String xmlForCylinder) {
        String name = XMLReaderUtility.getMiddleString((int)0, (String)xmlForCylinder, (String)"name=", (String)">");
        String xmlToAdd = "";
        xmlToAdd = xmlToAdd + "<node ";
        if (name != null && !name.equals("")) {
            xmlToAdd = xmlToAdd + "name=" + name + " ";
        }
        xmlToAdd = xmlToAdd + " class=\"Cylinder\" ";
        String pose = XMLReaderUtility.getMiddleString((int)0, (String)xmlForCylinder, (String)"<pose>", (String)"</pose>");
        if (pose != null) {
            pose.trim();
            StringTokenizer poseTok = new StringTokenizer(pose, " ");
            if (poseTok.countTokens() == 6) {
                xmlToAdd = xmlToAdd + "x=\"" + poseTok.nextToken().trim() + "\" ";
                xmlToAdd = xmlToAdd + "y=\"" + poseTok.nextToken().trim() + "\" ";
                xmlToAdd = xmlToAdd + "z=\"" + poseTok.nextToken().trim() + "\" ";
                xmlToAdd = xmlToAdd + "yaw=\"" + poseTok.nextToken().trim() + "\" ";
                xmlToAdd = xmlToAdd + "pitch=\"" + poseTok.nextToken().trim() + "\" ";
                xmlToAdd = xmlToAdd + "roll=\"" + poseTok.nextToken().trim() + "\" ";
            } else {
                System.out.println("invalid post values " + pose);
            }
        } else {
            xmlToAdd = xmlToAdd + "x=\"0.0\" ";
            xmlToAdd = xmlToAdd + "y=\"0.0\" ";
            xmlToAdd = xmlToAdd + "z=\"0.0\" ";
            xmlToAdd = xmlToAdd + "yaw=\"0.0\" ";
            xmlToAdd = xmlToAdd + "pitch=\"0.0\" ";
            xmlToAdd = xmlToAdd + "roll=\"0.0\" ";
        }
        xmlToAdd = xmlToAdd + " ";
        String size = XMLReaderUtility.getMiddleString((int)0, (String)xmlForCylinder, (String)"<radius>", (String)"</radius>");
        size.trim();
        xmlToAdd = xmlToAdd + "radius=\"" + size.trim() + "\" ";
        xmlToAdd = xmlToAdd + " ";
        String length = XMLReaderUtility.getMiddleString((int)0, (String)xmlForCylinder, (String)"<length>", (String)"</length>");
        length.trim();
        xmlToAdd = xmlToAdd + "length=\"" + length.trim() + "\" ";
        xmlToAdd = xmlToAdd + "/>\n";
        this.finalXML = this.finalXML + xmlToAdd;
    }

    public static void main(String[] args) {
        new SdfToMaxXML();
    }
}

