/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders.SdfLoader;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.ModelFileType;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.HeightBasedTerrainBlend;
import us.ihmc.graphicsDescription.appearance.SDFAppearance;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.appearance.YoAppearanceMaterial;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.modelFileLoaders.ModelFileLoaderConversionsHelper;
import us.ihmc.modelFileLoaders.SdfLoader.SDFHeightMap;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.AbstractSDFMesh;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFGeometry;
import us.ihmc.robotics.robotDescription.LinkGraphicsDescription;

public class SDFGraphics3DObject
extends LinkGraphicsDescription {
    private static final boolean SHOW_COORDINATE_SYSTEMS = false;
    public static AppearanceDefinition DEFAULT_APPEARANCE = YoAppearance.Orange();

    public SDFGraphics3DObject(List<? extends AbstractSDFMesh> sdfVisuals, List<String> resourceDirectories) {
        this(sdfVisuals, resourceDirectories, (ClassLoader)null);
    }

    public SDFGraphics3DObject(List<? extends AbstractSDFMesh> sdfVisuals, List<String> resourceDirectories, ClassLoader resourceClassLoader) {
        this(sdfVisuals, resourceDirectories, resourceClassLoader, new RigidBodyTransform());
    }

    public SDFGraphics3DObject(List<? extends AbstractSDFMesh> sdfVisuals, List<String> resourceDirectories, RigidBodyTransform graphicsTransform) {
        this(sdfVisuals, resourceDirectories, null, graphicsTransform);
    }

    public SDFGraphics3DObject(List<? extends AbstractSDFMesh> sdfVisuals, List<String> resourceDirectories, ClassLoader resourceClassLoader, RigidBodyTransform graphicsTransform) {
        RotationMatrix rotation = new RotationMatrix();
        Vector3D offset = new Vector3D();
        graphicsTransform.get((RotationMatrixBasics)rotation, (Tuple3DBasics)offset);
        if (sdfVisuals != null) {
            for (AbstractSDFMesh abstractSDFMesh : sdfVisuals) {
                SDFGeometry geometry;
                SDFGeometry.Mesh mesh;
                this.identity();
                this.translate((Tuple3DReadOnly)offset);
                this.rotate((Orientation3DReadOnly)rotation);
                RigidBodyTransform visualPose = ModelFileLoaderConversionsHelper.poseToTransform(abstractSDFMesh.getPose());
                Vector3D modelOffset = new Vector3D();
                RotationMatrix modelRotation = new RotationMatrix();
                visualPose.get((RotationMatrixBasics)modelRotation, (Tuple3DBasics)modelOffset);
                this.translate((Tuple3DReadOnly)modelOffset);
                this.rotate((Orientation3DReadOnly)modelRotation);
                YoAppearanceRGBColor appearance = null;
                if (abstractSDFMesh.getMaterial() != null) {
                    if (abstractSDFMesh.getMaterial().getScript() != null) {
                        ArrayList<String> resourceUrls = new ArrayList<String>();
                        if (abstractSDFMesh.getMaterial().getScript().getUri() != null) {
                            for (String uri : abstractSDFMesh.getMaterial().getScript().getUri()) {
                                if (uri.equals("__default__")) {
                                    resourceUrls.add("/scripts/gazebo.material");
                                    continue;
                                }
                                String id = this.convertToResourceIdentifier(resourceDirectories, resourceClassLoader, uri);
                                resourceUrls.add(id);
                            }
                        }
                        String name = abstractSDFMesh.getMaterial().getScript().getName();
                        appearance = new SDFAppearance(resourceUrls, name, resourceDirectories);
                    } else {
                        YoAppearanceMaterial mat = new YoAppearanceMaterial();
                        mat.setAmbientColor(ModelFileLoaderConversionsHelper.stringToColor(abstractSDFMesh.getMaterial().getAmbient()));
                        mat.setDiffuseColor(ModelFileLoaderConversionsHelper.stringToColor(abstractSDFMesh.getMaterial().getDiffuse()));
                        mat.setSpecularColor(ModelFileLoaderConversionsHelper.stringToColor(abstractSDFMesh.getMaterial().getSpecular()));
                        appearance = mat;
                    }
                }
                if (abstractSDFMesh.getTransparency() != null && Double.parseDouble(abstractSDFMesh.getTransparency()) > 0.0) {
                    if (appearance == null) {
                        appearance = new YoAppearanceRGBColor(DEFAULT_APPEARANCE.getColor(), Double.parseDouble(abstractSDFMesh.getTransparency()));
                    }
                    appearance.setTransparency(Double.parseDouble(abstractSDFMesh.getTransparency()));
                }
                if ((mesh = (geometry = abstractSDFMesh.getGeometry()).getMesh()) != null) {
                    String resourceUrl = this.convertToResourceIdentifier(resourceDirectories, resourceClassLoader, mesh.getUri());
                    if (mesh.getScale() != null) {
                        Vector3D scale = ModelFileLoaderConversionsHelper.stringToVector3d(mesh.getScale());
                        this.scale((Vector3DReadOnly)scale);
                    }
                    String submesh = null;
                    boolean centerSubmesh = false;
                    if (mesh.getSubmesh() != null) {
                        submesh = mesh.getSubmesh().getName().trim();
                        centerSubmesh = mesh.getSubmesh().getCenter().trim().equals("1") || mesh.getSubmesh().getCenter().trim().equals("true");
                    }
                    this.addMesh(resourceUrl, submesh, centerSubmesh, visualPose, (AppearanceDefinition)appearance, resourceDirectories, resourceClassLoader);
                    continue;
                }
                if (geometry.getCylinder() != null) {
                    double length = Double.parseDouble(geometry.getCylinder().getLength());
                    double radius = Double.parseDouble(geometry.getCylinder().getRadius());
                    this.translate(0.0, 0.0, -length / 2.0);
                    this.addCylinder(length, radius, SDFGraphics3DObject.getDefaultAppearanceIfNull((AppearanceDefinition)appearance));
                    continue;
                }
                if (geometry.getBox() != null) {
                    String[] boxDimensions = geometry.getBox().getSize().split(" ");
                    double bx = Double.parseDouble(boxDimensions[0]);
                    double by = Double.parseDouble(boxDimensions[1]);
                    double bz = Double.parseDouble(boxDimensions[2]);
                    this.translate(0.0, 0.0, -bz / 2.0);
                    this.addCube(bx, by, bz, SDFGraphics3DObject.getDefaultAppearanceIfNull((AppearanceDefinition)appearance));
                    continue;
                }
                if (geometry.getSphere() != null) {
                    double radius = Double.parseDouble(geometry.getSphere().getRadius());
                    this.addSphere(radius, SDFGraphics3DObject.getDefaultAppearanceIfNull((AppearanceDefinition)appearance));
                    continue;
                }
                if (geometry.getPlane() != null) {
                    Vector3D normal = ModelFileLoaderConversionsHelper.stringToNormalizedVector3d(geometry.getPlane().getNormal());
                    Vector2D size = ModelFileLoaderConversionsHelper.stringToVector2d(geometry.getPlane().getSize());
                    AxisAngle planeRotation = EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)normal);
                    this.rotate((Orientation3DReadOnly)planeRotation);
                    this.addCube(size.getX(), size.getY(), 0.005, SDFGraphics3DObject.getDefaultAppearanceIfNull((AppearanceDefinition)appearance));
                    continue;
                }
                if (geometry.getHeightMap() != null) {
                    String id = this.convertToResourceIdentifier(resourceDirectories, resourceClassLoader, geometry.getHeightMap().getUri());
                    SDFHeightMap heightMap = new SDFHeightMap(id, geometry.getHeightMap());
                    AppearanceDefinition app = DEFAULT_APPEARANCE;
                    if (geometry.getHeightMap().getTextures() != null) {
                        double width = heightMap.getBoundingBox().getMaxX() - heightMap.getBoundingBox().getMinX();
                        HeightBasedTerrainBlend sdfTerrainBlend = new HeightBasedTerrainBlend((HeightMap)heightMap);
                        for (SDFGeometry.HeightMap.Texture text : geometry.getHeightMap().getTextures()) {
                            double size = Double.parseDouble(text.getSize());
                            double scale = width / size;
                            sdfTerrainBlend.addTexture(scale, this.convertToResourceIdentifier(resourceDirectories, resourceClassLoader, text.getDiffuse()), this.convertToResourceIdentifier(resourceDirectories, resourceClassLoader, text.getNormal()));
                        }
                        for (SDFGeometry.HeightMap.Blend blend : geometry.getHeightMap().getBlends()) {
                            sdfTerrainBlend.addBlend(Double.parseDouble(blend.getMinHeight()), Double.parseDouble(blend.getFadeDist()));
                        }
                        app = sdfTerrainBlend;
                    }
                    this.translate((Tuple3DReadOnly)heightMap.getOffset());
                    this.addHeightMap(heightMap, 1000, 1000, app);
                    continue;
                }
                System.err.println("Visual for " + abstractSDFMesh.getName() + " not implemented yet");
                System.err.println("Defined visual" + ToStringBuilder.reflectionToString((Object)geometry));
            }
        }
    }

    private static AppearanceDefinition getDefaultAppearanceIfNull(AppearanceDefinition appearance) {
        if (appearance == null) {
            return DEFAULT_APPEARANCE;
        }
        return appearance;
    }

    private void addMesh(String mesh, String submesh, boolean centerSubmesh, RigidBodyTransform visualPose, AppearanceDefinition appearance, List<String> resourceDirectories, ClassLoader resourceClassLoader) {
        if (ModelFileType.getModelTypeFromId((String)mesh) == ModelFileType._STL) {
            appearance = SDFGraphics3DObject.getDefaultAppearanceIfNull(appearance);
        }
        this.addModelFile(mesh, submesh, centerSubmesh, resourceDirectories, resourceClassLoader, appearance);
    }

    private String convertToResourceIdentifier(List<String> resourceDirectories, ClassLoader resourceClassLoader, String meshPath) {
        String id;
        if (meshPath.equals("__default__")) {
            meshPath = "file://media/materials/scripts/gazebo.material";
        }
        if (resourceDirectories.size() == 0 && (id = this.tryConversion(meshPath, "", resourceClassLoader)) != null) {
            return id;
        }
        for (String resourceDirectory : resourceDirectories) {
            String id2 = this.tryConversion(meshPath, resourceDirectory, resourceClassLoader);
            if (id2 == null) continue;
            return id2;
        }
        System.out.println(meshPath);
        throw new RuntimeException("Resource not found: " + meshPath);
    }

    private String tryConversion(String meshPath, String resourceDirectory, ClassLoader resourceClassLoader) {
        try {
            URL resource;
            URI meshURI = new URI(meshPath);
            String authority = meshURI.getAuthority() == null ? "" : meshURI.getAuthority();
            String id = resourceDirectory + authority + meshURI.getPath();
            if (resourceClassLoader == null) {
                resourceClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            if ((resource = resourceClassLoader.getResource(id)) != null) {
                return id;
            }
            File f = new File(id);
            if (f.exists()) {
                return id;
            }
        }
        catch (URISyntaxException e) {
            System.err.println("Malformed resource path in .SDF file for path: " + meshPath);
        }
        return null;
    }

    static {
        YoAppearance.makeTransparent((AppearanceDefinition)DEFAULT_APPEARANCE, (double)0.4);
    }
}

