/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders.SdfLoader;

import java.util.List;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.modelFileLoaders.ModelFileLoaderConversionsHelper;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.AbstractSDFMesh;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFGeometry;
import us.ihmc.robotics.robotDescription.CollisionMeshDescription;

public class SDFCollisionMeshDescription
extends CollisionMeshDescription {
    private static final boolean verbose = false;

    public SDFCollisionMeshDescription(List<? extends AbstractSDFMesh> sdfVisuals) {
        this(sdfVisuals, new RigidBodyTransform());
    }

    public SDFCollisionMeshDescription(List<? extends AbstractSDFMesh> sdfVisuals, RigidBodyTransform graphicsTransform) {
        RotationMatrix rotation = new RotationMatrix();
        Vector3D offset = new Vector3D();
        graphicsTransform.get((RotationMatrixBasics)rotation, (Tuple3DBasics)offset);
        if (sdfVisuals != null) {
            for (AbstractSDFMesh abstractSDFMesh : sdfVisuals) {
                this.identity();
                this.translate((Tuple3DReadOnly)offset);
                this.rotate((Orientation3DReadOnly)rotation);
                RigidBodyTransform visualPose = ModelFileLoaderConversionsHelper.poseToTransform(abstractSDFMesh.getPose());
                Vector3D modelOffset = new Vector3D();
                RotationMatrix modelRotation = new RotationMatrix();
                visualPose.get((RotationMatrixBasics)modelRotation, (Tuple3DBasics)modelOffset);
                this.translate((Tuple3DReadOnly)modelOffset);
                this.rotate((Orientation3DReadOnly)modelRotation);
                SDFGeometry geometry = abstractSDFMesh.getGeometry();
                SDFGeometry.Mesh mesh = geometry.getMesh();
                if (geometry.getCylinder() != null) {
                    double length = Double.parseDouble(geometry.getCylinder().getLength());
                    double radius = Double.parseDouble(geometry.getCylinder().getRadius());
                    this.addCylinderReferencedAtCenter(radius, length);
                    continue;
                }
                if (geometry.getBox() != null) {
                    String[] boxDimensions = geometry.getBox().getSize().split(" ");
                    double bx = Double.parseDouble(boxDimensions[0]);
                    double by = Double.parseDouble(boxDimensions[1]);
                    double bz = Double.parseDouble(boxDimensions[2]);
                    this.addCubeReferencedAtCenter(bx, by, bz);
                    continue;
                }
                if (geometry.getSphere() != null) {
                    double radius = Double.parseDouble(geometry.getSphere().getRadius());
                    this.addSphere(radius);
                    continue;
                }
                if (geometry.getPlane() != null) {
                    throw new RuntimeException("Planes not implemented yet for CollisionMeshes!!");
                }
                if (geometry.getHeightMap() == null) continue;
                throw new RuntimeException("Height Map not implemented for CollisionMeshes!!");
            }
        }
    }
}

