/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.partNames.ContactPointDefinitionHolder;
import us.ihmc.robotics.partNames.JointNameMap;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.ModelFileGeometryDefinition;
import us.ihmc.scs2.definition.robot.ExternalWrenchPointDefinition;
import us.ihmc.scs2.definition.robot.GroundContactPointDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.KinematicPointDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.PrismaticJointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SensorDefinition;
import us.ihmc.scs2.definition.robot.sdf.SDFTools;
import us.ihmc.scs2.definition.robot.sdf.items.SDFRoot;
import us.ihmc.scs2.definition.robot.urdf.URDFTools;
import us.ihmc.scs2.definition.robot.urdf.items.URDFModel;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;

public class RobotDefinitionLoader {
    public static final String DEFAULT_ROOT_BODY_NAME = "elevator";

    public static RobotDefinition loadURDFModel(InputStream stream, Collection<String> resourceDirectories, ClassLoader classLoader, String modelName, ContactPointDefinitionHolder contactPointDefinitionHolder, JointNameMap<?> jointNameMap, boolean removeCollisionMeshes) {
        return RobotDefinitionLoader.loadURDFModel(stream, resourceDirectories, classLoader, modelName, contactPointDefinitionHolder, jointNameMap, removeCollisionMeshes, URDFTools.DEFAULT_URDF_PARSER_PROPERTIES);
    }

    public static RobotDefinition loadURDFModel(InputStream stream, Collection<String> resourceDirectories, ClassLoader classLoader, String modelName, ContactPointDefinitionHolder contactPointDefinitionHolder, JointNameMap<?> jointNameMap, boolean removeCollisionMeshes, URDFTools.URDFParserProperties urdfParserProperties) {
        try {
            URDFModel urdfRoot = URDFTools.loadURDFModel((InputStream)stream, resourceDirectories, (ClassLoader)classLoader);
            RobotDefinition robotDefinition = URDFTools.toRobotDefinition((URDFModel)urdfRoot, (URDFTools.URDFParserProperties)urdfParserProperties);
            robotDefinition.getRootBodyDefinition().setName(DEFAULT_ROOT_BODY_NAME);
            if (contactPointDefinitionHolder != null) {
                RobotDefinitionLoader.addGroundContactPoints(robotDefinition, contactPointDefinitionHolder);
            }
            if (jointNameMap != null) {
                for (String jointName : jointNameMap.getLastSimulatedJoints()) {
                    robotDefinition.addSubtreeJointsToIgnore(jointName);
                }
                RobotDefinitionLoader.adjustJointLimitStops(robotDefinition, jointNameMap);
            }
            RobotDefinitionLoader.adjustRigidBodyInterias(robotDefinition);
            if (removeCollisionMeshes) {
                RobotDefinitionLoader.removeCollisionShapeDefinitions(robotDefinition);
            }
            return robotDefinition;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static RobotDefinition loadSDFModel(InputStream stream, Collection<String> resourceDirectories, ClassLoader classLoader, String modelName, ContactPointDefinitionHolder contactPointDefinitionHolder, JointNameMap<?> jointNameMap, boolean removeCollisionMeshes) {
        try {
            SDFRoot sdfRoot = SDFTools.loadSDFRoot((InputStream)stream, resourceDirectories, (ClassLoader)classLoader);
            RobotDefinition robotDefinition = SDFTools.toFloatingRobotDefinition((SDFRoot)sdfRoot, (String)modelName);
            robotDefinition.getRootBodyDefinition().setName(DEFAULT_ROOT_BODY_NAME);
            if (contactPointDefinitionHolder != null) {
                RobotDefinitionLoader.addGroundContactPoints(robotDefinition, contactPointDefinitionHolder);
            }
            if (jointNameMap != null) {
                for (String jointName : jointNameMap.getLastSimulatedJoints()) {
                    robotDefinition.addSubtreeJointsToIgnore(jointName);
                }
                RobotDefinitionLoader.adjustJointLimitStops(robotDefinition, jointNameMap);
            }
            RobotDefinitionLoader.adjustRigidBodyInterias(robotDefinition);
            if (removeCollisionMeshes) {
                RobotDefinitionLoader.removeCollisionShapeDefinitions(robotDefinition);
            }
            return robotDefinition;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setDefaultMaterial(RobotDefinition robotDefinition) {
        RobotDefinitionLoader.setDefaultMaterial(robotDefinition, new MaterialDefinition(ColorDefinitions.Orange().derive(0.0, 1.0, 1.0, 0.4)));
    }

    public static void setDefaultMaterial(RobotDefinition robotDefinition, MaterialDefinition defaultMaterial) {
        for (RigidBodyDefinition rigidBodyDefinition : robotDefinition.getAllRigidBodies()) {
            for (VisualDefinition visualDefinition : rigidBodyDefinition.getVisualDefinitions()) {
                GeometryDefinition geometryDefinition;
                if (visualDefinition.getMaterialDefinition() != null || (geometryDefinition = visualDefinition.getGeometryDefinition()) instanceof ModelFileGeometryDefinition && !((ModelFileGeometryDefinition)geometryDefinition).getFileName().toLowerCase().endsWith(".stl")) continue;
                visualDefinition.setMaterialDefinition(defaultMaterial);
            }
        }
    }

    public static void removeCollisionShapeDefinitions(RobotDefinition robotDefinition) {
        for (RigidBodyDefinition body : robotDefinition.getAllRigidBodies()) {
            body.getCollisionShapeDefinitions().clear();
        }
    }

    public static void setRobotDefinitionMaterial(RobotDefinition robotDefinition, MaterialDefinition materialDefinition) {
        for (RigidBodyDefinition body : robotDefinition.getAllRigidBodies()) {
            body.getVisualDefinitions().forEach(visual -> visual.setMaterialDefinition(materialDefinition));
        }
    }

    public static void setRobotDefinitionTransparency(RobotDefinition robotDefinition, double transparency) {
        RobotDefinitionLoader.setRobotDefinitionMaterial(robotDefinition, new MaterialDefinition(ColorDefinitions.Orange().derive(0.0, 1.0, 1.0, 1.0 - transparency)));
    }

    public static void adjustJointLimitStops(RobotDefinition robotDefinition, JointNameMap<?> jointNameMap) {
        for (JointDefinition joint : robotDefinition.getAllJoints()) {
            if (joint instanceof RevoluteJointDefinition) {
                RevoluteJointDefinition revoluteJoint = (RevoluteJointDefinition)joint;
                if (RobotDefinitionLoader.isJointInNeedOfReducedGains(joint.getName())) {
                    revoluteJoint.setKpSoftLimitStop(10.0);
                    revoluteJoint.setKdSoftLimitStop(2.5);
                } else if (revoluteJoint.getKpSoftLimitStop() <= 0.0 && revoluteJoint.getKdSoftLimitStop() <= 0.0) {
                    revoluteJoint.setKpSoftLimitStop(jointNameMap.getJointKLimit(joint.getName()));
                    revoluteJoint.setKdSoftLimitStop(jointNameMap.getJointBLimit(joint.getName()));
                } else {
                    revoluteJoint.setKpSoftLimitStop(1.0E-4 * revoluteJoint.getKpSoftLimitStop());
                    revoluteJoint.setKdSoftLimitStop(0.1 * revoluteJoint.getKdSoftLimitStop());
                }
                if (RobotDefinitionLoader.isJointInNeedOfReducedGains(joint.getName())) continue;
                revoluteJoint.setDampingVelocitySoftLimit(jointNameMap.getDefaultVelocityLimitDamping());
                continue;
            }
            if (!(joint instanceof PrismaticJointDefinition)) continue;
            PrismaticJointDefinition prismaticJoint = (PrismaticJointDefinition)joint;
            if (RobotDefinitionLoader.isJointInNeedOfReducedGains(joint.getName())) {
                prismaticJoint.setKpSoftLimitStop(100.0);
                prismaticJoint.setKdSoftLimitStop(20.0);
            } else if (prismaticJoint.getKpSoftLimitStop() <= 0.0 && prismaticJoint.getKdSoftLimitStop() <= 0.0) {
                prismaticJoint.setKpSoftLimitStop(jointNameMap.getJointKLimit(joint.getName()));
                prismaticJoint.setKdSoftLimitStop(jointNameMap.getJointBLimit(joint.getName()));
            } else {
                prismaticJoint.setKpSoftLimitStop(1.0E-4 * prismaticJoint.getKpSoftLimitStop());
                prismaticJoint.setKdSoftLimitStop(prismaticJoint.getKdSoftLimitStop());
            }
            if (RobotDefinitionLoader.isJointInNeedOfReducedGains(joint.getName())) continue;
            prismaticJoint.setDampingVelocitySoftLimit(jointNameMap.getDefaultVelocityLimitDamping());
        }
    }

    public static void adjustRigidBodyInterias(RobotDefinition robotDefinition) {
        for (JointDefinition joint : robotDefinition.getAllJoints()) {
            if (!RobotDefinitionLoader.isJointInNeedOfReducedGains(joint.getName())) continue;
            RigidBodyDefinition successor = joint.getSuccessor();
            successor.getMomentOfInertia().scale(100.0);
        }
    }

    private static boolean isJointInNeedOfReducedGains(String jointName) {
        return jointName.contains("f0") || jointName.contains("f1") || jointName.contains("f2") || jointName.contains("f3") || jointName.contains("palm") || jointName.contains("finger");
    }

    public static void addGroundContactPoints(RobotDefinition robotDefinition, ContactPointDefinitionHolder contactPointHolder) {
        RobotDefinitionLoader.addGroundContactPoints(robotDefinition, contactPointHolder, true);
    }

    public static void addGroundContactPoints(RobotDefinition robotDefinition, ContactPointDefinitionHolder contactPointHolder, boolean addVisualization) {
        RobotDefinitionLoader.addGroundContactPoints(robotDefinition, contactPointHolder, addVisualization ? 0.01 : 0.0);
    }

    public static void addGroundContactPoints(RobotDefinition robotDefinition, ContactPointDefinitionHolder contactPointHolder, double contactPointVizSize) {
        if (contactPointHolder == null) {
            return;
        }
        LinkedHashMap<String, Integer> counters = new LinkedHashMap<String, Integer>();
        for (ImmutablePair jointContactPoint : contactPointHolder.getJointNameGroundContactPointMap()) {
            String jointName = (String)jointContactPoint.getLeft();
            int count = counters.get(jointName) == null ? 0 : (Integer)counters.get(jointName);
            Vector3D gcOffset = (Vector3D)jointContactPoint.getRight();
            GroundContactPointDefinition groundContactPoint = new GroundContactPointDefinition();
            groundContactPoint.setName("gc_" + jointName + "_" + count++);
            groundContactPoint.getTransformToParent().getTranslation().set((Tuple3DReadOnly)gcOffset);
            groundContactPoint.setGroupIdentifier(contactPointHolder.getGroupIdentifier(jointContactPoint));
            ExternalWrenchPointDefinition externalWrenchPoint = new ExternalWrenchPointDefinition();
            externalWrenchPoint.setName("ef_" + jointName + "_" + count++);
            externalWrenchPoint.getTransformToParent().getTranslation().set((Tuple3DReadOnly)gcOffset);
            JointDefinition jointDefinition = robotDefinition.getJointDefinition(jointName);
            if (jointDefinition == null) {
                LogTools.error((String)"No joint named {}. Skipping...", (Object)jointName);
                continue;
            }
            jointDefinition.addGroundContactPointDefinition(groundContactPoint);
            jointDefinition.addExternalWrenchPointDefinition(externalWrenchPoint);
            counters.put(jointName, count);
            if (!Double.isFinite(contactPointVizSize) || !(contactPointVizSize > 0.0)) continue;
            VisualDefinitionFactory visualDefinitionFactory = new VisualDefinitionFactory();
            visualDefinitionFactory.appendTranslation((Tuple3DReadOnly)jointContactPoint.getRight());
            visualDefinitionFactory.addSphere(contactPointVizSize, ColorDefinitions.Orange());
            jointDefinition.getSuccessor().getVisualDefinitions().addAll(visualDefinitionFactory.getVisualDefinitions());
        }
    }

    public static void scaleRobotDefinition(RobotDefinition definition, double modelScale, double massScalePower, Predicate<JointDefinition> jointFilter) {
        RobotDefinitionLoader.scaleRigidBodyDefinitionRecursive(definition.getRootBodyDefinition(), modelScale, massScalePower, jointFilter, true);
    }

    public static void scaleRigidBodyDefinitionRecursive(RigidBodyDefinition definition, double modelScale, double massScalePower, Predicate<JointDefinition> jointFilter, boolean scaleInertia) {
        if (scaleInertia && definition.getParentJoint() != null) {
            scaleInertia &= jointFilter.test(definition.getParentJoint());
        }
        RobotDefinitionLoader.scaleRigidBodyDefinition(definition, modelScale, massScalePower, scaleInertia);
        for (JointDefinition joint : definition.getChildrenJoints()) {
            RobotDefinitionLoader.scaleJointDefinition(joint, modelScale, massScalePower);
            RobotDefinitionLoader.scaleRigidBodyDefinitionRecursive(joint.getSuccessor(), modelScale, massScalePower, jointFilter, scaleInertia);
        }
    }

    public static void scaleJointDefinition(JointDefinition definition, double modelScale, double massScalePower) {
        definition.getTransformToParent().getTranslation().scale(modelScale);
        for (SensorDefinition sensor : definition.getSensorDefinitions()) {
            sensor.getTransformToJoint().getTranslation().scale(modelScale);
        }
        for (KinematicPointDefinition kp : definition.getKinematicPointDefinitions()) {
            kp.getTransformToParent().getTranslation().scale(modelScale);
        }
        if (definition instanceof OneDoFJointDefinition) {
            double massScale = Math.pow(modelScale, massScalePower);
            OneDoFJointDefinition oneDoFJoint = (OneDoFJointDefinition)definition;
            oneDoFJoint.setDamping(massScale * oneDoFJoint.getDamping());
            oneDoFJoint.setKpSoftLimitStop(massScale * oneDoFJoint.getKpSoftLimitStop());
            oneDoFJoint.setKdSoftLimitStop(massScale * oneDoFJoint.getKdSoftLimitStop());
            oneDoFJoint.setDampingVelocitySoftLimit(massScale * oneDoFJoint.getDampingVelocitySoftLimit());
        }
    }

    public static void scaleRigidBodyDefinition(RigidBodyDefinition definition, double modelScale, double massScalePower, boolean scaleInertia) {
        definition.getCenterOfMassOffset().scale(modelScale);
        if (scaleInertia) {
            double massScale = Math.pow(modelScale, massScalePower);
            definition.setMass(massScale * definition.getMass());
            if (definition.getMomentOfInertia() != null) {
                double inertiaScale = Math.pow(modelScale, massScalePower + 2.0);
                definition.getMomentOfInertia().scale(inertiaScale);
            }
        }
        for (VisualDefinition visual : definition.getVisualDefinitions()) {
            visual.getOriginPose().appendScale(modelScale);
        }
        for (CollisionShapeDefinition collision : definition.getCollisionShapeDefinitions()) {
            RobotDefinitionLoader.scaleCollisionShapeDefinition(collision, modelScale);
        }
    }

    private static void scaleCollisionShapeDefinition(CollisionShapeDefinition definition, double scale) {
        throw new RuntimeException("TODO: Implement me");
    }

    public static Consumer<RobotDefinition> jointLimitRemover() {
        return RobotDefinitionLoader.jointLimitRemover(null);
    }

    public static Consumer<RobotDefinition> jointLimitRemover(String nameFilter) {
        return RobotDefinitionLoader.jointLimitMutator(nameFilter, -100.0, 100.0);
    }

    public static Consumer<RobotDefinition> jointLimitMutator(String nameFilter, double lowerLimit, double upperLimit) {
        return robotDefinition -> {
            for (JointDefinition joint : robotDefinition.getAllJoints()) {
                String jointName = joint.getName();
                if (!(joint instanceof OneDoFJointDefinition) || nameFilter != null && !nameFilter.isEmpty() && !jointName.contains(nameFilter)) continue;
                ((OneDoFJointDefinition)joint).setPositionLimits(lowerLimit, upperLimit);
            }
        };
    }
}

