/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders.SdfLoader;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.modelFileLoaders.SdfLoader.GeneralizedSDFRobotModel;
import us.ihmc.modelFileLoaders.SdfLoader.SDFGraphics3DObject;
import us.ihmc.modelFileLoaders.SdfLoader.SDFJointHolder;
import us.ihmc.modelFileLoaders.SdfLoader.SDFLinkHolder;

public class SDFModelVisual
extends Graphics3DObject {
    private final List<String> resourceDirectories;
    private final HashSet<SDFLinkHolder> addedLinks = new HashSet();

    public SDFModelVisual(GeneralizedSDFRobotModel generalizedSDFRobotModel) {
        this(generalizedSDFRobotModel, false);
    }

    public SDFModelVisual(GeneralizedSDFRobotModel generalizedSDFRobotModel, boolean useCollisionMeshes) {
        this.resourceDirectories = generalizedSDFRobotModel.getResourceDirectories();
        ArrayList<SDFLinkHolder> rootLinks = generalizedSDFRobotModel.getRootLinks();
        RigidBodyTransform modelTransform = generalizedSDFRobotModel.getTransformToRoot();
        for (SDFLinkHolder link : rootLinks) {
            this.recursivelyAddLinks(link, modelTransform, useCollisionMeshes);
        }
    }

    private void recursivelyAddLinks(SDFLinkHolder link, RigidBodyTransform modelTransform, boolean useCollisionMeshes) {
        if (this.addedLinks.contains(link)) {
            return;
        }
        this.addedLinks.add(link);
        if (link.getVisuals() != null) {
            RigidBodyTransform transformToModel = new RigidBodyTransform((RigidBodyTransformReadOnly)modelTransform);
            transformToModel.multiply((RigidBodyTransformReadOnly)link.getTransformFromModelReferenceFrame());
            SDFGraphics3DObject sdfGraphics3DObject = useCollisionMeshes ? new SDFGraphics3DObject(link.getCollisions(), this.resourceDirectories, transformToModel) : new SDFGraphics3DObject(link.getVisuals(), this.resourceDirectories, transformToModel);
            this.getGraphics3DInstructions().addAll(sdfGraphics3DObject.getGraphics3DInstructions());
        }
        for (SDFJointHolder joint : link.getChildren()) {
            this.recursivelyAddLinks(joint.getChildLinkHolder(), modelTransform, useCollisionMeshes);
        }
    }
}

