/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders.SdfLoader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBException;
import us.ihmc.modelFileLoaders.SdfLoader.GeneralizedSDFRobotModel;
import us.ihmc.modelFileLoaders.SdfLoader.JaxbSDFLoader;
import us.ihmc.modelFileLoaders.SdfLoader.RobotDescriptionFromSDFLoader;
import us.ihmc.modelFileLoaders.SdfLoader.SDFDescriptionMutator;
import us.ihmc.robotics.robotDescription.RobotDescription;
import us.ihmc.robotics.robotDescription.modelLoaders.LogModelLoader;

public class SDFModelLoader
implements LogModelLoader {
    private static final String resourceDirectoryLocation = System.getProperty("user.home") + File.separator + ".ihmc" + File.separator + "resources";
    private String modelName;
    private byte[] model;
    private String[] resourceDirectories;
    private byte[] resourceZip;
    private SDFDescriptionMutator descriptionMutator;

    public void load(String modelName, byte[] model, String[] resourceDirectories, byte[] resourceZip) {
        this.load(modelName, model, resourceDirectories, resourceZip, null);
    }

    public void load(String modelName, byte[] model, String[] resourceDirectories, byte[] resourceZip, SDFDescriptionMutator descriptionMutator) {
        this.modelName = modelName;
        this.model = model;
        this.resourceDirectories = resourceDirectories;
        this.resourceZip = resourceZip;
        this.descriptionMutator = descriptionMutator;
    }

    public String toString() {
        return "SDFModelLoader [modelName=" + this.modelName + ", model=" + this.model.length + ", resourceDirectories=" + Arrays.toString(this.resourceDirectories) + ", resourceZip=" + this.resourceZip.length + "]";
    }

    public RobotDescription createRobot() {
        boolean useCollisionMeshes = false;
        GeneralizedSDFRobotModel generalizedSDFRobotModel = this.createJaxbSDFLoader().getGeneralizedSDFRobotModel(this.modelName);
        RobotDescriptionFromSDFLoader loader = new RobotDescriptionFromSDFLoader();
        RobotDescription description = loader.loadRobotDescriptionFromSDF(generalizedSDFRobotModel, null, null, useCollisionMeshes);
        return description;
    }

    public JaxbSDFLoader createJaxbSDFLoader() {
        URLClassLoader resourceClassLoader = null;
        if (this.resourceZip != null) {
            Path resourceDirectory = Paths.get(resourceDirectoryLocation, this.modelName);
            try {
                Files.createDirectories(resourceDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this.resourceZip);
            ZipInputStream zip = new ZipInputStream(is);
            ZipEntry ze = null;
            try {
                while ((ze = zip.getNextEntry()) != null) {
                    Path target = resourceDirectory.resolve(ze.getName());
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(zip, target, StandardCopyOption.REPLACE_EXISTING);
                }
                zip.close();
                is.close();
            }
            catch (IOException e) {
                System.err.println("SDFModelLoader: Cannot load model zip file. Not unpacking robot model.");
            }
            try {
                resourceClassLoader = new URLClassLoader(new URL[]{resourceDirectory.toUri().toURL()});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ByteArrayInputStream is = new ByteArrayInputStream(this.model);
        try {
            return new JaxbSDFLoader(is, Arrays.asList(this.resourceDirectories), resourceClassLoader, this.descriptionMutator);
        }
        catch (FileNotFoundException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public String getModelName() {
        return this.modelName;
    }

    public byte[] getModel() {
        return this.model;
    }

    public String[] getResourceDirectories() {
        return this.resourceDirectories;
    }

    public byte[] getResourceZip() {
        return this.resourceZip;
    }
}

