/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders.SdfLoader;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.modelFileLoaders.ModelFileLoaderConversionsHelper;
import us.ihmc.modelFileLoaders.SdfLoader.SDFJointHolder;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.Collision;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFLink;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFSensor;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFVisual;

public class SDFLinkHolder {
    private final String name;
    private final RigidBodyTransform transformToModelReferenceFrame;
    private double mass;
    private final RigidBodyTransform inertialFrameWithRespectToLinkFrame;
    private final Matrix3D inertia;
    private double contactKp = 0.0;
    private double contactKd = 0.0;
    private double contactMaxVel = 0.0;
    private final List<SDFVisual> visuals;
    private final List<SDFSensor> sensors;
    private final List<Collision> collisions;
    private SDFJointHolder joint = null;
    private final ArrayList<SDFJointHolder> childeren = new ArrayList();
    private final Vector3D CoMOffset = new Vector3D();

    public SDFLinkHolder(SDFLink sdfLink) {
        this.name = ModelFileLoaderConversionsHelper.sanitizeJointName(sdfLink.getName());
        this.transformToModelReferenceFrame = ModelFileLoaderConversionsHelper.poseToTransform(sdfLink.getPose());
        if (sdfLink.getInertial() != null) {
            this.inertialFrameWithRespectToLinkFrame = ModelFileLoaderConversionsHelper.poseToTransform(sdfLink.getInertial().getPose());
            this.mass = Double.parseDouble(sdfLink.getInertial().getMass());
            this.inertia = ModelFileLoaderConversionsHelper.sdfInertiaToMatrix3d(sdfLink.getInertial().getInertia());
        } else {
            this.inertialFrameWithRespectToLinkFrame = new RigidBodyTransform();
            this.mass = 0.0;
            this.inertia = new Matrix3D();
        }
        this.visuals = sdfLink.getVisuals();
        this.sensors = sdfLink.getSensors();
        if (sdfLink.getCollisions() != null) {
            this.collisions = sdfLink.getCollisions();
            if (sdfLink.getCollisions().get(0) != null && sdfLink.getCollisions().get(0).getSurface() != null && sdfLink.getCollisions().get(0).getSurface().getContact() != null && sdfLink.getCollisions().get(0).getSurface().getContact().getOde() != null) {
                if (sdfLink.getCollisions().get(0).getSurface().getContact().getOde().getKp() != null) {
                    this.contactKp = Double.parseDouble(sdfLink.getCollisions().get(0).getSurface().getContact().getOde().getKp());
                }
                if (sdfLink.getCollisions().get(0).getSurface().getContact().getOde().getKd() != null) {
                    this.contactKd = Double.parseDouble(sdfLink.getCollisions().get(0).getSurface().getContact().getOde().getKd());
                }
                if (sdfLink.getCollisions().get(0).getSurface().getContact().getOde().getMaxVel() != null) {
                    this.contactMaxVel = Double.parseDouble(sdfLink.getCollisions().get(0).getSurface().getContact().getOde().getMaxVel());
                }
            }
        } else {
            this.collisions = new ArrayList<Collision>();
        }
    }

    public RigidBodyTransform getTransformFromModelReferenceFrame() {
        return this.transformToModelReferenceFrame;
    }

    public void calculateCoMOffset() {
        RigidBodyTransform modelFrameToJointFrame = new RigidBodyTransform();
        if (this.joint != null) {
            modelFrameToJointFrame.set(this.joint.getTransformFromChildLink());
        }
        RigidBodyTransform jointFrameToModelFrame = new RigidBodyTransform();
        jointFrameToModelFrame.setAndInvert((RigidBodyTransformReadOnly)modelFrameToJointFrame);
        RigidBodyTransform modelFrameToInertialFrame = this.inertialFrameWithRespectToLinkFrame;
        RigidBodyTransform jointFrameToInertialFrame = new RigidBodyTransform();
        jointFrameToInertialFrame.set(jointFrameToModelFrame);
        jointFrameToInertialFrame.multiply((RigidBodyTransformReadOnly)modelFrameToInertialFrame);
        Vector3D CoMOffset = new Vector3D();
        Matrix3D inertialFrameRotation = new Matrix3D();
        jointFrameToInertialFrame.get((CommonMatrix3DBasics)inertialFrameRotation, (Tuple3DBasics)CoMOffset);
        if (!inertialFrameRotation.epsilonEquals(MatrixTools.IDENTITY, 1.0E-5)) {
            inertialFrameRotation.transpose();
            this.inertia.multiply((Matrix3DReadOnly)inertialFrameRotation);
            inertialFrameRotation.transpose();
            inertialFrameRotation.multiply((Matrix3DReadOnly)this.inertia);
            this.inertia.set(inertialFrameRotation);
            this.inertialFrameWithRespectToLinkFrame.setRotationAndZeroTranslation((Matrix3DReadOnly)MatrixTools.IDENTITY);
        }
        this.CoMOffset.set(CoMOffset);
    }

    public ArrayList<SDFJointHolder> getChildren() {
        return this.childeren;
    }

    public void addChild(SDFJointHolder child) {
        this.childeren.add(child);
    }

    public SDFJointHolder getJoint() {
        return this.joint;
    }

    public void setJoint(SDFJointHolder joint) {
        this.joint = joint;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public List<SDFVisual> getVisuals() {
        return this.visuals;
    }

    public double getMass() {
        return this.mass;
    }

    public Matrix3D getInertia() {
        return this.inertia;
    }

    public Vector3D getCoMOffset() {
        return this.CoMOffset;
    }

    public double getContactKp() {
        return this.contactKp;
    }

    public double getContactKd() {
        return this.contactKd;
    }

    public double getContactMaxVel() {
        return this.contactMaxVel;
    }

    public List<SDFSensor> getSensors() {
        return this.sensors;
    }

    public List<Collision> getCollisions() {
        return this.collisions;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public void setInertialFrameWithRespectToLinkFrame(RigidBodyTransform newTransform) {
        this.inertialFrameWithRespectToLinkFrame.set(newTransform);
    }

    public RigidBodyTransform getInertialFrameWithRespectToLinkFrame() {
        return this.inertialFrameWithRespectToLinkFrame;
    }

    public void setInertia(Matrix3D inertia) {
        this.inertia.set(inertia);
    }
}

