/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders.SdfLoader;

import java.io.IOException;
import java.util.ArrayList;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.modelFileLoaders.ModelFileLoaderConversionsHelper;
import us.ihmc.modelFileLoaders.SdfLoader.SDFContactSensor;
import us.ihmc.modelFileLoaders.SdfLoader.SDFForceSensor;
import us.ihmc.modelFileLoaders.SdfLoader.SDFJointType;
import us.ihmc.modelFileLoaders.SdfLoader.SDFLinkHolder;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFJoint;

public class SDFJointHolder {
    public static final boolean DEBUG = false;
    private final String name;
    private final SDFJointType type;
    private final Vector3D axisInModelFrame;
    private boolean hasLimits;
    private double upperLimit;
    private double lowerLimit;
    private double effortLimit;
    private final double velocityLimit;
    private final RigidBodyTransform transformFromChildLink;
    private double damping = 0.0;
    private double friction = 0.0;
    private final ArrayList<SDFForceSensor> forceSensors = new ArrayList();
    private final ArrayList<SDFContactSensor> contactSensors = new ArrayList();
    private SDFLinkHolder parentLinkHolder;
    private SDFLinkHolder childLinkHolder;
    private RigidBodyTransform transformToParentJoint = null;
    private final RotationMatrix linkRotation = new RotationMatrix();
    private final Vector3D offsetFromParentJoint = new Vector3D();
    private final Vector3D axisInParentFrame = new Vector3D();
    private final Vector3D axisInJointFrame = new Vector3D();
    private double contactKp;
    private double contactKd;
    private double maxVel;

    public SDFJointHolder(SDFJoint sdfJoint, SDFLinkHolder parent, SDFLinkHolder child) throws IOException {
        this.name = SDFJointHolder.createValidVariableName(sdfJoint.getName());
        String typeString = sdfJoint.getType();
        if (typeString.equalsIgnoreCase("revolute")) {
            this.type = SDFJointType.REVOLUTE;
        } else if (typeString.equalsIgnoreCase("prismatic")) {
            this.type = SDFJointType.PRISMATIC;
        } else {
            throw new IOException("Joint type " + typeString + " not implemented yet");
        }
        this.axisInModelFrame = ModelFileLoaderConversionsHelper.stringToNormalizedVector3d(sdfJoint.getAxis().getXyz());
        if (sdfJoint.getAxis().getLimit() != null) {
            double sdfUpperLimit = Double.parseDouble(sdfJoint.getAxis().getLimit().getUpper());
            double sdfLowerLimit = Double.parseDouble(sdfJoint.getAxis().getLimit().getLower());
            this.setLimits(sdfLowerLimit, sdfUpperLimit);
            this.velocityLimit = sdfJoint.getAxis().getLimit().getVelocity() != null ? Double.parseDouble(sdfJoint.getAxis().getLimit().getVelocity()) : Double.NaN;
            this.effortLimit = sdfJoint.getAxis().getLimit().getEffort() != null ? Double.parseDouble(sdfJoint.getAxis().getLimit().getEffort()) : Double.NaN;
        } else {
            this.hasLimits = false;
            this.upperLimit = Double.POSITIVE_INFINITY;
            this.lowerLimit = Double.NEGATIVE_INFINITY;
            this.velocityLimit = Double.NaN;
            this.effortLimit = Double.NaN;
        }
        if (sdfJoint.getAxis().getDynamics() != null) {
            if (sdfJoint.getAxis().getDynamics().getFriction() != null) {
                this.friction = Double.parseDouble(sdfJoint.getAxis().getDynamics().getFriction());
            }
            if (sdfJoint.getAxis().getDynamics().getDamping() != null) {
                this.damping = Double.parseDouble(sdfJoint.getAxis().getDynamics().getDamping());
            }
        }
        this.transformFromChildLink = ModelFileLoaderConversionsHelper.poseToTransform(sdfJoint.getPose());
        if (parent == null || child == null) {
            throw new IOException("Cannot make joint with null parent or child links, joint name is " + sdfJoint.getName());
        }
        this.parentLinkHolder = parent;
        this.childLinkHolder = child;
        parent.addChild(this);
        child.setJoint(this);
        this.calculateContactGains();
    }

    public static String createValidVariableName(String name) {
        name = name.trim().replaceAll("[//[//]///]", "");
        return name;
    }

    private void calculateContactGains() {
        double parentKp = this.parentLinkHolder.getContactKp();
        double childKp = this.childLinkHolder.getContactKp();
        if (Math.abs(parentKp) > 0.001 && Math.abs(childKp) > 0.001) {
            this.contactKp = 1.0 / (1.0 / parentKp + 1.0 / childKp);
        } else if (Math.abs(parentKp) > 0.001) {
            this.contactKp = parentKp;
        } else if (Math.abs(childKp) > 0.001) {
            this.contactKp = childKp;
        }
        this.contactKd = this.parentLinkHolder.getContactKd() + this.childLinkHolder.getContactKd();
        this.maxVel = Math.min(this.parentLinkHolder.getContactMaxVel(), this.childLinkHolder.getContactMaxVel());
    }

    public void calculateTransformToParentJoint() {
        RigidBodyTransform parentLinkToParentJoint;
        RigidBodyTransform modelToParentLink = this.getParentLinkHolder().getTransformFromModelReferenceFrame();
        RigidBodyTransform modelToChildLink = this.getChildLinkHolder().getTransformFromModelReferenceFrame();
        RigidBodyTransform rotationTransform = new RigidBodyTransform();
        SDFJointHolder parentJoint = this.parentLinkHolder.getJoint();
        if (parentJoint != null) {
            rotationTransform.getRotation().set((RotationMatrixReadOnly)parentJoint.getLinkRotation());
            parentLinkToParentJoint = parentJoint.getTransformFromChildLink();
        } else {
            parentLinkToParentJoint = new RigidBodyTransform();
        }
        RigidBodyTransform modelToParentJoint = new RigidBodyTransform();
        RigidBodyTransform modelToChildJoint = new RigidBodyTransform();
        modelToParentJoint.set(modelToParentLink);
        modelToParentJoint.multiply((RigidBodyTransformReadOnly)parentLinkToParentJoint);
        this.linkRotation.set((RotationMatrixReadOnly)modelToChildLink.getRotation());
        modelToChildJoint.set(modelToChildLink);
        modelToChildJoint.multiply((RigidBodyTransformReadOnly)this.transformFromChildLink);
        RigidBodyTransform parentJointToModel = new RigidBodyTransform();
        parentJointToModel.setAndInvert((RigidBodyTransformReadOnly)modelToParentJoint);
        RigidBodyTransform parentJointToChildJoint = new RigidBodyTransform();
        parentJointToChildJoint.set(parentJointToModel);
        parentJointToChildJoint.multiply((RigidBodyTransformReadOnly)modelToChildJoint);
        this.transformToParentJoint = parentJointToChildJoint;
        this.offsetFromParentJoint.set((Tuple3DReadOnly)parentJointToChildJoint.getTranslation());
        rotationTransform.transform((Vector3DBasics)this.offsetFromParentJoint);
        this.linkRotation.transform((Tuple3DReadOnly)this.axisInModelFrame, (Tuple3DBasics)this.axisInParentFrame);
        RigidBodyTransform transformFromParentJoint = new RigidBodyTransform((RigidBodyTransformReadOnly)modelToChildJoint);
        transformFromParentJoint.transform((Vector3DReadOnly)this.axisInParentFrame, (Vector3DBasics)this.axisInJointFrame);
    }

    public String getName() {
        return this.name;
    }

    public SDFJointType getType() {
        return this.type;
    }

    public Vector3D getAxisInModelFrame() {
        return this.axisInModelFrame;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public boolean hasLimits() {
        return this.hasLimits;
    }

    public RigidBodyTransform getTransformFromChildLink() {
        return this.transformFromChildLink;
    }

    public SDFLinkHolder getParentLinkHolder() {
        return this.parentLinkHolder;
    }

    public SDFLinkHolder getChildLinkHolder() {
        return this.childLinkHolder;
    }

    public RigidBodyTransform getTransformToParentJoint() {
        return this.transformToParentJoint;
    }

    public double getContactKp() {
        return this.contactKp;
    }

    public double getContactKd() {
        return this.contactKd;
    }

    public double getMaxVel() {
        return this.maxVel;
    }

    public String toString() {
        return this.name;
    }

    public double getDamping() {
        return this.damping;
    }

    public double getFriction() {
        return this.friction;
    }

    public double getEffortLimit() {
        return this.effortLimit;
    }

    public double getVelocityLimit() {
        return this.velocityLimit;
    }

    public RotationMatrix getLinkRotation() {
        return this.linkRotation;
    }

    public Vector3D getOffsetFromParentJoint() {
        return this.offsetFromParentJoint;
    }

    public Vector3D getAxisInParentFrame() {
        return this.axisInParentFrame;
    }

    public Vector3D getAxisInJointFrame() {
        return this.axisInJointFrame;
    }

    public ArrayList<SDFForceSensor> getForceSensors() {
        return this.forceSensors;
    }

    public void addForceSensor(SDFForceSensor forceSensor) {
        this.forceSensors.add(forceSensor);
    }

    public ArrayList<SDFContactSensor> getContactSensors() {
        return this.contactSensors;
    }

    public void addContactSensor(SDFContactSensor contactSensor) {
        this.contactSensors.add(contactSensor);
    }

    public void setLimits(double lowerLimit, double upperLimit) {
        if (upperLimit > lowerLimit) {
            this.hasLimits = Double.isFinite(lowerLimit) && Double.isFinite(upperLimit);
            this.upperLimit = upperLimit;
            this.lowerLimit = lowerLimit;
        } else {
            this.hasLimits = false;
            this.upperLimit = Double.POSITIVE_INFINITY;
            this.lowerLimit = Double.NEGATIVE_INFINITY;
            LogTools.debug((String)(this.getName() + " has invalid joint limits.  LowerLimit = " + lowerLimit + ", UpperLimit = " + upperLimit + ".  Using LowerLimit = " + lowerLimit + ", UpperLimit = " + upperLimit + " instead."));
        }
    }

    public void setEffortLimit(double effortLimit) {
        this.effortLimit = effortLimit;
    }
}

