/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders.SdfLoader;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import javax.imageio.ImageIO;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.modelFileLoaders.ModelFileLoaderConversionsHelper;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFGeometry;

public class SDFHeightMap
implements HeightMap {
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    double zOffset;
    private BoundingBox3D boundingBox;
    double scale;
    int width;
    int height;
    byte[] data;
    private final Vector3D offset;

    public SDFHeightMap(String resourceId, SDFGeometry.HeightMap heightMap) {
        Vector3D size = ModelFileLoaderConversionsHelper.stringToVector3d(heightMap.getSize());
        this.offset = ModelFileLoaderConversionsHelper.stringToVector3d(heightMap.getPos());
        try {
            BufferedImage img = ImageIO.read(this.getClass().getClassLoader().getResourceAsStream(resourceId));
            BufferedImage convertedImg = new BufferedImage(img.getWidth(), img.getHeight(), 10);
            convertedImg.getGraphics().drawImage(img, 0, 0, img.getWidth(), img.getHeight(), 0, img.getHeight(), img.getWidth(), 0, null);
            this.data = ((DataBufferByte)convertedImg.getData().getDataBuffer()).getData();
            this.width = img.getWidth();
            this.height = img.getHeight();
            this.xMin = -size.getX() / 2.0;
            this.xMax = size.getX() / 2.0;
            this.yMin = -size.getY() / 2.0;
            this.yMax = size.getY() / 2.0;
            this.scale = size.getZ() / 255.0;
            double zMin = Double.NEGATIVE_INFINITY;
            double zMax = Double.POSITIVE_INFINITY;
            this.boundingBox = new BoundingBox3D(this.xMin, this.yMin, zMin, this.xMax, this.yMax, zMax);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double heightAt(double x, double y, double z) {
        int yPoint;
        double xFactor = (x - this.xMin) / (this.xMax - this.xMin);
        double yFactor = (y - this.yMin) / (this.yMax - this.yMin);
        int xPoint = (int)Math.round(xFactor * (double)this.width);
        int index = xPoint + (yPoint = (int)Math.round(yFactor * (double)this.height)) * this.width;
        if (index >= this.data.length) {
            return 0.0;
        }
        return (double)(this.data[index] & 0xFF) * this.scale;
    }

    public Vector3D getOffset() {
        return this.offset;
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

