/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders.SdfLoader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import us.ihmc.modelFileLoaders.SdfLoader.GeneralizedSDFRobotModel;
import us.ihmc.modelFileLoaders.SdfLoader.SDFContactSensor;
import us.ihmc.modelFileLoaders.SdfLoader.SDFDescriptionMutator;
import us.ihmc.modelFileLoaders.SdfLoader.SDFForceSensor;
import us.ihmc.modelFileLoaders.SdfLoader.SDFJointHolder;
import us.ihmc.modelFileLoaders.SdfLoader.SDFLinkHolder;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFSensor;

public class SDFDescriptionMutatorList
implements SDFDescriptionMutator {
    private final List<SDFDescriptionMutator> mutators = new ArrayList<SDFDescriptionMutator>();

    public SDFDescriptionMutatorList() {
    }

    public SDFDescriptionMutatorList(SDFDescriptionMutator ... mutators) {
        this.mutators.addAll(Arrays.asList(mutators));
    }

    public SDFDescriptionMutatorList(Collection<? extends SDFDescriptionMutator> mutators) {
        this.mutators.addAll(mutators);
    }

    public void addMutator(SDFDescriptionMutator mutator) {
        this.mutators.add(mutator);
    }

    public void removeMutator(SDFDescriptionMutator mutator) {
        this.mutators.remove(mutator);
    }

    @Override
    public void mutateContactSensorForModel(GeneralizedSDFRobotModel model, SDFContactSensor contactSensor) {
        this.mutators.forEach(mutator -> mutator.mutateContactSensorForModel(model, contactSensor));
    }

    @Override
    public void mutateForceSensorForModel(GeneralizedSDFRobotModel model, SDFForceSensor forceSensor) {
        this.mutators.forEach(mutator -> mutator.mutateForceSensorForModel(model, forceSensor));
    }

    @Override
    public void mutateJointForModel(GeneralizedSDFRobotModel model, SDFJointHolder jointHolder) {
        this.mutators.forEach(mutator -> mutator.mutateJointForModel(model, jointHolder));
    }

    @Override
    public void mutateLinkForModel(GeneralizedSDFRobotModel model, SDFLinkHolder linkHolder) {
        this.mutators.forEach(mutator -> mutator.mutateLinkForModel(model, linkHolder));
    }

    @Override
    public void mutateModelWithAdditions(GeneralizedSDFRobotModel model) {
        this.mutators.forEach(mutator -> mutator.mutateModelWithAdditions(model));
    }

    @Override
    public void mutateSensorForModel(GeneralizedSDFRobotModel model, SDFSensor sensor) {
        this.mutators.forEach(mutator -> mutator.mutateSensorForModel(model, sensor));
    }
}

