/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders.SdfLoader;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.math3.util.Precision;
import us.ihmc.commons.PrintTools;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.modelFileLoaders.ModelFileLoaderConversionsHelper;
import us.ihmc.modelFileLoaders.SdfLoader.GeneralizedSDFRobotModel;
import us.ihmc.modelFileLoaders.SdfLoader.JaxbSDFLoader;
import us.ihmc.modelFileLoaders.SdfLoader.SDFCollisionMeshDescription;
import us.ihmc.modelFileLoaders.SdfLoader.SDFDescriptionMutator;
import us.ihmc.modelFileLoaders.SdfLoader.SDFForceSensor;
import us.ihmc.modelFileLoaders.SdfLoader.SDFGraphics3DObject;
import us.ihmc.modelFileLoaders.SdfLoader.SDFJointHolder;
import us.ihmc.modelFileLoaders.SdfLoader.SDFLinkHolder;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFSensor;
import us.ihmc.robotics.lidar.SimulatedLIDARSensorLimitationParameters;
import us.ihmc.robotics.lidar.SimulatedLIDARSensorNoiseParameters;
import us.ihmc.robotics.lidar.SimulatedLIDARSensorUpdateParameters;
import us.ihmc.robotics.partNames.ContactPointDefinitionHolder;
import us.ihmc.robotics.partNames.JointNameMap;
import us.ihmc.robotics.robotDescription.CameraSensorDescription;
import us.ihmc.robotics.robotDescription.CollisionMeshDescription;
import us.ihmc.robotics.robotDescription.ExternalForcePointDescription;
import us.ihmc.robotics.robotDescription.FloatingJointDescription;
import us.ihmc.robotics.robotDescription.ForceSensorDescription;
import us.ihmc.robotics.robotDescription.GroundContactPointDescription;
import us.ihmc.robotics.robotDescription.IMUSensorDescription;
import us.ihmc.robotics.robotDescription.InertiaTools;
import us.ihmc.robotics.robotDescription.JointDescription;
import us.ihmc.robotics.robotDescription.LidarSensorDescription;
import us.ihmc.robotics.robotDescription.LinkDescription;
import us.ihmc.robotics.robotDescription.LinkGraphicsDescription;
import us.ihmc.robotics.robotDescription.PinJointDescription;
import us.ihmc.robotics.robotDescription.RobotDescription;
import us.ihmc.robotics.robotDescription.SliderJointDescription;

public class RobotDescriptionFromSDFLoader {
    private static final boolean SHOW_CONTACT_POINTS = true;
    private static final boolean SHOW_COM_REFERENCE_FRAMES = false;
    private static final boolean SHOW_INERTIA_ELLIPSOIDS = false;
    private static final boolean SHOW_SENSOR_REFERENCE_FRAMES = false;
    private static final boolean DEBUG = false;
    private List<String> resourceDirectories;
    private LinkedHashMap<String, JointDescription> jointDescriptions = new LinkedHashMap();
    private boolean useShapeCollision = false;
    private ClassLoader resourceClassLoader;

    public RobotDescription loadRobotDescriptionFromSDF(GeneralizedSDFRobotModel generalizedSDFRobotModel, JointNameMap jointNameMap, boolean useShapeCollision) {
        this.useShapeCollision = useShapeCollision;
        return this.loadRobotDescriptionFromSDF(generalizedSDFRobotModel, jointNameMap, null, false);
    }

    public RobotDescription loadRobotDescriptionFromSDF(String modelName, InputStream inputStream, List<String> resourceDirectories, SDFDescriptionMutator mutator, JointNameMap jointNameMap, ContactPointDefinitionHolder contactPointHolder, boolean useCollisionMeshes) {
        GeneralizedSDFRobotModel generalizedSDFRobotModel = RobotDescriptionFromSDFLoader.loadSDFFile(modelName, inputStream, resourceDirectories, mutator);
        return this.loadRobotDescriptionFromSDF(generalizedSDFRobotModel, jointNameMap, contactPointHolder, useCollisionMeshes);
    }

    public RobotDescription loadRobotDescriptionFromSDF(GeneralizedSDFRobotModel generalizedSDFRobotModel, JointNameMap jointNameMap, ContactPointDefinitionHolder contactPointHolder, boolean useCollisionMeshes) {
        return this.loadRobotDescriptionFromSDF(generalizedSDFRobotModel, jointNameMap, contactPointHolder, useCollisionMeshes, Double.NaN);
    }

    public RobotDescription loadRobotDescriptionFromSDF(GeneralizedSDFRobotModel generalizedSDFRobotModel, JointNameMap jointNameMap, ContactPointDefinitionHolder contactPointHolder, boolean useCollisionMeshes, double transparency) {
        this.resourceDirectories = generalizedSDFRobotModel.getResourceDirectories();
        this.resourceClassLoader = generalizedSDFRobotModel.getResourceClassLoader();
        RobotDescription robotDescription = this.loadModelFromSDF(generalizedSDFRobotModel, jointNameMap, useCollisionMeshes, transparency);
        if (jointNameMap != null && !Precision.equals((double)jointNameMap.getModelScale(), (double)1.0, (int)1)) {
            System.out.println("Scaling " + jointNameMap.getModelName() + " with factor " + jointNameMap.getModelScale() + ", mass scale power " + jointNameMap.getMassScalePower());
            robotDescription.scale(jointNameMap.getModelScale(), jointNameMap.getMassScalePower(), Arrays.asList(jointNameMap.getHighInertiaForStableSimulationJoints()));
        }
        if (contactPointHolder != null) {
            this.addGroundContactPoints(contactPointHolder);
        }
        return robotDescription;
    }

    private void addGroundContactPoints(ContactPointDefinitionHolder contactPointHolder) {
        LinkedHashMap<String, Integer> counters = new LinkedHashMap<String, Integer>();
        for (ImmutablePair jointContactPoint : contactPointHolder.getJointNameGroundContactPointMap()) {
            String jointName = (String)jointContactPoint.getLeft();
            int count = counters.get(jointName) == null ? 0 : (Integer)counters.get(jointName);
            Vector3D gcOffset = (Vector3D)jointContactPoint.getRight();
            GroundContactPointDescription groundContactPoint = new GroundContactPointDescription("gc_" + ModelFileLoaderConversionsHelper.sanitizeJointName(jointName) + "_" + count++, gcOffset, contactPointHolder.getGroupIdentifier(jointContactPoint));
            ExternalForcePointDescription externalForcePoint = new ExternalForcePointDescription("ef_" + ModelFileLoaderConversionsHelper.sanitizeJointName(jointName) + "_" + count++, (Tuple3DReadOnly)gcOffset);
            JointDescription jointDescription = this.jointDescriptions.get(jointName);
            jointDescription.addGroundContactPoint(groundContactPoint);
            jointDescription.addExternalForcePoint(externalForcePoint);
            counters.put(jointName, count);
            if (jointDescription.getLink().getLinkGraphics() == null) {
                jointDescription.getLink().setLinkGraphics(new LinkGraphicsDescription());
            }
            LinkGraphicsDescription graphics = jointDescription.getLink().getLinkGraphics();
            graphics.identity();
            graphics.translate((Tuple3DReadOnly)jointContactPoint.getRight());
            double radius = 0.01;
            graphics.addSphere(radius, YoAppearance.Orange());
        }
    }

    private RobotDescription loadModelFromSDF(GeneralizedSDFRobotModel generalizedSDFRobotModel, JointNameMap jointNameMap, boolean useCollisionMeshes, double transparency) {
        String name = generalizedSDFRobotModel.getName();
        RobotDescription robotDescription = new RobotDescription(name);
        ArrayList<SDFLinkHolder> rootLinks = generalizedSDFRobotModel.getRootLinks();
        if (rootLinks.size() > 1) {
            throw new RuntimeException("Can only accomodate one root link for now. Root links: " + rootLinks);
        }
        SDFLinkHolder rootLink = rootLinks.get(0);
        Vector3D offset = new Vector3D();
        Quaternion orientation = new Quaternion();
        generalizedSDFRobotModel.getTransformToRoot().get((Orientation3DBasics)orientation, (Tuple3DBasics)offset);
        FloatingJointDescription rootJointDescription = new FloatingJointDescription(rootLink.getName());
        if (!Double.isNaN(transparency)) {
            rootLink.getVisuals().forEach(visual -> visual.setTransparency(Double.toString(transparency)));
        }
        LinkDescription rootLinkDescription = this.createLinkDescription(rootLink, new RigidBodyTransform(), useCollisionMeshes);
        rootJointDescription.setLink(rootLinkDescription);
        this.addSensors((JointDescription)rootJointDescription, rootLink);
        robotDescription.addRootJoint((JointDescription)rootJointDescription);
        this.jointDescriptions.put(rootJointDescription.getName(), (JointDescription)rootJointDescription);
        for (SDFJointHolder child : rootLink.getChildren()) {
            HashSet<String> lastSimulatedJoints = jointNameMap != null ? jointNameMap.getLastSimulatedJoints() : new HashSet<String>();
            this.addJointsRecursively(child, (JointDescription)rootJointDescription, useCollisionMeshes, lastSimulatedJoints, false, jointNameMap, transparency);
        }
        for (SDFJointHolder child : rootLink.getChildren()) {
            this.addForceSensorsIncludingDescendants(child, jointNameMap);
        }
        return robotDescription;
    }

    private LinkDescription createLinkDescription(SDFLinkHolder link, RigidBodyTransform rotationTransform, boolean useCollisionMeshes) {
        LinkDescription scsLink = new LinkDescription(link.getName());
        if (useCollisionMeshes) {
            SDFCollisionMeshDescription collisionMeshDescription = new SDFCollisionMeshDescription(link.getCollisions(), rotationTransform);
            scsLink.addCollisionMesh((CollisionMeshDescription)collisionMeshDescription);
        }
        if (link.getVisuals() != null) {
            SDFGraphics3DObject linkGraphicsDescription;
            try {
                linkGraphicsDescription = new SDFGraphics3DObject(link.getVisuals(), this.resourceDirectories, this.resourceClassLoader, rotationTransform);
            }
            catch (Throwable e) {
                PrintTools.warn((Object)this, (String)e.getMessage());
                PrintTools.warn((Object)this, (String)("Could not load visuals for link " + link.getName() + "! Using an empty LinkGraphicsDescription."));
                linkGraphicsDescription = new LinkGraphicsDescription();
            }
            scsLink.setLinkGraphics((LinkGraphicsDescription)linkGraphicsDescription);
        }
        double mass = link.getMass();
        Matrix3D inertia = InertiaTools.rotate((RigidBodyTransform)rotationTransform, (Matrix3D)link.getInertia());
        Vector3D CoMOffset = new Vector3D((Tuple3DReadOnly)link.getCoMOffset());
        if (link.getJoint() != null && this.isJointInNeedOfReducedGains(link.getJoint())) {
            inertia.scale(100.0);
        }
        rotationTransform.transform((Vector3DBasics)CoMOffset);
        scsLink.setCenterOfMassOffset((Tuple3DReadOnly)CoMOffset);
        scsLink.setMass(mass);
        scsLink.setMomentOfInertia((Matrix3DReadOnly)inertia);
        if (link.getVisuals() != null) {
            // empty if block
        }
        return scsLink;
    }

    protected void addJointsRecursively(SDFJointHolder joint, JointDescription scsParentJoint, boolean useCollisionMeshes, Set<String> lastSimulatedJoints, boolean doNotSimulateJoint, JointNameMap jointNameMap) {
        this.addJointsRecursively(joint, scsParentJoint, useCollisionMeshes, lastSimulatedJoints, doNotSimulateJoint, jointNameMap, Double.NaN);
    }

    protected void addJointsRecursively(SDFJointHolder joint, JointDescription scsParentJoint, boolean useCollisionMeshes, Set<String> lastSimulatedJoints, boolean doNotSimulateJoint, JointNameMap jointNameMap, double transparency) {
        SliderJointDescription scsJoint;
        Vector3D jointAxis = new Vector3D((Tuple3DReadOnly)joint.getAxisInModelFrame());
        Vector3D offset = new Vector3D((Tuple3DReadOnly)joint.getOffsetFromParentJoint());
        RigidBodyTransform visualTransform = new RigidBodyTransform();
        visualTransform.getRotation().set((RotationMatrixReadOnly)joint.getLinkRotation());
        String sanitizedJointName = ModelFileLoaderConversionsHelper.sanitizeJointName(joint.getName());
        switch (joint.getType()) {
            case REVOLUTE: {
                PinJointDescription pinJoint = new PinJointDescription(sanitizedJointName, (Tuple3DReadOnly)offset, (Vector3DReadOnly)jointAxis);
                if (joint.hasLimits() && jointNameMap != null) {
                    if (this.isJointInNeedOfReducedGains(joint)) {
                        pinJoint.setLimitStops(joint.getLowerLimit(), joint.getUpperLimit(), 10.0, 2.5);
                    } else {
                        if (joint.getContactKd() == 0.0 && joint.getContactKp() == 0.0) {
                            double kLimit = jointNameMap.getDefaultKLimit();
                            double bLimit = jointNameMap.getDefaultBLimit();
                            pinJoint.setLimitStops(joint.getLowerLimit(), joint.getUpperLimit(), kLimit, bLimit);
                        } else {
                            pinJoint.setLimitStops(joint.getLowerLimit(), joint.getUpperLimit(), 1.0E-4 * joint.getContactKp(), 0.1 * joint.getContactKd());
                        }
                        if (!Double.isNaN(joint.getVelocityLimit()) && joint.getVelocityLimit() >= 0.0) {
                            pinJoint.setVelocityLimits(joint.getVelocityLimit(), 0.0);
                        }
                    }
                }
                pinJoint.setDamping(joint.getDamping());
                pinJoint.setStiction(joint.getFriction());
                if (!this.isJointInNeedOfReducedGains(joint)) {
                    if (!Double.isNaN(joint.getEffortLimit()) && joint.getEffortLimit() >= 0.0) {
                        pinJoint.setEffortLimit(joint.getEffortLimit());
                    }
                    if (!Double.isNaN(joint.getVelocityLimit()) && joint.getVelocityLimit() >= 0.0 && !this.isJointInNeedOfReducedGains(joint)) {
                        pinJoint.setVelocityLimits(joint.getVelocityLimit(), 500.0);
                    }
                }
                scsJoint = pinJoint;
                break;
            }
            case PRISMATIC: {
                SliderJointDescription sliderJoint = new SliderJointDescription(sanitizedJointName, (Tuple3DReadOnly)offset, (Vector3DReadOnly)jointAxis);
                if (joint.hasLimits()) {
                    if (joint.getContactKd() == 0.0 && joint.getContactKp() == 0.0) {
                        sliderJoint.setLimitStops(joint.getLowerLimit(), joint.getUpperLimit(), 100.0, 20.0);
                    } else {
                        sliderJoint.setLimitStops(joint.getLowerLimit(), joint.getUpperLimit(), 1.0E-4 * joint.getContactKp(), joint.getContactKd());
                    }
                }
                sliderJoint.setDamping(joint.getDamping());
                sliderJoint.setStiction(joint.getFriction());
                scsJoint = sliderJoint;
                break;
            }
            default: {
                throw new RuntimeException("Joint type not implemented: " + (Object)((Object)joint.getType()));
            }
        }
        if (doNotSimulateJoint) {
            scsJoint.setIsDynamic(false);
        }
        if (!Double.isNaN(transparency) && joint.getChildLinkHolder().getVisuals() != null) {
            joint.getChildLinkHolder().getVisuals().forEach(visual -> visual.setTransparency(Double.toString(transparency)));
        }
        scsJoint.setLink(this.createLinkDescription(joint.getChildLinkHolder(), visualTransform, useCollisionMeshes));
        scsParentJoint.addJoint((JointDescription)scsJoint);
        this.jointDescriptions.put(scsJoint.getName(), (JointDescription)scsJoint);
        this.addSensors((JointDescription)scsJoint, joint.getChildLinkHolder());
        if (!doNotSimulateJoint && lastSimulatedJoints.contains(joint.getName())) {
            doNotSimulateJoint = true;
        }
        for (SDFJointHolder child : joint.getChildLinkHolder().getChildren()) {
            this.addJointsRecursively(child, (JointDescription)scsJoint, useCollisionMeshes, lastSimulatedJoints, doNotSimulateJoint, jointNameMap, transparency);
        }
    }

    private boolean isJointInNeedOfReducedGains(SDFJointHolder pinJoint) {
        String jointName = pinJoint.getName();
        return jointName.contains("f0") || jointName.contains("f1") || jointName.contains("f2") || jointName.contains("f3") || jointName.contains("palm") || jointName.contains("finger");
    }

    private static GeneralizedSDFRobotModel loadSDFFile(String modelName, InputStream inputStream, List<String> resourceDirectories, SDFDescriptionMutator mutator) {
        GeneralizedSDFRobotModel generalizedSDFRobotModel = null;
        try {
            JaxbSDFLoader loader = new JaxbSDFLoader(inputStream, resourceDirectories, mutator);
            generalizedSDFRobotModel = loader.getGeneralizedSDFRobotModel(modelName);
        }
        catch (FileNotFoundException | JAXBException e) {
            throw new RuntimeException("Cannot load model", e);
        }
        return generalizedSDFRobotModel;
    }

    private void showCordinateSystem(JointDescription scsJoint, RigidBodyTransform offsetFromLink) {
    }

    private void addSensors(JointDescription scsJoint, SDFLinkHolder child) {
        if (child.getSensors() != null) {
            for (SDFSensor sensor : child.getSensors()) {
                switch (sensor.getType()) {
                    case "camera": 
                    case "multicamera": 
                    case "depth": {
                        this.addCameraMounts(sensor, scsJoint, child);
                        break;
                    }
                    case "imu": {
                        this.addIMUMounts(sensor, scsJoint, child);
                        break;
                    }
                    case "gpu_ray": 
                    case "ray": {
                        this.addLidarMounts(sensor, scsJoint, child);
                    }
                }
            }
        }
    }

    private void addCameraMounts(SDFSensor sensor, JointDescription scsJoint, SDFLinkHolder child) {
        List<SDFSensor.Camera> cameras = sensor.getCamera();
        if (cameras != null) {
            for (SDFSensor.Camera camera : cameras) {
                RigidBodyTransform linkRotation = new RigidBodyTransform((RigidBodyTransformReadOnly)child.getTransformFromModelReferenceFrame());
                linkRotation.getTranslation().set(0.0, 0.0, 0.0);
                RigidBodyTransform linkToSensor = ModelFileLoaderConversionsHelper.poseToTransform(sensor.getPose());
                RigidBodyTransform sensorToCamera = ModelFileLoaderConversionsHelper.poseToTransform(camera.getPose());
                RigidBodyTransform linkToCamera = new RigidBodyTransform();
                linkToCamera.set(linkRotation);
                linkToCamera.multiply((RigidBodyTransformReadOnly)linkToSensor);
                linkToCamera.multiply((RigidBodyTransformReadOnly)sensorToCamera);
                this.showCordinateSystem(scsJoint, linkToCamera);
                double fieldOfView = Double.parseDouble(camera.getHorizontalFov());
                double clipNear = Double.parseDouble(camera.getClip().getNear());
                double clipFar = Double.parseDouble(camera.getClip().getFar());
                String cameraName = sensor.getName() + "_" + camera.getName();
                CameraSensorDescription mount = new CameraSensorDescription(cameraName, (RigidBodyTransformReadOnly)linkToCamera, fieldOfView, clipNear, clipFar);
                int imageHeight = Integer.parseInt(camera.getImage().getHeight());
                int imageWidth = Integer.parseInt(camera.getImage().getWidth());
                mount.setImageHeight(imageHeight);
                mount.setImageWidth(imageWidth);
                scsJoint.addCameraSensor(mount);
            }
        } else {
            System.err.println("JAXB loader: No camera section defined for camera sensor " + sensor.getName() + ", ignoring sensor.");
        }
    }

    private void addIMUMounts(SDFSensor sdfSensor, JointDescription jointDescription, SDFLinkHolder child) {
        SDFSensor.IMU imu = sdfSensor.getImu();
        if (imu != null) {
            RigidBodyTransform linkRotation = new RigidBodyTransform((RigidBodyTransformReadOnly)child.getTransformFromModelReferenceFrame());
            linkRotation.getTranslation().set(0.0, 0.0, 0.0);
            RigidBodyTransform linkToSensorInZUp = new RigidBodyTransform();
            linkToSensorInZUp.set(linkRotation);
            linkToSensorInZUp.multiply((RigidBodyTransformReadOnly)ModelFileLoaderConversionsHelper.poseToTransform(sdfSensor.getPose()));
            this.showCordinateSystem(jointDescription, linkToSensorInZUp);
            IMUSensorDescription imuMount = new IMUSensorDescription(child.getName() + "_" + sdfSensor.getName(), linkToSensorInZUp);
            SDFSensor.IMU.IMUNoise noise = imu.getNoise();
            if (noise != null) {
                if ("gaussian".equals(noise.getType())) {
                    SDFSensor.IMU.IMUNoise.NoiseParameters accelerationNoise = noise.getAccel();
                    SDFSensor.IMU.IMUNoise.NoiseParameters angularVelocityNoise = noise.getRate();
                    imuMount.setAccelerationNoiseParameters(Double.parseDouble(accelerationNoise.getMean()), Double.parseDouble(accelerationNoise.getStddev()));
                    imuMount.setAccelerationBiasParameters(Double.parseDouble(accelerationNoise.getBias_mean()), Double.parseDouble(accelerationNoise.getBias_stddev()));
                    imuMount.setAngularVelocityNoiseParameters(Double.parseDouble(angularVelocityNoise.getMean()), Double.parseDouble(angularVelocityNoise.getStddev()));
                    imuMount.setAngularVelocityBiasParameters(Double.parseDouble(angularVelocityNoise.getBias_mean()), Double.parseDouble(angularVelocityNoise.getBias_stddev()));
                } else {
                    throw new RuntimeException("Unknown IMU noise model: " + noise.getType());
                }
            }
            jointDescription.addIMUSensor(imuMount);
        } else {
            System.err.println("JAXB loader: No imu section defined for imu sensor " + sdfSensor.getName() + ", ignoring sensor.");
        }
    }

    private void addLidarMounts(SDFSensor sensor, JointDescription scsJoint, SDFLinkHolder child) {
        SDFSensor.Ray sdfRay = sensor.getRay();
        if (sdfRay == null) {
            System.err.println("SDFRobot: lidar not present in ray type sensor " + sensor.getName() + ". Ignoring this sensor.");
        } else {
            SDFSensor.Ray.Range sdfRange = sdfRay.getRange();
            SDFSensor.Ray.Scan sdfScan = sdfRay.getScan();
            double sdfMaxRange = Double.parseDouble(sdfRange.getMax());
            double sdfMinRange = Double.parseDouble(sdfRange.getMin());
            SDFSensor.Ray.Scan.HorizontalScan sdfHorizontalScan = sdfScan.getHorizontal();
            SDFSensor.Ray.Scan.VerticalScan sdfVerticalScan = sdfScan.getVertical();
            double sdfMaxSweepAngle = Double.parseDouble(sdfHorizontalScan.getMaxAngle());
            double sdfMinSweepAngle = Double.parseDouble(sdfHorizontalScan.getMinAngle());
            double sdfMaxHeightAngle = sdfVerticalScan == null ? 0.0 : Double.parseDouble(sdfVerticalScan.getMaxAngle());
            double sdfMinHeightAngle = sdfVerticalScan == null ? 0.0 : Double.parseDouble(sdfVerticalScan.getMinAngle());
            int sdfSamples = Integer.parseInt(sdfHorizontalScan.getSamples()) / 3 * 3;
            int sdfScanHeight = sdfVerticalScan == null ? 1 : Integer.parseInt(sdfVerticalScan.getSamples());
            double sdfRangeResolution = Double.parseDouble(sdfRay.getRange().getResolution());
            boolean sdfAlwaysOn = true;
            double sdfGaussianStdDev = 0.0;
            double sdfGaussianMean = 0.0;
            int sdfUpdateRate = (int)(1000.0 / Double.parseDouble(sensor.getUpdateRate()));
            SDFSensor.Ray.Noise sdfNoise = sdfRay.getNoise();
            if (sdfNoise != null) {
                if ("gaussian".equals(sdfNoise.getType())) {
                    sdfGaussianStdDev = Double.parseDouble(sdfNoise.getStddev());
                    sdfGaussianMean = Double.parseDouble(sdfNoise.getMean());
                } else {
                    System.err.println("Unknown noise model: " + sdfNoise.getType());
                }
            }
            RigidBodyTransform linkRotation = new RigidBodyTransform((RigidBodyTransformReadOnly)child.getTransformFromModelReferenceFrame());
            linkRotation.getTranslation().set(0.0, 0.0, 0.0);
            RigidBodyTransform linkToSensorInZUp = new RigidBodyTransform();
            linkToSensorInZUp.set(linkRotation);
            linkToSensorInZUp.multiply((RigidBodyTransformReadOnly)ModelFileLoaderConversionsHelper.poseToTransform(sensor.getPose()));
            this.showCordinateSystem(scsJoint, linkToSensorInZUp);
            SimulatedLIDARSensorNoiseParameters noiseParameters = new SimulatedLIDARSensorNoiseParameters();
            noiseParameters.setGaussianNoiseStandardDeviation(sdfGaussianStdDev);
            noiseParameters.setGaussianNoiseMean(sdfGaussianMean);
            SimulatedLIDARSensorLimitationParameters limitationParameters = new SimulatedLIDARSensorLimitationParameters();
            limitationParameters.setMaxRange(sdfMaxRange);
            limitationParameters.setMinRange(sdfMinRange);
            limitationParameters.setQuantization(sdfRangeResolution);
            SimulatedLIDARSensorUpdateParameters updateParameters = new SimulatedLIDARSensorUpdateParameters();
            updateParameters.setAlwaysOn(sdfAlwaysOn);
            updateParameters.setUpdatePeriodInMillis(sdfUpdateRate);
            LidarSensorDescription lidarMount = new LidarSensorDescription(sensor.getName(), (RigidBodyTransformReadOnly)linkToSensorInZUp);
            lidarMount.setPointsPerSweep(sdfSamples);
            lidarMount.setScanHeight(sdfScanHeight);
            lidarMount.setSweepYawLimits(sdfMinSweepAngle, sdfMaxSweepAngle);
            lidarMount.setHeightPitchLimits(sdfMinHeightAngle, sdfMaxHeightAngle);
            lidarMount.setRangeLimits(sdfMinRange, sdfMaxRange);
            scsJoint.addLidarSensor(lidarMount);
        }
    }

    private void addForceSensorsIncludingDescendants(SDFJointHolder joint, JointNameMap jointNameMap) {
        this.addForceSensor(joint, jointNameMap);
        for (SDFJointHolder child : joint.getChildLinkHolder().getChildren()) {
            this.addForceSensorsIncludingDescendants(child, jointNameMap);
        }
    }

    private void addForceSensor(SDFJointHolder joint, JointNameMap jointNameMap) {
        if (joint.getForceSensors().size() > 0) {
            String[] jointNamesBeforeFeet = jointNameMap.getJointNamesBeforeFeet();
            String jointName = joint.getName();
            String sanitizedJointName = ModelFileLoaderConversionsHelper.sanitizeJointName(jointName);
            JointDescription scsJoint = this.jointDescriptions.get(sanitizedJointName);
            boolean jointIsParentOfFoot = false;
            for (int i = 0; i < jointNamesBeforeFeet.length; ++i) {
                if (!jointName.equals(jointNamesBeforeFeet[i])) continue;
                jointIsParentOfFoot = true;
            }
            for (SDFForceSensor forceSensor : joint.getForceSensors()) {
                ForceSensorDescription forceSensorDescription = new ForceSensorDescription(forceSensor.getName(), forceSensor.getTransform());
                forceSensorDescription.setUseGroundContactPoints(jointIsParentOfFoot);
                forceSensorDescription.setUseShapeCollision(this.useShapeCollision);
                scsJoint.addForceSensor(forceSensorDescription);
            }
        }
    }
}

