/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders.SdfLoader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.modelFileLoaders.SdfLoader.GeneralizedSDFRobotModel;
import us.ihmc.modelFileLoaders.SdfLoader.RobotDescriptionFromSDFLoader;
import us.ihmc.modelFileLoaders.SdfLoader.SDFDescriptionMutator;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFModel;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFRoot;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFWorld;
import us.ihmc.robotics.partNames.ContactPointDefinitionHolder;
import us.ihmc.robotics.partNames.JointNameMap;
import us.ihmc.robotics.robotDescription.RobotDescription;
import us.ihmc.robotics.sensors.ContactSensorType;

public class JaxbSDFLoader {
    private final LinkedHashMap<String, GeneralizedSDFRobotModel> generalizedSDFRobotModels = new LinkedHashMap();
    private final ArrayList<SDFWorld.Road> roads = new ArrayList();

    public JaxbSDFLoader(File file, List<String> resourceDirectories) throws JAXBException, FileNotFoundException {
        this(new FileInputStream(file), resourceDirectories);
    }

    public JaxbSDFLoader(InputStream inputStream, List<String> resourceDirectories) throws JAXBException, FileNotFoundException {
        this(inputStream, resourceDirectories, (SDFDescriptionMutator)null);
    }

    public JaxbSDFLoader(InputStream inputStream, List<String> resourceDirectories, ClassLoader resourceClassLoader) throws JAXBException, FileNotFoundException {
        this(inputStream, resourceDirectories, resourceClassLoader, null);
    }

    public JaxbSDFLoader(File file, String resourceDirectory, SDFDescriptionMutator mutator) throws JAXBException, FileNotFoundException {
        this((InputStream)new FileInputStream(file), Arrays.asList(resourceDirectory), mutator);
    }

    public JaxbSDFLoader(InputStream inputStream, String[] resourceDirectories, SDFDescriptionMutator mutator) throws JAXBException, FileNotFoundException {
        this(inputStream, Arrays.asList(resourceDirectories), mutator);
    }

    public JaxbSDFLoader(InputStream inputStream, List<String> resourceDirectories, SDFDescriptionMutator mutator) throws JAXBException, FileNotFoundException {
        this(inputStream, resourceDirectories, null, mutator);
    }

    public JaxbSDFLoader(InputStream inputStream, List<String> resourceDirectories, ClassLoader resourceClassLoader, SDFDescriptionMutator mutator) throws JAXBException, FileNotFoundException {
        List<SDFModel> models;
        if (inputStream == null) {
            throw new RuntimeException("inputStream is null");
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{SDFRoot.class});
        Unmarshaller um = context.createUnmarshaller();
        SDFRoot sdfRoot = (SDFRoot)um.unmarshal(inputStream);
        if (sdfRoot.getWorld() != null) {
            models = sdfRoot.getWorld().getModels();
            if (sdfRoot.getWorld().getRoads() != null) {
                this.roads.addAll(sdfRoot.getWorld().getRoads());
            }
        } else {
            models = sdfRoot.getModels();
        }
        if (resourceClassLoader == null) {
            resourceClassLoader = this.getClass().getClassLoader();
        }
        for (SDFModel modelInstance : models) {
            String modelName = modelInstance.getName();
            this.generalizedSDFRobotModels.put(modelName, new GeneralizedSDFRobotModel(modelName, modelInstance, resourceDirectories, resourceClassLoader, mutator));
        }
    }

    public JaxbSDFLoader(File file, List<String> resourceDirectories, SDFDescriptionMutator mutator) throws FileNotFoundException, JAXBException {
        this(new FileInputStream(file), resourceDirectories, null, mutator);
    }

    public Collection<GeneralizedSDFRobotModel> getGeneralizedSDFRobotModels() {
        return this.generalizedSDFRobotModels.values();
    }

    public List<SDFWorld.Road> getRoads() {
        return this.roads;
    }

    private void checkModelName(String name) {
        if (!this.generalizedSDFRobotModels.containsKey(name)) {
            throw new RuntimeException(name + " not found");
        }
    }

    public GeneralizedSDFRobotModel getGeneralizedSDFRobotModel(String name) {
        this.checkModelName(name);
        return this.generalizedSDFRobotModels.get(name);
    }

    public void addForceSensor(JointNameMap jointMap, String sensorName, String parentJointName, RigidBodyTransform transformToParentJoint) {
        this.generalizedSDFRobotModels.get(jointMap.getModelName()).addForceSensor(sensorName, parentJointName, transformToParentJoint);
    }

    public void addContactSensor(JointNameMap jointMap, String sensorName, String parentJointName, ContactSensorType type) {
        this.generalizedSDFRobotModels.get(jointMap.getModelName()).addContactSensor(sensorName, parentJointName, type);
    }

    public RobotDescription createRobotDescription(JointNameMap jointNameMap, ContactPointDefinitionHolder contactDefinition) {
        boolean useCollisionMeshes = false;
        return this.createRobotDescription(jointNameMap, contactDefinition, useCollisionMeshes);
    }

    public RobotDescription createRobotDescription(JointNameMap jointNameMap, ContactPointDefinitionHolder contactDefinition, boolean useCollisionMeshes) {
        if (jointNameMap != null) {
            String modelName = jointNameMap.getModelName();
            this.checkModelName(modelName);
            RobotDescriptionFromSDFLoader loader = new RobotDescriptionFromSDFLoader();
            RobotDescription description = loader.loadRobotDescriptionFromSDF(this.generalizedSDFRobotModels.get(modelName), jointNameMap, contactDefinition, useCollisionMeshes);
            return description;
        }
        throw new RuntimeException("Cannot make a fullrobotmodel without a jointNameMap");
    }
}

