/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.modelFileLoaders.SdfLoader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.modelFileLoaders.ModelFileLoaderConversionsHelper;
import us.ihmc.modelFileLoaders.SdfLoader.SDFContactSensor;
import us.ihmc.modelFileLoaders.SdfLoader.SDFDescriptionMutator;
import us.ihmc.modelFileLoaders.SdfLoader.SDFForceSensor;
import us.ihmc.modelFileLoaders.SdfLoader.SDFGraphics3DObject;
import us.ihmc.modelFileLoaders.SdfLoader.SDFJointHolder;
import us.ihmc.modelFileLoaders.SdfLoader.SDFLinkHolder;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFJoint;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFLink;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFModel;
import us.ihmc.modelFileLoaders.SdfLoader.xmlDescription.SDFSensor;
import us.ihmc.robotics.robotDescription.CollisionMeshDescription;
import us.ihmc.robotics.robotDescription.GraphicsObjectsHolder;
import us.ihmc.robotics.sensors.ContactSensorType;

public class GeneralizedSDFRobotModel
implements GraphicsObjectsHolder {
    private final String name;
    private final List<String> resourceDirectories;
    private final ClassLoader resourceClassLoader;
    private final SDFDescriptionMutator descriptionMutator;
    private final ArrayList<SDFLinkHolder> rootLinks = new ArrayList();
    private final RigidBodyTransform transformToRoot;
    private final LinkedHashMap<String, SDFJointHolder> joints = new LinkedHashMap();
    private final LinkedHashMap<String, SDFLinkHolder> links = new LinkedHashMap();

    public GeneralizedSDFRobotModel(String name, SDFModel model, List<String> resourceDirectories, ClassLoader resourceClassLoader) {
        this(name, model, resourceDirectories, resourceClassLoader, null);
    }

    public GeneralizedSDFRobotModel(String name, SDFModel model, List<String> resourceDirectories, ClassLoader resourceClassLoader, SDFDescriptionMutator descriptionMutator) {
        this.name = name;
        this.resourceDirectories = resourceDirectories;
        this.resourceClassLoader = resourceClassLoader;
        this.descriptionMutator = descriptionMutator;
        List<SDFLink> sdfLinks = model.getLinks();
        List<SDFJoint> sdfJoints = model.getJoints();
        for (SDFLink sDFLink : sdfLinks) {
            SDFLinkHolder linkHolder = new SDFLinkHolder(sDFLink);
            if (this.descriptionMutator != null) {
                this.descriptionMutator.mutateLinkForModel(this, linkHolder);
                List<SDFSensor> sensors = linkHolder.getSensors();
                if (sensors != null) {
                    for (SDFSensor sdfSensor : sensors) {
                        this.descriptionMutator.mutateSensorForModel(this, sdfSensor);
                    }
                }
            }
            this.links.put(ModelFileLoaderConversionsHelper.sanitizeJointName(sDFLink.getName()), linkHolder);
        }
        if (sdfJoints != null) {
            for (SDFJoint sDFJoint : sdfJoints) {
                String parent = ModelFileLoaderConversionsHelper.sanitizeJointName(sDFJoint.getParent());
                String child = ModelFileLoaderConversionsHelper.sanitizeJointName(sDFJoint.getChild());
                try {
                    SDFJointHolder jointHolder = new SDFJointHolder(sDFJoint, this.links.get(parent), this.links.get(child));
                    if (this.descriptionMutator != null) {
                        this.descriptionMutator.mutateJointForModel(this, jointHolder);
                        for (SDFContactSensor sdfContactSensor : jointHolder.getContactSensors()) {
                            this.descriptionMutator.mutateContactSensorForModel(this, sdfContactSensor);
                        }
                        for (SDFForceSensor sdfForceSensor : jointHolder.getForceSensors()) {
                            this.descriptionMutator.mutateForceSensorForModel(this, sdfForceSensor);
                        }
                    }
                    this.joints.put(ModelFileLoaderConversionsHelper.sanitizeJointName(sDFJoint.getName()), jointHolder);
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }
        if (this.descriptionMutator != null) {
            this.descriptionMutator.mutateModelWithAdditions(this);
        }
        for (Map.Entry entry : this.joints.entrySet()) {
            ((SDFJointHolder)entry.getValue()).calculateTransformToParentJoint();
        }
        for (Map.Entry entry : this.links.entrySet()) {
            ((SDFLinkHolder)entry.getValue()).calculateCoMOffset();
        }
        this.findRootLinks(this.links);
        this.transformToRoot = ModelFileLoaderConversionsHelper.poseToTransform(model.getPose());
    }

    private void findRootLinks(HashMap<String, SDFLinkHolder> links) {
        for (Map.Entry<String, SDFLinkHolder> linkEntry : links.entrySet()) {
            SDFLinkHolder link = linkEntry.getValue();
            if (link.getJoint() != null) continue;
            this.rootLinks.add(link);
        }
    }

    public ArrayList<SDFLinkHolder> getRootLinks() {
        return this.rootLinks;
    }

    public RigidBodyTransform getTransformToRoot() {
        return this.transformToRoot;
    }

    public String getName() {
        return this.name;
    }

    public SDFJointHolder getJointHolder(String name) {
        return this.joints.get(name);
    }

    public List<String> getResourceDirectories() {
        return this.resourceDirectories;
    }

    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    public ArrayList<CollisionMeshDescription> getCollisionObjects(String name) {
        for (SDFLinkHolder linkHolder : this.rootLinks) {
            if (!linkHolder.getName().equals(name)) continue;
            SDFGraphics3DObject sdfGraphics3DObject = new SDFGraphics3DObject(linkHolder.getCollisions(), this.resourceDirectories);
            ArrayList<CollisionMeshDescription> collisionMeshDescriptions = new ArrayList<CollisionMeshDescription>();
            return collisionMeshDescriptions;
        }
        SDFGraphics3DObject sdfGraphics3DObject = new SDFGraphics3DObject(this.joints.get(name).getChildLinkHolder().getCollisions(), this.resourceDirectories);
        CollisionMeshDescription collisionMeshDescription = new CollisionMeshDescription();
        ArrayList<CollisionMeshDescription> collisionMeshDescriptions = new ArrayList<CollisionMeshDescription>();
        return collisionMeshDescriptions;
    }

    public Graphics3DObject getGraphicsObject(String name) {
        for (SDFLinkHolder linkHolder : this.rootLinks) {
            if (!linkHolder.getName().equals(name)) continue;
            return new SDFGraphics3DObject(linkHolder.getVisuals(), this.resourceDirectories);
        }
        SDFJointHolder joint = this.joints.get(name);
        RigidBodyTransform visualTransform = new RigidBodyTransform();
        visualTransform.getRotation().set((RotationMatrixReadOnly)joint.getLinkRotation());
        return new SDFGraphics3DObject(joint.getChildLinkHolder().getVisuals(), this.resourceDirectories, visualTransform);
    }

    public void addForceSensor(String sensorName, String parentJointName, RigidBodyTransform transformToParentJoint) {
        SDFForceSensor sdfForceSensor = new SDFForceSensor(sensorName, transformToParentJoint);
        if (this.joints.get(parentJointName) != null) {
            this.joints.get(parentJointName).addForceSensor(sdfForceSensor);
        }
    }

    public void addContactSensor(String sensorName, String parentJointName, ContactSensorType type) {
        SDFContactSensor sdfContactSensor = new SDFContactSensor(sensorName, parentJointName, type);
        this.joints.get(parentJointName).addContactSensor(sdfContactSensor);
    }

    public SDFDescriptionMutator getSDFDescriptionMutator() {
        return this.descriptionMutator;
    }
}

