/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javadecklink;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import us.ihmc.javadecklink.CaptureHandler;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;

public class Capture {
    public static final String LIBAV_VERSION = "IHMC_JAVA_DECKLINK_LIBAV_VERSION";
    private static boolean loaded = false;
    private static final String[] LIBAV_SUPPORTED_VERSIONS = new String[]{"-desktopvideo10.8.5-avcodec56-swscale3-avformat56-ffmpeg", "-desktopvideo11.2-avcodec57-swscale4-avformat57", "-desktopvideo12.1-avcodec56-swscale3-avformat56-ffmpeg", "-desktopvideo12.1-avcodec58-swscale5-avformat58"};
    private final ReentrantLock lock = new ReentrantLock();
    private final CodecID codec;
    private final CaptureHandler captureHandler;
    private final long captureSettingsPtr;
    private long ptr = 0L;
    private boolean alive = true;
    private String format = null;
    private boolean recordAudio = false;

    private native long getHardwareTime(long var1);

    private native long startCaptureNative(String var1, String var2, int var3, long var4);

    private native long startCaptureNativeWithAudio(String var1, String var2, int var3, long var4);

    private native void stopCaptureNative(long var1);

    private native long createCaptureSettings(int var1);

    private native long setQuality(long var1, int var3);

    private native void setOption(long var1, String var3, String var4);

    public Capture(CaptureHandler captureHandler, CodecID codec) {
        if (!loaded) {
            throw new UnsatisfiedLinkError("[ERROR] Cannot load JavaDecklink library, make sure you have a supported libav version installed. Supported versions are " + Arrays.toString(LIBAV_SUPPORTED_VERSIONS));
        }
        this.codec = codec;
        this.captureHandler = captureHandler;
        this.captureSettingsPtr = this.createCaptureSettings(codec.id);
    }

    public void setRecordAudio(boolean recordAudio) {
        this.recordAudio = recordAudio;
    }

    public void setOption(String option, String value) {
        this.setOption(this.captureSettingsPtr, option, value);
    }

    public void setFormat(String formatShortName) {
        this.format = formatShortName;
    }

    public void setMJPEGQuality(double quality) {
        int codecQuality;
        quality = Math.min(1.0, Math.max(quality, 0.0));
        switch (this.codec) {
            case AV_CODEC_ID_H264: {
                throw new RuntimeException("Quality settings not supported");
            }
            case AV_CODEC_ID_MJPEG: {
                codecQuality = 2 + (int)((1.0 - quality) * 30.0);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.setQuality(this.captureSettingsPtr, codecQuality);
    }

    public long getHardwareTime() {
        if (this.lock.tryLock()) {
            if (!this.alive || this.ptr == 0L) {
                return -1L;
            }
            long hardwareTime = this.getHardwareTime(this.ptr);
            this.lock.unlock();
            return hardwareTime;
        }
        return -1L;
    }

    private void receivedFrameAtHardwareTimeFromNative(long hardwareTime, long pts, long timeScaleNumerator, long timeScaleDenumerator) {
        this.captureHandler.receivedFrameAtTime(hardwareTime, pts, timeScaleNumerator, timeScaleDenumerator);
    }

    public void startCapture(String filename, int decklink) throws IOException {
        if (!this.alive) {
            throw new RuntimeException("This Capture interface has been stopped");
        }
        if (this.ptr != 0L) {
            throw new IOException("Capture already started");
        }
        this.ptr = this.recordAudio ? this.startCaptureNativeWithAudio(filename, this.format, decklink, this.captureSettingsPtr) : this.startCaptureNative(filename, this.format, decklink, this.captureSettingsPtr);
        if (this.ptr == 0L) {
            throw new IOException("Cannot open capture card");
        }
    }

    private void stopCaptureFromNative() {
        try {
            this.stopCapture();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stopCapture() throws IOException {
        if (!this.alive) {
            return;
        }
        if (this.ptr == 0L) {
            throw new IOException("Capture not started");
        }
        this.lock.lock();
        this.stopCaptureNative(this.ptr);
        this.alive = false;
        this.ptr = 0L;
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP("Capture test", "Test capture of one or more video capture card", new Parameter[]{new FlaggedOption("codec", (StringParser)JSAP.STRING_PARSER, "MJPEG", false, 'c', "codec", "Codec either: H264 or MJPEG"), new FlaggedOption("outputPath", (StringParser)JSAP.STRING_PARSER, "", false, 'p', "path", "Path to directory where video file(s) are to be saved, expected to end with '/'."), new FlaggedOption("videoQuality", (StringParser)JSAP.DOUBLE_PARSER, String.valueOf(0.85), false, 'q', "quality", "Video quality for MJPEG"), new FlaggedOption("crf", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(23), false, 'r', "crf", "CRF (Constant rate factor) for H264. 0-51, 0 is lossless. Sane values are 18 to 28."), new FlaggedOption("captureDuration", (StringParser)JSAP.INTEGER_PARSER, "5000", false, 'd', "duration", "Capture duration in milliseconds for each capture card"), new FlaggedOption("firstDecklinkId", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(0), false, 'f', "firstId", "ID of the first capture card to test"), new FlaggedOption("lastDecklinkId", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(-1), false, 'l', "lastId", "ID of the last capture card to test")});
        JSAPResult config = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.out.println(jsap.getUsage());
            System.out.println(jsap.getHelp());
            System.exit(-1);
        }
        int firstId = config.getInt("firstDecklinkId");
        int lastId = config.getInt("lastDecklinkId");
        if (lastId < firstId) {
            lastId = firstId;
        }
        String outputPath = config.getString("outputPath");
        int duration = config.getInt("captureDuration");
        CodecID codec = config.getString("codec").contains("264") ? CodecID.AV_CODEC_ID_H264 : CodecID.AV_CODEC_ID_MJPEG;
        for (int id = firstId; id <= lastId; ++id) {
            try {
                Capture capture;
                CaptureHandlerImpl captureHandlerImpl = new CaptureHandlerImpl();
                switch (codec) {
                    case AV_CODEC_ID_H264: {
                        capture = new Capture(captureHandlerImpl, CodecID.AV_CODEC_ID_H264);
                        capture.setOption("g", "1");
                        capture.setOption("crf", String.valueOf(config.getInt("crf")));
                        capture.setOption("profile", "high");
                        capture.setOption("coder", "vlc");
                        break;
                    }
                    case AV_CODEC_ID_MJPEG: {
                        capture = new Capture(captureHandlerImpl, CodecID.AV_CODEC_ID_MJPEG);
                        capture.setMJPEGQuality(config.getDouble("videoQuality"));
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                captureHandlerImpl.setCapture(capture);
                capture.startCapture(outputPath + "capture" + id + ".mp4", id);
                try {
                    Thread.sleep(duration);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
                finally {
                    capture.stopCapture();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        String userVersion = System.getenv(LIBAV_VERSION);
        if (userVersion != null) {
            for (String version : LIBAV_SUPPORTED_VERSIONS) {
                if (!version.startsWith(userVersion)) continue;
                try {
                    System.out.println("[INFO] Trying to load JavaDecklink version " + version);
                    NativeLibraryLoader.loadLibrary((String)"us.ihmc.javadecklink.lib", (String)("JavaDecklink" + version));
                    loaded = true;
                }
                catch (UnsatisfiedLinkError e) {
                    System.err.println("[WARNING] Cannot load JavaDecklink version " + version + ".");
                }
                break;
            }
        } else {
            System.out.println("[INFO] Environment variable IHMC_JAVA_DECKLINK_LIBAV_VERSION not set. Set it to one of the LIBAV_SUPPORTED_VERSIONS in " + Capture.class.getName() + " to force the library version.");
        }
        if (!loaded) {
            for (String version : LIBAV_SUPPORTED_VERSIONS) {
                try {
                    System.out.println("[INFO] Trying to load JavaDecklink version " + version);
                    NativeLibraryLoader.loadLibrary((String)"us.ihmc.javadecklink.lib", (String)("JavaDecklink" + version));
                    loaded = true;
                    break;
                }
                catch (UnsatisfiedLinkError e) {
                    System.err.println("[WARNING] Cannot load JavaDecklink version " + version + ".");
                }
            }
        }
    }

    private static class CaptureHandlerImpl
    implements CaptureHandler {
        private Capture capture;

        private CaptureHandlerImpl() {
        }

        @Override
        public void receivedFrameAtTime(long hardwareTime, long pts, long timeScaleNumerator, long timeScaleDenumerator) {
            long currentTime = this.capture.getHardwareTime();
            System.out.println("Received frame at " + hardwareTime + ", current time: " + currentTime + ", delay: " + (currentTime - hardwareTime) + ",  pts: " + pts + ", timescale: " + timeScaleNumerator + "/" + timeScaleDenumerator);
        }

        public void setCapture(Capture capture) {
            this.capture = capture;
        }
    }

    public static enum CodecID {
        AV_CODEC_ID_MJPEG(1),
        AV_CODEC_ID_H264(2);

        private int id;

        private CodecID(int id) {
            this.id = id;
        }
    }
}

