/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.wrenchDistribution;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.CenterOfPressureCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ContactWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPInputTypeA;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.SelectionCalculator;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.FrictionConeRotationCalculator;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.PlaneContactStateToWrenchMatrixHelper;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class WrenchMatrixCalculator {
    private final int nContactableBodies;
    private final int maxNumberOfContactPoints;
    private final int numberOfBasisVectorsPerContactPoint;
    private final int rhoSize;
    private final int copTaskSize;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean useForceRateHighWeight = new YoBoolean("useForceRateHighWeight", this.registry);
    private final YoDouble rhoWeight = new YoDouble("rhoWeight", this.registry);
    private final YoDouble rhoRateDefaultWeight = new YoDouble("rhoRateDefaultWeight", this.registry);
    @Deprecated
    private final YoDouble rhoRateHighWeight = new YoDouble("rhoRateHighWeight", this.registry);
    private final YoFrameVector2D desiredCoPWeight = new YoFrameVector2D("desiredCoPWeight", null, this.registry);
    private final YoFrameVector2D copRateDefaultWeight = new YoFrameVector2D("copRateDefaultWeight", null, this.registry);
    @Deprecated
    private final YoFrameVector2D copRateHighWeight = new YoFrameVector2D("copRateHighWeight", null, this.registry);
    private final DMatrixRMaj rhoJacobianMatrix;
    private final DMatrixRMaj copJacobianMatrix;
    private final DMatrixRMaj rhoPreviousMatrix;
    private final DMatrixRMaj copRegularizationJacobian;
    private final DMatrixRMaj copRegularizationObjective;
    private final DMatrixRMaj copRateRegularizationJacobian;
    private final DMatrixRMaj copRateRegularizationObjective;
    private final DMatrixRMaj activeRhoMatrix;
    private final DMatrixRMaj rhoMaxMatrix;
    private final DMatrixRMaj rhoWeightMatrix;
    private final DMatrixRMaj rhoRateWeightMatrix;
    private final DMatrixRMaj copRegularizationWeight;
    private final DMatrixRMaj copRateRegularizationWeight;
    private final ReferenceFrame centerOfMassFrame;
    private final Map<RigidBodyBasics, Wrench> wrenchesFromRho = new HashMap<RigidBodyBasics, Wrench>();
    private final List<RigidBodyBasics> rigidBodies = new ArrayList<RigidBodyBasics>();
    private final Map<RigidBodyBasics, PlaneContactStateToWrenchMatrixHelper> planeContactStateToWrenchMatrixHelpers = new HashMap<RigidBodyBasics, PlaneContactStateToWrenchMatrixHelper>();
    private final TObjectIntMap<RigidBodyBasics> bodyRhoOffsets = new TObjectIntHashMap();
    private final List<FramePoint3D> basisVectorsOrigin = new ArrayList<FramePoint3D>();
    private final List<FrameVector3D> basisVectors = new ArrayList<FrameVector3D>();
    private final double dtSquaredInv;
    private final DMatrixRMaj bodyWrenchJacobian = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj fullWrenchJacobian = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj fzRow = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj singleCopRow = new DMatrixRMaj(0, 0);
    private final FrameVector2D weight = new FrameVector2D();
    private final RecyclingArrayList<CenterOfPressureCommand> centerOfPressureCommands = new RecyclingArrayList(CenterOfPressureCommand.class);
    private final RecyclingArrayList<ContactWrenchCommand> contactWrenchCommands = new RecyclingArrayList(ContactWrenchCommand.class);
    private final DMatrixRMaj rigidBodyRhoTaskJacobian = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj tempTaskJacobian = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj tempTaskObjective = new DMatrixRMaj(6, 1);
    private final SelectionCalculator selectionCalculator = new SelectionCalculator();
    private final Vector2D tempDeisredCoPWeight = new Vector2D();
    private final Vector2D tempCoPRateWeight = new Vector2D();

    public WrenchMatrixCalculator(WholeBodyControlCoreToolbox toolbox, YoRegistry parentRegistry) {
        this(toolbox, toolbox.getCenterOfMassFrame(), parentRegistry);
    }

    public WrenchMatrixCalculator(WholeBodyControlCoreToolbox toolbox, ReferenceFrame centerOfMassFrame, YoRegistry parentRegistry) {
        this.centerOfMassFrame = centerOfMassFrame;
        List<? extends ContactablePlaneBody> contactablePlaneBodies = toolbox.getContactablePlaneBodies();
        double dt = toolbox.getControlDT();
        this.dtSquaredInv = 1.0 / (dt * dt);
        this.nContactableBodies = toolbox.getNumberOfContactableBodies();
        this.maxNumberOfContactPoints = toolbox.getNumberOfContactPointsPerContactableBody();
        this.numberOfBasisVectorsPerContactPoint = toolbox.getNumberOfBasisVectorsPerContactPoint();
        this.rhoSize = toolbox.getRhoSize();
        this.copTaskSize = 2 * this.nContactableBodies;
        this.rhoJacobianMatrix = new DMatrixRMaj(6, this.rhoSize);
        this.copJacobianMatrix = new DMatrixRMaj(this.copTaskSize, this.rhoSize);
        this.rhoPreviousMatrix = new DMatrixRMaj(this.rhoSize, 1);
        this.copRegularizationJacobian = new DMatrixRMaj(this.copTaskSize, this.rhoSize);
        this.copRegularizationObjective = new DMatrixRMaj(this.copTaskSize, 1);
        this.copRateRegularizationJacobian = new DMatrixRMaj(this.copTaskSize, this.rhoSize);
        this.copRateRegularizationObjective = new DMatrixRMaj(this.copTaskSize, 1);
        this.activeRhoMatrix = new DMatrixRMaj(this.rhoSize, 1);
        this.rhoMaxMatrix = new DMatrixRMaj(this.rhoSize, 1);
        this.rhoWeightMatrix = new DMatrixRMaj(this.rhoSize, this.rhoSize);
        this.rhoRateWeightMatrix = new DMatrixRMaj(this.rhoSize, this.rhoSize);
        this.copRegularizationWeight = new DMatrixRMaj(this.copTaskSize, this.copTaskSize);
        this.copRateRegularizationWeight = new DMatrixRMaj(this.copTaskSize, this.copTaskSize);
        this.fullWrenchJacobian.reshape(6, this.rhoSize);
        this.fzRow.reshape(1, this.rhoSize);
        this.singleCopRow.reshape(1, this.rhoSize);
        if (contactablePlaneBodies.size() > this.nContactableBodies) {
            throw new RuntimeException("Unexpected number of contactable plane bodies: " + contactablePlaneBodies.size());
        }
        int rhoOffset = 0;
        for (int i = 0; i < contactablePlaneBodies.size(); ++i) {
            ContactablePlaneBody contactablePlaneBody = contactablePlaneBodies.get(i);
            RigidBodyBasics rigidBody = contactablePlaneBody.getRigidBody();
            this.rigidBodies.add(rigidBody);
            FrictionConeRotationCalculator frictionConeRotation = toolbox.getOptimizationSettings().getFrictionConeRotation();
            PlaneContactStateToWrenchMatrixHelper helper = new PlaneContactStateToWrenchMatrixHelper(contactablePlaneBody, centerOfMassFrame, this.maxNumberOfContactPoints, this.numberOfBasisVectorsPerContactPoint, frictionConeRotation, this.registry);
            helper.setDeactivateRhoWhenNotInContact(toolbox.getDeactiveRhoWhenNotInContact());
            this.planeContactStateToWrenchMatrixHelpers.put(rigidBody, helper);
            this.bodyRhoOffsets.put((Object)rigidBody, rhoOffset);
            rhoOffset += helper.getRhoSize();
            for (int rhoIndex = 0; rhoIndex < helper.getRhoSize(); ++rhoIndex) {
                this.basisVectorsOrigin.add(helper.getBasisVectorsOrigin()[rhoIndex]);
                this.basisVectors.add(helper.getBasisVectors()[rhoIndex]);
            }
            MovingReferenceFrame bodyFixedFrame = rigidBody.getBodyFixedFrame();
            Wrench wrench = new Wrench((ReferenceFrame)bodyFixedFrame, (ReferenceFrame)bodyFixedFrame);
            this.wrenchesFromRho.put(rigidBody, wrench);
        }
        ControllerCoreOptimizationSettings optimizationSettings = toolbox.getOptimizationSettings();
        this.rhoWeight.set(optimizationSettings.getRhoWeight());
        this.rhoRateDefaultWeight.set(optimizationSettings.getRhoRateDefaultWeight());
        this.rhoRateHighWeight.set(optimizationSettings.getRhoRateHighWeight());
        this.desiredCoPWeight.set((Tuple2DReadOnly)optimizationSettings.getCoPWeight());
        this.copRateDefaultWeight.set((Tuple2DReadOnly)optimizationSettings.getCoPRateDefaultWeight());
        this.copRateHighWeight.set((Tuple2DReadOnly)optimizationSettings.getCoPRateHighWeight());
        parentRegistry.addChild(this.registry);
    }

    public void setRhoWeight(double rhoWeight) {
        this.rhoWeight.set(rhoWeight);
    }

    public void setRhoRateWeight(double rhoRateWeight) {
        this.rhoRateDefaultWeight.set(rhoRateWeight);
    }

    public void setDesiredCoPWeight(Tuple2DReadOnly centerOfPressureWeight) {
        this.desiredCoPWeight.set(centerOfPressureWeight);
    }

    public void setCoPRateWeight(Tuple2DReadOnly centerOfPressureRateWeight) {
        this.copRateDefaultWeight.set(centerOfPressureRateWeight);
    }

    public void submitPlaneContactStateCommand(PlaneContactStateCommand command) {
        PlaneContactStateToWrenchMatrixHelper helper = this.planeContactStateToWrenchMatrixHelpers.get(command.getContactingRigidBody());
        helper.setPlaneContactStateCommand(command);
        this.useForceRateHighWeight.set(command.isUseHighCoPDamping());
    }

    public void submitCenterOfPressureCommand(CenterOfPressureCommand command) {
        ((CenterOfPressureCommand)this.centerOfPressureCommands.add()).set(command);
    }

    public boolean getCenterOfPressureInput(QPInputTypeA inputToPack) {
        int commands = this.centerOfPressureCommands.size();
        if (commands <= 0) {
            return false;
        }
        CenterOfPressureCommand command = (CenterOfPressureCommand)this.centerOfPressureCommands.get(commands - 1);
        RigidBodyBasics rigidBody = command.getContactingRigidBody();
        FramePoint2DBasics desiredCoP = command.getDesiredCoP();
        ReferenceFrame planeFrame = desiredCoP.getReferenceFrame();
        this.fullWrenchJacobian.zero();
        int rhoStartIndex = 0;
        for (int i = 0; i < this.rigidBodies.size(); ++i) {
            PlaneContactStateToWrenchMatrixHelper helper = this.planeContactStateToWrenchMatrixHelpers.get(this.rigidBodies.get(i));
            if (rigidBody == null || this.rigidBodies.get(i) == rigidBody && helper.canHandleCoPCommand()) {
                helper.computeWrenchJacobianInFrame(planeFrame, this.bodyWrenchJacobian);
                CommonOps_DDRM.insert((DMatrix)this.bodyWrenchJacobian, (DMatrix)this.fullWrenchJacobian, (int)0, (int)rhoStartIndex);
            }
            rhoStartIndex += helper.getRhoSize();
        }
        inputToPack.reshape(2);
        inputToPack.setConstraintType(command.getConstraintType());
        int fzIndex = 5;
        CommonOps_DDRM.extractRow((DMatrixRMaj)this.fullWrenchJacobian, (int)fzIndex, (DMatrixRMaj)this.fzRow);
        int tauYIndex = 1;
        CommonOps_DDRM.extractRow((DMatrixRMaj)this.fullWrenchJacobian, (int)tauYIndex, (DMatrixRMaj)this.singleCopRow);
        CommonOps_DDRM.add((double)desiredCoP.getX(), (DMatrixD1)this.fzRow, (double)1.0, (DMatrixD1)this.singleCopRow, (DMatrixD1)this.singleCopRow);
        CommonOps_DDRM.insert((DMatrix)this.singleCopRow, (DMatrix)inputToPack.getTaskJacobian(), (int)0, (int)0);
        inputToPack.getTaskObjective().set(0, 0.0);
        int tauXIndex = 0;
        CommonOps_DDRM.extractRow((DMatrixRMaj)this.fullWrenchJacobian, (int)tauXIndex, (DMatrixRMaj)this.singleCopRow);
        CommonOps_DDRM.add((double)desiredCoP.getY(), (DMatrixD1)this.fzRow, (double)-1.0, (DMatrixD1)this.singleCopRow, (DMatrixD1)this.singleCopRow);
        CommonOps_DDRM.insert((DMatrix)this.singleCopRow, (DMatrix)inputToPack.getTaskJacobian(), (int)1, (int)0);
        inputToPack.getTaskObjective().set(1, 0.0);
        inputToPack.getTaskWeightMatrix().zero();
        if (command.getConstraintType() == ConstraintType.OBJECTIVE) {
            this.weight.setIncludingFrame((FrameTuple2DReadOnly)command.getWeight());
            this.weight.changeFrame(planeFrame);
            inputToPack.getTaskWeightMatrix().set(0, 0, command.getWeight().getX());
            inputToPack.getTaskWeightMatrix().set(1, 1, command.getWeight().getY());
        } else if (command.getConstraintType() != ConstraintType.EQUALITY) {
            throw new RuntimeException("Inequalities are not supported by this command.");
        }
        this.centerOfPressureCommands.remove(commands - 1);
        return true;
    }

    public void submitContactWrenchCommand(ContactWrenchCommand command) {
        ((ContactWrenchCommand)this.contactWrenchCommands.add()).set(command);
    }

    public boolean getContactWrenchInput(QPInputTypeA inputToPack) {
        int commands = this.contactWrenchCommands.size();
        if (commands <= 0) {
            return false;
        }
        ContactWrenchCommand command = (ContactWrenchCommand)this.contactWrenchCommands.get(commands - 1);
        int taskSize = command.getSelectionMatrix().getNumberOfSelectedAxes();
        inputToPack.setConstraintType(command.getConstraintType());
        inputToPack.reshape(taskSize);
        this.computeCommandMatrices(command, this.rigidBodyRhoTaskJacobian, inputToPack.getTaskObjective(), inputToPack.getTaskWeightMatrix());
        int rhoOffset = this.bodyRhoOffsets.get((Object)command.getRigidBody());
        DMatrixRMaj fullJacobian = inputToPack.getTaskJacobian();
        fullJacobian.zero();
        CommonOps_DDRM.insert((DMatrix)this.rigidBodyRhoTaskJacobian, (DMatrix)fullJacobian, (int)0, (int)rhoOffset);
        this.contactWrenchCommands.remove(commands - 1);
        return true;
    }

    private void computeCommandMatrices(ContactWrenchCommand command, DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        PlaneContactStateToWrenchMatrixHelper helper = this.planeContactStateToWrenchMatrixHelpers.get(command.getRigidBody());
        ReferenceFrame planeFrame = helper.getPlaneFrame();
        Wrench wrench = command.getWrench();
        wrench.getBodyFrame().checkReferenceFrameMatch((ReferenceFrame)helper.getRigidBody().getBodyFixedFrame());
        wrench.changeFrame(planeFrame);
        wrench.get((DMatrix)this.tempTaskObjective);
        this.tempTaskJacobian.set((DMatrixD1)helper.getWrenchJacobianMatrix());
        SelectionMatrix6D selectionMatrix = command.getSelectionMatrix();
        WeightMatrix6D weightMatrix = command.getWeightMatrix();
        if (command.getConstraintType() != ConstraintType.OBJECTIVE) {
            weightMatrix.setAngularWeights(0.0, 0.0, 0.0);
            weightMatrix.setLinearWeights(0.0, 0.0, 0.0);
        }
        this.selectionCalculator.applySelectionToTask(selectionMatrix, weightMatrix, planeFrame, this.tempTaskJacobian, this.tempTaskObjective, taskJacobian, taskObjective, taskWeight);
    }

    public boolean hasContactStateChanged() {
        boolean hasContactStateChanged = false;
        for (int i = 0; i < this.rigidBodies.size(); ++i) {
            RigidBodyBasics rigidBody = this.rigidBodies.get(i);
            PlaneContactStateToWrenchMatrixHelper helper = this.planeContactStateToWrenchMatrixHelpers.get(rigidBody);
            if (!helper.hasReset()) continue;
            hasContactStateChanged = true;
        }
        return hasContactStateChanged;
    }

    public void computeMatrices() {
        double rhoRateWeight;
        double rhoWeight = this.rhoWeight.getDoubleValue();
        this.tempDeisredCoPWeight.set((Tuple2DReadOnly)this.desiredCoPWeight);
        if (this.useForceRateHighWeight.getBooleanValue()) {
            rhoRateWeight = this.rhoRateHighWeight.getDoubleValue();
            this.tempCoPRateWeight.set((Tuple2DReadOnly)this.copRateHighWeight);
        } else {
            rhoRateWeight = this.rhoRateDefaultWeight.getDoubleValue();
            this.tempCoPRateWeight.set((Tuple2DReadOnly)this.copRateDefaultWeight);
        }
        int rhoStartIndex = 0;
        int copStartIndex = 0;
        for (int i = 0; i < this.rigidBodies.size(); ++i) {
            RigidBodyBasics rigidBody = this.rigidBodies.get(i);
            PlaneContactStateToWrenchMatrixHelper helper = this.planeContactStateToWrenchMatrixHelpers.get(rigidBody);
            helper.computeMatrices(rhoWeight, rhoRateWeight, (Vector2DReadOnly)this.tempDeisredCoPWeight, (Vector2DReadOnly)this.tempCoPRateWeight);
            CommonOps_DDRM.insert((DMatrix)helper.getLastRho(), (DMatrix)this.rhoPreviousMatrix, (int)rhoStartIndex, (int)0);
            CommonOps_DDRM.insert((DMatrix)helper.getActiveRhoMatrix(), (DMatrix)this.activeRhoMatrix, (int)rhoStartIndex, (int)0);
            CommonOps_DDRM.insert((DMatrix)helper.getRhoJacobian(), (DMatrix)this.rhoJacobianMatrix, (int)0, (int)rhoStartIndex);
            CommonOps_DDRM.insert((DMatrix)helper.getRhoMax(), (DMatrix)this.rhoMaxMatrix, (int)rhoStartIndex, (int)0);
            CommonOps_DDRM.insert((DMatrix)helper.getRhoWeight(), (DMatrix)this.rhoWeightMatrix, (int)rhoStartIndex, (int)rhoStartIndex);
            CommonOps_DDRM.insert((DMatrix)helper.getRhoRateWeight(), (DMatrix)this.rhoRateWeightMatrix, (int)rhoStartIndex, (int)rhoStartIndex);
            CommonOps_DDRM.insert((DMatrix)helper.getCoPRegularizationJacobian(), (DMatrix)this.copRegularizationJacobian, (int)copStartIndex, (int)rhoStartIndex);
            CommonOps_DDRM.insert((DMatrix)helper.getCoPRegularizationObjective(), (DMatrix)this.copRegularizationObjective, (int)copStartIndex, (int)0);
            CommonOps_DDRM.insert((DMatrix)helper.getCoPRateRegularizationJacobian(), (DMatrix)this.copRateRegularizationJacobian, (int)copStartIndex, (int)rhoStartIndex);
            CommonOps_DDRM.insert((DMatrix)helper.getCoPRateRegularizationObjective(), (DMatrix)this.copRateRegularizationObjective, (int)copStartIndex, (int)0);
            CommonOps_DDRM.insert((DMatrix)helper.getCoPRegularizationWeight(), (DMatrix)this.copRegularizationWeight, (int)copStartIndex, (int)copStartIndex);
            CommonOps_DDRM.insert((DMatrix)helper.getCoPRateRegularizationWeight(), (DMatrix)this.copRateRegularizationWeight, (int)copStartIndex, (int)copStartIndex);
            rhoStartIndex += helper.getRhoSize();
            copStartIndex += 2;
        }
        CommonOps_DDRM.scale((double)this.dtSquaredInv, (DMatrixD1)this.rhoRateWeightMatrix);
        CommonOps_DDRM.scale((double)this.dtSquaredInv, (DMatrixD1)this.copRateRegularizationWeight);
    }

    public Map<RigidBodyBasics, Wrench> computeWrenchesFromRho(DMatrixRMaj rho) {
        for (int i = 0; i < this.rigidBodies.size(); ++i) {
            RigidBodyBasics rigidBody = this.rigidBodies.get(i);
            MovingReferenceFrame bodyFixedFrame = rigidBody.getBodyFixedFrame();
            this.wrenchesFromRho.get(rigidBody).setToZero((ReferenceFrame)bodyFixedFrame, (ReferenceFrame)bodyFixedFrame);
        }
        int rhoStartIndex = 0;
        for (int i = 0; i < this.rigidBodies.size(); ++i) {
            RigidBodyBasics rigidBody = this.rigidBodies.get(i);
            MovingReferenceFrame bodyFixedFrame = rigidBody.getBodyFixedFrame();
            PlaneContactStateToWrenchMatrixHelper helper = this.planeContactStateToWrenchMatrixHelpers.get(rigidBody);
            helper.computeWrenchFromRho(rhoStartIndex, rho);
            Wrench wrenchFromRho = helper.getWrenchFromRho();
            wrenchFromRho.changeFrame((ReferenceFrame)bodyFixedFrame);
            this.wrenchesFromRho.get(rigidBody).add((WrenchReadOnly)wrenchFromRho);
            rhoStartIndex += helper.getRhoSize();
        }
        return this.wrenchesFromRho;
    }

    public List<RigidBodyBasics> getRigidBodies() {
        return this.rigidBodies;
    }

    public DMatrixRMaj getRhoJacobianMatrix() {
        return this.rhoJacobianMatrix;
    }

    public void getRhoJacobianMatrix(DMatrixRMaj rhoJacobianMatrix) {
        rhoJacobianMatrix.set((DMatrixD1)this.rhoJacobianMatrix);
    }

    public DMatrixRMaj getCopJacobianMatrix() {
        return this.copJacobianMatrix;
    }

    public DMatrixRMaj getRhoPreviousMatrix() {
        return this.rhoPreviousMatrix;
    }

    public DMatrixRMaj getActiveRhoMatrix() {
        return this.activeRhoMatrix;
    }

    public DMatrixRMaj getRhoMaxMatrix() {
        return this.rhoMaxMatrix;
    }

    public DMatrixRMaj getRhoWeightMatrix() {
        return this.rhoWeightMatrix;
    }

    public DMatrixRMaj getRhoRateWeightMatrix() {
        return this.rhoRateWeightMatrix;
    }

    public DMatrixRMaj getCoPRegularizationJacobian() {
        return this.copRegularizationJacobian;
    }

    public DMatrixRMaj getCoPRegularizationObjective() {
        return this.copRegularizationObjective;
    }

    public DMatrixRMaj getCoPRateRegularizationJacobian() {
        return this.copRateRegularizationJacobian;
    }

    public DMatrixRMaj getCoPRateRegularizationObjective() {
        return this.copRateRegularizationObjective;
    }

    public DMatrixRMaj getCoPRegularizationWeight() {
        return this.copRegularizationWeight;
    }

    public DMatrixRMaj getCoPRateRegularizationWeight() {
        return this.copRateRegularizationWeight;
    }

    public Map<RigidBodyBasics, Wrench> getWrenchesFromRho() {
        return this.wrenchesFromRho;
    }

    public List<FramePoint3D> getBasisVectorsOrigin() {
        return this.basisVectorsOrigin;
    }

    public DMatrixRMaj getRhoJacobianMatrix(RigidBodyBasics rigidBody) {
        return this.planeContactStateToWrenchMatrixHelpers.get(rigidBody).getRhoJacobian();
    }

    public ReferenceFrame getJacobianFrame() {
        return this.centerOfMassFrame;
    }

    public List<FrameVector3D> getBasisVectors() {
        return this.basisVectors;
    }

    public int getRhoSize() {
        return this.rhoSize;
    }

    public int getCopTaskSize() {
        return this.copTaskSize;
    }
}

