/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.visualizer;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicShape;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaBasics;
import us.ihmc.robotics.robotDescription.InertiaTools;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class CommonInertiaEllipsoidsVisualizer
implements Updatable,
RobotController {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoFrameVector3D inertiaEllipsoidGhostOffset = new YoFrameVector3D("inertiaEllipsoidGhostOffset", "", this.worldFrame, this.registry);
    private final ArrayList<YoGraphic> yoGraphics = new ArrayList();
    private final YoDouble minimumMassOfRigidBodies = new YoDouble("minimumMassOfRigidBodies", this.registry);
    private final YoDouble maximumMassOfRigidBodies = new YoDouble("maximumMassOfRigidBodies", this.registry);
    private final ArrayList<RigidBodyVisualizationData> centerOfMassData = new ArrayList();

    public CommonInertiaEllipsoidsVisualizer(RigidBodyBasics rootBody, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this(rootBody, yoGraphicsListRegistry);
        parentRegistry.addChild(this.registry);
    }

    public CommonInertiaEllipsoidsVisualizer(RigidBodyBasics rootBody, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.inertiaEllipsoidGhostOffset.set(0.0, 0.0, 0.0);
        this.findMinimumAndMaximumMassOfRigidBodies(rootBody);
        this.addRigidBodyAndChilderenToVisualization(rootBody);
        yoGraphicsListRegistry.registerYoGraphics(this.name, this.yoGraphics);
        this.update();
    }

    private void findMinimumAndMaximumMassOfRigidBodies(RigidBodyBasics body) {
        SpatialInertiaBasics inertia = body.getInertia();
        if (inertia != null) {
            double mass = body.getInertia().getMass();
            if (mass < this.minimumMassOfRigidBodies.getDoubleValue() && mass > 0.001) {
                this.minimumMassOfRigidBodies.set(mass);
            }
            if (mass > this.maximumMassOfRigidBodies.getDoubleValue()) {
                this.maximumMassOfRigidBodies.set(mass);
            }
        }
        if (body.hasChildrenJoints()) {
            List childJoints = body.getChildrenJoints();
            for (JointBasics joint : childJoints) {
                RigidBodyBasics nextBody = joint.getSuccessor();
                if (nextBody == null) continue;
                this.findMinimumAndMaximumMassOfRigidBodies(nextBody);
            }
        }
    }

    public Color getColor(double mass) {
        if (mass < this.minimumMassOfRigidBodies.getDoubleValue()) {
            mass = this.minimumMassOfRigidBodies.getDoubleValue();
        }
        float massScale = (float)((mass - this.minimumMassOfRigidBodies.getDoubleValue()) / (this.maximumMassOfRigidBodies.getDoubleValue() - this.minimumMassOfRigidBodies.getDoubleValue()));
        float H = (1.0f - massScale) * 0.4f;
        float S = 0.9f;
        float B = 0.9f;
        return Color.getHSBColor(H, S, B);
    }

    private void addRigidBodyAndChilderenToVisualization(RigidBodyBasics currentRigidBody) {
        SpatialInertiaBasics inertia = currentRigidBody.getInertia();
        if (inertia != null) {
            Matrix3D inertiaMatrix = new Matrix3D((Matrix3DReadOnly)inertia.getMomentOfInertia());
            double mass = inertia.getMass();
            String rigidBodyName = currentRigidBody.getName();
            YoFramePoint3D comPosition = new YoFramePoint3D("centerOfMassPosition", rigidBodyName, this.worldFrame, this.registry);
            YoFrameYawPitchRoll comOrientation = new YoFrameYawPitchRoll("rigidBodyOrientation", rigidBodyName, this.worldFrame, this.registry);
            RigidBodyVisualizationData comData = new RigidBodyVisualizationData(currentRigidBody, comPosition, comOrientation);
            this.centerOfMassData.add(comData);
            AppearanceDefinition appearance = YoAppearance.Color((Color)this.getColor(currentRigidBody.getInertia().getMass()));
            appearance.setTransparency(0.6);
            YoGraphicShape comViz = new YoGraphicShape(rigidBodyName + "CoMEllipsoid", this.createEllipsoid(inertiaMatrix, mass, appearance), comPosition, comOrientation, 1.0);
            this.yoGraphics.add((YoGraphic)comViz);
        }
        if (currentRigidBody.hasChildrenJoints()) {
            List childJoints = currentRigidBody.getChildrenJoints();
            for (JointBasics joint : childJoints) {
                RigidBodyBasics nextRigidBody = joint.getSuccessor();
                if (nextRigidBody == null) continue;
                this.addRigidBodyAndChilderenToVisualization(nextRigidBody);
            }
        }
    }

    @Override
    public void update(double time) {
        this.update();
    }

    public void update() {
        FramePoint3D tempCoMPosition = new FramePoint3D(this.worldFrame);
        for (RigidBodyVisualizationData comData : this.centerOfMassData) {
            comData.rigidBody.getCenterOfMass((FramePoint3DBasics)tempCoMPosition);
            tempCoMPosition.changeFrame(this.worldFrame);
            tempCoMPosition.add((FrameTuple3DReadOnly)this.inertiaEllipsoidGhostOffset);
            FrameQuaternion orientation = new FrameQuaternion((ReferenceFrame)comData.rigidBody.getBodyFixedFrame());
            orientation.changeFrame(this.worldFrame);
            comData.position.set((FrameTuple3DReadOnly)tempCoMPosition);
            comData.orientation.set((FrameOrientation3DReadOnly)orientation);
        }
    }

    public void initialize() {
        this.update();
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.getName();
    }

    public void doControl() {
        this.update();
    }

    private Graphics3DObject createEllipsoid(Matrix3D inertia, double mass, AppearanceDefinition appearance) {
        RotationMatrix rotationMatrix3d = new RotationMatrix();
        Vector3D principalMomentsOfInertiaToPack = new Vector3D();
        InertiaTools.computePrincipalMomentsOfInertia((Matrix3D)inertia, (RotationMatrix)rotationMatrix3d, (Vector3D)principalMomentsOfInertiaToPack);
        double a = 5.0 * principalMomentsOfInertiaToPack.getX() / mass;
        double b = 5.0 * principalMomentsOfInertiaToPack.getY() / mass;
        double c = 5.0 * principalMomentsOfInertiaToPack.getZ() / mass;
        double rx = Math.sqrt(0.5 * (-a + b + c));
        double ry = Math.sqrt(0.5 * (a - b + c));
        double rz = Math.sqrt(0.5 * (a + b - c));
        Graphics3DObject graphics = new Graphics3DObject();
        graphics.identity();
        graphics.rotate((Orientation3DReadOnly)rotationMatrix3d);
        graphics.addEllipsoid(rx, ry, rz, appearance);
        return graphics;
    }

    private class RigidBodyVisualizationData {
        public RigidBodyBasics rigidBody;
        public YoFramePoint3D position;
        public YoFrameYawPitchRoll orientation;

        public RigidBodyVisualizationData(RigidBodyBasics rigidBody, YoFramePoint3D position, YoFrameYawPitchRoll orientation) {
            this.rigidBody = rigidBody;
            this.position = position;
            this.orientation = orientation;
        }
    }
}

