/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.virtualModelControl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class VirtualModelControlDataHandler {
    public final List<RigidBodyBasics> controlledBodies = new ArrayList<RigidBodyBasics>();
    private final Map<RigidBodyBasics, List<OneDoFJointBasics[]>> jointChainsForControl = new LinkedHashMap<RigidBodyBasics, List<OneDoFJointBasics[]>>();
    private final List<OneDoFJointBasics> controlledJoints = new ArrayList<OneDoFJointBasics>();
    public int numberOfControlledJoints = 0;
    private final Map<RigidBodyBasics, Wrench> desiredWrenches = new LinkedHashMap<RigidBodyBasics, Wrench>();
    private final Map<RigidBodyBasics, FrameVector3D> desiredForces = new LinkedHashMap<RigidBodyBasics, FrameVector3D>();
    private final Map<RigidBodyBasics, FrameVector3D> desiredTorques = new LinkedHashMap<RigidBodyBasics, FrameVector3D>();
    private final Map<RigidBodyBasics, DMatrixRMaj> desiredSelectionMatrices = new LinkedHashMap<RigidBodyBasics, DMatrixRMaj>();

    public void clear() {
        this.desiredForces.clear();
        this.desiredTorques.clear();
        this.desiredWrenches.clear();
        this.desiredSelectionMatrices.clear();
    }

    public void reset() {
        this.controlledBodies.clear();
        this.jointChainsForControl.clear();
        this.numberOfControlledJoints = 0;
        this.clear();
    }

    public void addBodyForControl(RigidBodyBasics bodyForControl) {
        if (!this.controlledBodies.contains(bodyForControl)) {
            this.controlledBodies.add(bodyForControl);
            this.jointChainsForControl.put(bodyForControl, new ArrayList());
        } else {
            LogTools.warn((String)("Class has already registered " + bodyForControl.getName() + "."));
        }
    }

    public void addJointsForControl(RigidBodyBasics controlledBody, OneDoFJointBasics[] jointsToUse) {
        int length = jointsToUse.length;
        if (length > 0) {
            int i;
            OneDoFJointBasics[] orderedJointsToUse;
            boolean rightOrder = true;
            if (length > 1) {
                MultiBodySystemTools.isAncestor((RigidBodyReadOnly)jointsToUse[1].getPredecessor(), (RigidBodyReadOnly)jointsToUse[0].getPredecessor());
            }
            if (rightOrder) {
                orderedJointsToUse = jointsToUse;
            } else {
                orderedJointsToUse = new OneDoFJointBasics[length];
                for (i = 0; i < length; ++i) {
                    orderedJointsToUse[i] = jointsToUse[length - 1 - i];
                }
            }
            this.jointChainsForControl.get(controlledBody).add(orderedJointsToUse);
            for (i = 0; i < length; ++i) {
                if (this.controlledJoints.contains(orderedJointsToUse[i])) continue;
                this.controlledJoints.add(orderedJointsToUse[i]);
            }
            this.numberOfControlledJoints = this.controlledJoints.size();
        }
    }

    public void addDesiredWrench(RigidBodyBasics controlledBody, Wrench desiredWrench) {
        if (this.hasBody(controlledBody)) {
            this.desiredWrenches.put(controlledBody, desiredWrench);
        }
    }

    public void addDesiredSelectionMatrix(RigidBodyBasics controlledBody, DMatrixRMaj selectionMatrix) {
        if (this.hasBody(controlledBody)) {
            if (this.desiredSelectionMatrices.get(controlledBody) != null) {
                LogTools.warn((String)("Class already contains selection matrix for body " + controlledBody.getName() + ". It is being overwritten."));
            }
            this.desiredSelectionMatrices.put(controlledBody, selectionMatrix);
        }
    }

    public boolean hasBody(RigidBodyBasics controlledBody) {
        return this.controlledBodies.contains(controlledBody) || controlledBody == null;
    }

    public boolean hasWrench(RigidBodyBasics controlledBody) {
        return this.desiredWrenches.get(controlledBody) != null;
    }

    public boolean hasSelectionMatrix(RigidBodyBasics controlledBody) {
        return this.desiredSelectionMatrices.get(controlledBody) != null;
    }

    public int jointsInChain(RigidBodyBasics controlledBody, int chainID) {
        return this.jointChainsForControl.get(controlledBody).get(chainID).length;
    }

    public int numberOfChains(RigidBodyBasics controlledBody) {
        return this.jointChainsForControl.get(controlledBody).size();
    }

    public int indexOfInTree(RigidBodyBasics controlledBody, int chainID, int jointNumberInChain) {
        return this.controlledJoints.indexOf(this.jointChainsForControl.get(controlledBody).get(chainID)[jointNumberInChain]);
    }

    public List<OneDoFJointBasics> getControlledJoints() {
        return this.controlledJoints;
    }

    public List<RigidBodyBasics> getControlledBodies() {
        return this.controlledBodies;
    }

    public OneDoFJointBasics[] getJointsForControl(RigidBodyBasics controlledBody, int chainID) {
        return this.jointChainsForControl.get(controlledBody).get(chainID);
    }

    public Wrench getDesiredWrench(RigidBodyBasics controlledBody) {
        return this.desiredWrenches.get(controlledBody);
    }

    public DMatrixRMaj getDesiredSelectionMatrix(RigidBodyBasics controlledBody) {
        return this.desiredSelectionMatrices.get(controlledBody);
    }
}

