/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.trajectories;

import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFourPointCubicSpline1D {
    private static final double EPS = 0.001;
    private static final int numberOfCoefficients = 4;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoPolynomial spline;
    private final YoDouble y;
    private final YoDouble yDot;
    private final YoDouble yDDot;
    private final Point2D start = new Point2D();
    private final Point2D end = new Point2D();

    public YoFourPointCubicSpline1D(String namePrefix, YoRegistry parentRegistry) {
        this.spline = new YoPolynomial(namePrefix + "CubicSpline", 4, this.registry);
        this.y = new YoDouble(namePrefix + "Value", this.registry);
        this.yDot = new YoDouble(namePrefix + "Dot", this.registry);
        this.yDDot = new YoDouble(namePrefix + "DDot", this.registry);
        parentRegistry.addChild(this.registry);
    }

    public void initialize(Point2DReadOnly start, Point2DReadOnly firstWaypoint, Point2DReadOnly secondWaypoint, Point2DReadOnly end) {
        double startX = start.getX();
        double startY = start.getY();
        double firstWaypointX = firstWaypoint.getX();
        double firstWaypointY = firstWaypoint.getY();
        double secondWaypointX = secondWaypoint.getX();
        double secondWaypointY = secondWaypoint.getY();
        double endX = end.getX();
        double endY = end.getY();
        this.initialize(startX, startY, firstWaypointX, firstWaypointY, secondWaypointX, secondWaypointY, endX, endY);
    }

    public void initialize(double startX, double startY, double firstWaypointX, double firstWaypointY, double secondWaypointX, double secondWaypointY, double endX, double endY) {
        if (startX > firstWaypointX) {
            throw new RuntimeException("x values must be in increasing order!");
        }
        if (firstWaypointX > secondWaypointX) {
            throw new RuntimeException("x values must be in increasing order!");
        }
        if (secondWaypointX > endX) {
            throw new RuntimeException("x values must be in increasing order!");
        }
        this.start.set(startX, startY);
        this.end.set(endX, endY);
        this.spline.setCubicUsingIntermediatePoints(startX, firstWaypointX, secondWaypointX, endX, startY, firstWaypointY, secondWaypointY, endY);
    }

    public void compute(double xQuery) {
        if (xQuery < this.start.getX() + 0.001) {
            this.y.set(this.start.getY());
            this.yDot.set(0.0);
            this.yDDot.set(0.0);
        } else if (xQuery > this.end.getX() - 0.001) {
            this.y.set(this.end.getY());
            this.yDot.set(0.0);
            this.yDDot.set(0.0);
        } else {
            this.spline.compute(xQuery);
            this.y.set(this.spline.getValue());
            this.yDot.set(this.spline.getVelocity());
            this.yDDot.set(this.spline.getAcceleration());
        }
    }

    public double getY() {
        return this.y.getDoubleValue();
    }

    public double getYDot() {
        return this.yDot.getDoubleValue();
    }

    public double getYDDot() {
        return this.yDDot.getDoubleValue();
    }
}

