/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.trajectories;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameVector3D;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class VelocityConstrainedPoseTrajectoryGenerator
implements FixedFramePoseTrajectoryGenerator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry;
    private final YoMutableFramePoint3D initialPosition;
    private final YoMutableFrameVector3D initialVelocity;
    private final YoMutableFramePoint3D finalPosition;
    private final YoMutableFrameVector3D finalVelocity;
    private final YoFramePoint3D finalPositionForViz;
    private final YoMutableFrameQuaternion initialOrientation;
    private final YoMutableFrameVector3D initialAngularVelocity;
    private final YoMutableFrameQuaternion finalOrientation;
    private final YoMutableFrameVector3D finalAngularVelocity;
    private final YoFrameYawPitchRoll finalOrientationForViz;
    private final YoMutableFramePose3D currentPose;
    private final YoMutableFrameVector3D currentVelocity;
    private final YoMutableFrameVector3D currentAcceleration;
    private final YoMutableFrameVector3D currentAngularVelocity;
    private final YoMutableFrameVector3D currentAngularAcceleration;
    private final YoFrameYawPitchRoll currentOrientationForViz;
    private final FrameQuaternion tempCurrentOrientation;
    private final FrameVector3D tempCurrentAngularVelocity;
    private final AxisAngle tempAxisAngle;
    private final Vector3D tempVector;
    double vectorLength;
    private final double FDdt = 5.0E-6;
    private Quaternion quatFD1;
    private Quaternion quatFD3;
    private Quaternion quatFDDelta;
    private double deltaAngle;
    private double omegaFD;
    private FrameVector3D omegaVectorDF;
    private final FramePoint3D tempPosition;
    private final FrameQuaternion tempOrientation;
    private final FrameQuaternion copyOfInitialOrientation;
    private final FrameQuaternion copyOfFinalOrientation;
    private final FrameVector3D copyOfInitialAngularVelocity;
    private final FrameVector3D copyOfFinalAngularVelocity;
    private final YoPolynomial xPolynomial;
    private final YoPolynomial yPolynomial;
    private final YoPolynomial zPolynomial;
    private final YoPolynomial xRotPolynomial;
    private final YoPolynomial yRotPolynomial;
    private final YoPolynomial zRotPolynomial;
    private ReferenceFrame trajectoryFrame;
    private final ReferenceFrame interpolationFrame;
    private ReferenceFrame currentTrajectoryFrame;
    private ReferenceFrame finalFrame;
    private final YoFrameYawPitchRoll interpolationFrameForViz;
    private final YoDouble currentTime;
    private final YoDouble trajectoryTime;
    private final boolean visualize;
    private final YoGraphicsList yoGraphicsList;
    private final BagOfBalls bagOfBalls;
    private final FramePoint3D ballPosition = new FramePoint3D();
    private final int numberOfBalls = 50;
    private final YoBoolean showViz;
    private final List<ImmutablePair<FrameTuple3DReadOnly, FixedFrameTuple3DBasics>> visualizationUpdatables = new ArrayList<ImmutablePair<FrameTuple3DReadOnly, FixedFrameTuple3DBasics>>();

    public VelocityConstrainedPoseTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this(namePrefix, referenceFrame, parentRegistry, false, null);
    }

    public VelocityConstrainedPoseTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, YoRegistry parentRegistry, boolean visualize, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.trajectoryFrame = referenceFrame;
        this.quatFD1 = new Quaternion();
        this.quatFD3 = new Quaternion();
        this.quatFDDelta = new Quaternion();
        this.omegaVectorDF = new FrameVector3D();
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.initialPosition = new YoMutableFramePoint3D(namePrefix + "InitialPosition", "", this.registry, referenceFrame);
        this.initialVelocity = new YoMutableFrameVector3D(namePrefix + "InitialVelocity", "", this.registry, referenceFrame);
        this.finalPosition = new YoMutableFramePoint3D(namePrefix + "FinalPosition", "", this.registry, referenceFrame);
        this.finalVelocity = new YoMutableFrameVector3D(namePrefix + "FinalVelocity", "", this.registry, referenceFrame);
        this.finalPositionForViz = new YoFramePoint3D(namePrefix + "FinalPositionForViz", worldFrame, this.registry);
        this.initialOrientation = new YoMutableFrameQuaternion(namePrefix + "InitialOrientation", "", this.registry, referenceFrame);
        this.initialAngularVelocity = new YoMutableFrameVector3D(namePrefix + "InitialAngularVelocity", "", this.registry, referenceFrame);
        this.finalOrientation = new YoMutableFrameQuaternion(namePrefix + "FinalOrientation", "", this.registry, referenceFrame);
        this.finalAngularVelocity = new YoMutableFrameVector3D(namePrefix + "FinalAngularVelocity", "", this.registry, referenceFrame);
        this.finalOrientationForViz = new YoFrameYawPitchRoll(namePrefix + "FinalOrientationForViz", worldFrame, this.registry);
        this.currentPose = new YoMutableFramePose3D(namePrefix + "CurrentPosition", "", this.registry);
        this.currentPose.setToZero(referenceFrame);
        this.currentVelocity = new YoMutableFrameVector3D(namePrefix + "CurrentVelocity", "", this.registry, referenceFrame);
        this.currentAcceleration = new YoMutableFrameVector3D(namePrefix + "CurrentAcceleration", "", this.registry, referenceFrame);
        this.currentAngularVelocity = new YoMutableFrameVector3D(namePrefix + "CurrentAngularVelocity", "", this.registry, referenceFrame);
        this.currentAngularAcceleration = new YoMutableFrameVector3D(namePrefix + "CurrentAngularAcceleration", "", this.registry, referenceFrame);
        this.currentOrientationForViz = new YoFrameYawPitchRoll(namePrefix + "CurrentOrientationForViz", worldFrame, this.registry);
        this.tempCurrentOrientation = new FrameQuaternion();
        this.tempCurrentAngularVelocity = new FrameVector3D();
        this.tempAxisAngle = new AxisAngle();
        this.tempVector = new Vector3D();
        this.tempPosition = new FramePoint3D();
        this.tempOrientation = new FrameQuaternion(this.trajectoryFrame);
        this.copyOfInitialOrientation = new FrameQuaternion(this.trajectoryFrame);
        this.copyOfFinalOrientation = new FrameQuaternion(this.trajectoryFrame);
        this.copyOfInitialAngularVelocity = new FrameVector3D(this.trajectoryFrame);
        this.copyOfFinalAngularVelocity = new FrameVector3D(this.trajectoryFrame);
        this.currentTime = new YoDouble(namePrefix + "Time", this.registry);
        this.trajectoryTime = new YoDouble(namePrefix + "TrajectoryTime", this.registry);
        this.xPolynomial = new YoPolynomial(namePrefix + "PolynomialX", 6, this.registry);
        this.yPolynomial = new YoPolynomial(namePrefix + "PolynomialY", 6, this.registry);
        this.zPolynomial = new YoPolynomial(namePrefix + "PolynomialZ", 6, this.registry);
        this.xRotPolynomial = new YoPolynomial(namePrefix + "PolynomialRoll", 6, this.registry);
        this.yRotPolynomial = new YoPolynomial(namePrefix + "PolynomialPitch", 6, this.registry);
        this.zRotPolynomial = new YoPolynomial(namePrefix + "PolynomialYaw", 6, this.registry);
        this.interpolationFrame = new ReferenceFrame("interPolationFrame", ReferenceFrame.getWorldFrame()){
            private final FrameQuaternion localFrameOrientation;
            private final RotationMatrix localRotation;
            {
                this.localFrameOrientation = new FrameQuaternion();
                this.localRotation = new RotationMatrix();
            }

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                this.localFrameOrientation.setIncludingFrame((FrameQuaternionReadOnly)VelocityConstrainedPoseTrajectoryGenerator.this.initialOrientation);
                this.localFrameOrientation.changeFrame(this.getParent());
                this.localRotation.set((Orientation3DReadOnly)this.localFrameOrientation);
                transformToParent.setRotationAndZeroTranslation((RotationMatrixReadOnly)this.localRotation);
            }
        };
        this.finalFrame = new ReferenceFrame("finalFrame", ReferenceFrame.getWorldFrame()){
            private final FrameQuaternion localFrameOrientation;
            private final RotationMatrix localRotation;
            {
                this.localFrameOrientation = new FrameQuaternion();
                this.localRotation = new RotationMatrix();
            }

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                this.localFrameOrientation.setIncludingFrame((FrameQuaternionReadOnly)VelocityConstrainedPoseTrajectoryGenerator.this.initialOrientation);
                this.localFrameOrientation.changeFrame(this.getParent());
                this.localRotation.set((Orientation3DReadOnly)this.localFrameOrientation);
                transformToParent.setRotationAndZeroTranslation((RotationMatrixReadOnly)this.localRotation);
            }
        };
        this.currentTrajectoryFrame = new ReferenceFrame("currentTrajectoryFrame", this.interpolationFrame){
            private final FrameQuaternion localFrameOrientation;
            private final RotationMatrix localRotation;
            {
                this.localFrameOrientation = new FrameQuaternion();
                this.localRotation = new RotationMatrix();
            }

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                this.localFrameOrientation.setIncludingFrame((FrameQuaternionReadOnly)VelocityConstrainedPoseTrajectoryGenerator.this.currentPose.getOrientation());
                this.localFrameOrientation.changeFrame(this.getParent());
                this.localRotation.set((Orientation3DReadOnly)this.localFrameOrientation);
                transformToParent.setRotationAndZeroTranslation((RotationMatrixReadOnly)this.localRotation);
            }
        };
        this.interpolationFrameForViz = new YoFrameYawPitchRoll(namePrefix + "InterpolationFrameForViz", worldFrame, this.registry);
        parentRegistry.addChild(this.registry);
        boolean bl = this.visualize = visualize && yoGraphicsListRegistry != null;
        if (this.visualize) {
            YoFramePoint3D currentPositionInWorld = new YoFramePoint3D(namePrefix + "CurrentPosition", "WorldViz", ReferenceFrame.getWorldFrame(), this.registry);
            this.visualizationUpdatables.add((ImmutablePair<FrameTuple3DReadOnly, FixedFrameTuple3DBasics>)new ImmutablePair((Object)this.currentPose.getPosition(), (Object)currentPositionInWorld));
            YoFramePoint3D initialPositionInWorld = new YoFramePoint3D(namePrefix + "InitialPosition", "WorldViz", ReferenceFrame.getWorldFrame(), this.registry);
            this.visualizationUpdatables.add((ImmutablePair<FrameTuple3DReadOnly, FixedFrameTuple3DBasics>)new ImmutablePair((Object)this.initialPosition, (Object)initialPositionInWorld));
            YoFramePoint3D finalPositionInWorld = new YoFramePoint3D(namePrefix + "FinalPosition", "WorldViz", ReferenceFrame.getWorldFrame(), this.registry);
            this.visualizationUpdatables.add((ImmutablePair<FrameTuple3DReadOnly, FixedFrameTuple3DBasics>)new ImmutablePair((Object)this.finalPosition, (Object)finalPositionInWorld));
            YoFrameVector3D currentLinearVelocityInWorld = new YoFrameVector3D(namePrefix + "CurrentLinearVelocity", "WorldViz", ReferenceFrame.getWorldFrame(), this.registry);
            this.visualizationUpdatables.add((ImmutablePair<FrameTuple3DReadOnly, FixedFrameTuple3DBasics>)new ImmutablePair((Object)this.currentVelocity, (Object)currentLinearVelocityInWorld));
            final YoGraphicVector currentVelocityViz = new YoGraphicVector(namePrefix + "CurrentVelocity", currentPositionInWorld, currentLinearVelocityInWorld, 0.2, YoAppearance.Chartreuse());
            YoFrameVector3D currentAngularVelocityInWorld = new YoFrameVector3D(namePrefix + "CurrentAngularVelocity", "WorldViz", ReferenceFrame.getWorldFrame(), this.registry);
            this.visualizationUpdatables.add((ImmutablePair<FrameTuple3DReadOnly, FixedFrameTuple3DBasics>)new ImmutablePair((Object)this.currentAngularVelocity, (Object)currentAngularVelocityInWorld));
            final YoGraphicVector currentAngularVelocityViz = new YoGraphicVector(namePrefix + "CurrentAngularVelocity", currentPositionInWorld, currentAngularVelocityInWorld, 0.2, YoAppearance.Green());
            YoGraphicCoordinateSystem interpolationCoordinateSystemViz = new YoGraphicCoordinateSystem(namePrefix + "interpolationCoordinateSystem", initialPositionInWorld, this.interpolationFrameForViz, 0.3, YoAppearance.Black());
            YoGraphicCoordinateSystem currentPoseViz = new YoGraphicCoordinateSystem(namePrefix + "CurrentPose", currentPositionInWorld, this.currentOrientationForViz, 0.3);
            this.yoGraphicsList = new YoGraphicsList(namePrefix + "VelocityConstrainedTrajectory");
            this.yoGraphicsList.add((YoGraphic)currentVelocityViz);
            this.yoGraphicsList.add((YoGraphic)currentPoseViz);
            this.yoGraphicsList.add((YoGraphic)currentAngularVelocityViz);
            this.yoGraphicsList.add((YoGraphic)interpolationCoordinateSystemViz);
            yoGraphicsListRegistry.registerYoGraphicsList(this.yoGraphicsList);
            this.bagOfBalls = new BagOfBalls(50, 0.01, this.yoGraphicsList.getLabel(), this.registry, yoGraphicsListRegistry);
            this.showViz = new YoBoolean(namePrefix + "ShowViz", this.registry);
            this.showViz.addListener(new YoVariableChangedListener(){

                public void changed(YoVariable v) {
                    boolean visible = VelocityConstrainedPoseTrajectoryGenerator.this.showViz.getBooleanValue();
                    currentVelocityViz.setVisible(visible);
                    currentAngularVelocityViz.setVisible(visible);
                    VelocityConstrainedPoseTrajectoryGenerator.this.bagOfBalls.setVisible(visible);
                }
            });
            this.showViz.notifyListeners();
        } else {
            this.yoGraphicsList = null;
            this.bagOfBalls = null;
            this.showViz = null;
        }
    }

    public void changeFrame(ReferenceFrame referenceFrame) {
        this.initialPosition.changeFrame(referenceFrame);
        this.initialVelocity.changeFrame(referenceFrame);
        this.finalPosition.changeFrame(referenceFrame);
        this.finalVelocity.changeFrame(referenceFrame);
        this.currentPose.changeFrame(referenceFrame);
        this.currentVelocity.changeFrame(referenceFrame);
        this.currentAcceleration.changeFrame(referenceFrame);
        this.initialOrientation.changeFrame(referenceFrame);
        this.initialAngularVelocity.changeFrame(referenceFrame);
        this.finalOrientation.changeFrame(referenceFrame);
        this.finalAngularVelocity.changeFrame(referenceFrame);
        this.currentAngularVelocity.changeFrame(referenceFrame);
        this.currentAngularAcceleration.changeFrame(referenceFrame);
    }

    public void switchTrajectoryFrame(ReferenceFrame referenceFrame) {
        this.initialPosition.setToZero(referenceFrame);
        this.initialVelocity.setToZero(referenceFrame);
        this.finalPosition.setToZero(referenceFrame);
        this.finalVelocity.setToZero(referenceFrame);
        this.currentPose.setToZero(referenceFrame);
        this.currentVelocity.setToZero(referenceFrame);
        this.currentAcceleration.setToZero(referenceFrame);
        this.initialOrientation.setToZero(referenceFrame);
        this.initialAngularVelocity.setToZero(referenceFrame);
        this.finalOrientation.setToZero(referenceFrame);
        this.finalAngularVelocity.setToZero(referenceFrame);
        this.currentAngularVelocity.setToZero(referenceFrame);
        this.currentAngularAcceleration.setToZero(referenceFrame);
    }

    public void setTrajectoryTime(double newTrajectoryTime) {
        this.trajectoryTime.set(newTrajectoryTime);
    }

    public void setInitialPoseWithInitialVelocity(FramePose3D initialPose, FrameVector3D initialVelocity, FrameVector3D initialAngularVelocity) {
        initialPose.get((FrameTuple3DBasics)this.tempPosition, (FrameOrientation3DBasics)this.tempOrientation);
        this.initialPosition.set((FrameTuple3DReadOnly)this.tempPosition);
        this.initialVelocity.set((FrameTuple3DReadOnly)initialVelocity);
        this.initialOrientation.set((FrameQuaternionReadOnly)this.tempOrientation);
        this.initialAngularVelocity.set((FrameTuple3DReadOnly)initialAngularVelocity);
    }

    public void setInitialPoseWithoutInitialVelocity(FramePose3D initialPose) {
        initialPose.get((FrameTuple3DBasics)this.tempPosition, (FrameOrientation3DBasics)this.tempOrientation);
        this.initialPosition.set((FrameTuple3DReadOnly)this.tempPosition);
        this.initialVelocity.setToZero();
        this.initialOrientation.set((FrameQuaternionReadOnly)this.tempOrientation);
        this.initialAngularVelocity.setToZero();
    }

    public void setInitialPoseWithInitialVelocity(FramePoint3D initialPosition, FrameVector3D initialVelocity, FrameQuaternion initialOrientation, FrameVector3D initialAngularVelocity) {
        this.initialPosition.set((FrameTuple3DReadOnly)initialPosition);
        this.initialVelocity.set((FrameTuple3DReadOnly)initialVelocity);
        this.initialOrientation.set((FrameQuaternionReadOnly)initialOrientation);
        this.initialAngularVelocity.set((FrameTuple3DReadOnly)initialAngularVelocity);
    }

    public void setInitialPoseWithoutInitialVelocity(FramePoint3D initialPosition, FrameQuaternion initialOrientation) {
        this.initialPosition.set((FrameTuple3DReadOnly)initialPosition);
        this.initialVelocity.setToZero();
        this.initialOrientation.set((FrameQuaternionReadOnly)initialOrientation);
        this.initialAngularVelocity.setToZero();
    }

    public void setFinalPoseWithoutFinalVelocity(FramePose3D finalPose) {
        finalPose.get((FrameTuple3DBasics)this.tempPosition, (FrameOrientation3DBasics)this.tempOrientation);
        this.setFinalPoseWithoutFinalVelocity(this.tempPosition, this.tempOrientation);
    }

    public void setFinalPoseWithoutFinalVelocity(FramePoint3D finalPosition, FrameQuaternion finalOrientation) {
        this.finalPosition.set((FrameTuple3DReadOnly)finalPosition);
        this.finalOrientation.set((FrameQuaternionReadOnly)finalOrientation);
        this.finalPositionForViz.setMatchingFrame((FrameTuple3DReadOnly)finalPosition);
        this.finalOrientationForViz.setMatchingFrame((FrameOrientation3DReadOnly)finalOrientation);
        this.finalVelocity.setToZero();
        this.finalAngularVelocity.setToZero();
    }

    public void initialize() {
        this.interpolationFrame.update();
        this.finalFrame.update();
        this.copyOfInitialOrientation.setToZero(this.interpolationFrame);
        this.copyOfInitialOrientation.changeFrame(worldFrame);
        this.interpolationFrameForViz.set((FrameOrientation3DReadOnly)this.copyOfInitialOrientation);
        this.trajectoryFrame = this.initialOrientation.getReferenceFrame();
        MathTools.checkIntervalContains((double)this.trajectoryTime.getDoubleValue(), (double)0.0, (double)Double.POSITIVE_INFINITY);
        this.xPolynomial.setQuintic(0.0, this.trajectoryTime.getDoubleValue(), this.initialPosition.getX(), this.initialVelocity.getX(), 0.0, this.finalPosition.getX(), this.finalVelocity.getX(), 0.0);
        this.yPolynomial.setQuintic(0.0, this.trajectoryTime.getDoubleValue(), this.initialPosition.getY(), this.initialVelocity.getY(), 0.0, this.finalPosition.getY(), this.finalVelocity.getY(), 0.0);
        this.zPolynomial.setQuintic(0.0, this.trajectoryTime.getDoubleValue(), this.initialPosition.getZ(), this.initialVelocity.getZ(), 0.0, this.finalPosition.getZ(), this.finalVelocity.getZ(), 0.0);
        this.copyOfInitialOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.initialOrientation);
        this.copyOfFinalOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.finalOrientation);
        this.copyOfInitialAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.initialAngularVelocity);
        this.copyOfFinalAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.finalAngularVelocity);
        this.copyOfInitialOrientation.changeFrame(this.interpolationFrame);
        this.copyOfFinalOrientation.changeFrame(this.interpolationFrame);
        this.copyOfInitialAngularVelocity.changeFrame(this.interpolationFrame);
        this.copyOfFinalAngularVelocity.changeFrame(this.interpolationFrame);
        this.tempAxisAngle.set((Orientation3DReadOnly)this.copyOfFinalOrientation);
        this.xRotPolynomial.setQuintic(0.0, this.trajectoryTime.getDoubleValue(), 0.0, this.copyOfInitialAngularVelocity.getX(), 0.0, this.tempAxisAngle.getX() * this.tempAxisAngle.getAngle(), this.copyOfFinalAngularVelocity.getX(), 0.0);
        this.yRotPolynomial.setQuintic(0.0, this.trajectoryTime.getDoubleValue(), 0.0, this.copyOfInitialAngularVelocity.getY(), 0.0, this.tempAxisAngle.getY() * this.tempAxisAngle.getAngle(), this.copyOfFinalAngularVelocity.getY(), 0.0);
        this.zRotPolynomial.setQuintic(0.0, this.trajectoryTime.getDoubleValue(), 0.0, this.copyOfInitialAngularVelocity.getZ(), 0.0, this.tempAxisAngle.getZ() * this.tempAxisAngle.getAngle(), this.copyOfFinalAngularVelocity.getZ(), 0.0);
        this.reset();
        if (this.visualize) {
            this.visualizeTrajectory();
        }
    }

    private void reset() {
        this.currentTime.set(0.0);
        this.currentPose.getPosition().set((FrameTuple3DReadOnly)this.initialPosition);
        this.currentPose.getOrientation().set((FrameQuaternionReadOnly)this.initialOrientation);
        this.currentVelocity.set((FrameTuple3DReadOnly)this.initialVelocity);
        this.currentAcceleration.setToZero();
        this.currentAngularVelocity.set((FrameTuple3DReadOnly)this.initialAngularVelocity);
        this.currentAngularAcceleration.setToZero();
    }

    public void compute(double time) {
        this.currentTime.set(time);
        this.currentTrajectoryFrame.update();
        time = MathTools.clamp((double)time, (double)0.0, (double)this.trajectoryTime.getDoubleValue());
        this.xPolynomial.compute(time);
        this.yPolynomial.compute(time);
        this.zPolynomial.compute(time);
        this.xRotPolynomial.compute(time);
        this.yRotPolynomial.compute(time);
        this.zRotPolynomial.compute(time);
        if (!this.isDone()) {
            this.currentPose.getPosition().set(this.xPolynomial.getValue(), this.yPolynomial.getValue(), this.zPolynomial.getValue());
            this.currentVelocity.set(this.xPolynomial.getVelocity(), this.yPolynomial.getVelocity(), this.zPolynomial.getVelocity());
            this.currentAcceleration.set(this.xPolynomial.getAcceleration(), this.yPolynomial.getAcceleration(), this.zPolynomial.getAcceleration());
            this.tempVector.set(this.xRotPolynomial.getValue(), this.yRotPolynomial.getValue(), this.zRotPolynomial.getValue());
            this.vectorLength = this.tempVector.length();
            if (this.vectorLength > 0.0) {
                this.tempVector.normalize();
                this.tempAxisAngle.set(this.tempVector.getX(), this.tempVector.getY(), this.tempVector.getZ(), this.vectorLength);
            } else {
                this.tempAxisAngle.set(1.0, 0.0, 0.0, 0.0);
            }
            this.tempCurrentOrientation.setIncludingFrame(this.interpolationFrame, (Orientation3DReadOnly)this.tempAxisAngle);
            this.tempCurrentOrientation.changeFrame(this.trajectoryFrame);
            this.currentPose.getOrientation().set((FrameQuaternionReadOnly)this.tempCurrentOrientation);
            this.xRotPolynomial.compute(time + 5.0E-6);
            this.yRotPolynomial.compute(time + 5.0E-6);
            this.zRotPolynomial.compute(time + 5.0E-6);
            this.tempVector.set(this.xRotPolynomial.getValue(), this.yRotPolynomial.getValue(), this.zRotPolynomial.getValue());
            this.vectorLength = this.tempVector.length();
            if (this.vectorLength > 0.0) {
                this.tempVector.normalize();
                this.tempAxisAngle.set(this.tempVector.getX(), this.tempVector.getY(), this.tempVector.getZ(), this.vectorLength);
            } else {
                this.tempAxisAngle.set(1.0, 0.0, 0.0, 0.0);
            }
            this.tempCurrentOrientation.setIncludingFrame(this.interpolationFrame, (Orientation3DReadOnly)this.tempAxisAngle);
            this.tempCurrentOrientation.changeFrame(worldFrame);
            this.quatFD3.set((QuaternionReadOnly)this.tempCurrentOrientation);
            this.xRotPolynomial.compute(time - 5.0E-6);
            this.yRotPolynomial.compute(time - 5.0E-6);
            this.zRotPolynomial.compute(time - 5.0E-6);
            this.tempVector.set(this.xRotPolynomial.getValue(), this.yRotPolynomial.getValue(), this.zRotPolynomial.getValue());
            this.vectorLength = this.tempVector.length();
            if (this.vectorLength > 0.0) {
                this.tempVector.normalize();
            }
            this.tempAxisAngle.set(this.tempVector.getX(), this.tempVector.getY(), this.tempVector.getZ(), this.vectorLength);
            this.tempCurrentOrientation.setIncludingFrame(this.interpolationFrame, (Orientation3DReadOnly)this.tempAxisAngle);
            this.tempCurrentOrientation.changeFrame(worldFrame);
            this.quatFD1.set((QuaternionReadOnly)this.tempCurrentOrientation);
            this.quatFD1.inverse();
            this.quatFDDelta.multiply((QuaternionReadOnly)this.quatFD3, (QuaternionReadOnly)this.quatFD1);
            this.quatFDDelta.normalize();
            this.deltaAngle = Math.acos(this.quatFDDelta.getS()) * 2.0;
            this.omegaFD = this.deltaAngle / 1.0E-5;
            this.omegaVectorDF.setIncludingFrame(worldFrame, this.quatFDDelta.getX(), this.quatFDDelta.getY(), this.quatFDDelta.getZ());
            if (this.omegaVectorDF.length() > 0.0) {
                this.omegaVectorDF.normalize();
            }
            this.omegaVectorDF.scale(this.omegaFD);
            this.tempCurrentAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.omegaVectorDF);
            this.tempCurrentAngularVelocity.changeFrame(this.trajectoryFrame);
            this.currentAngularVelocity.set((FrameTuple3DReadOnly)this.tempCurrentAngularVelocity);
        } else {
            this.currentPose.getPosition().set((FrameTuple3DReadOnly)this.finalPosition);
            this.currentVelocity.set((FrameTuple3DReadOnly)this.finalVelocity);
            this.currentAcceleration.set(0.0, 0.0, 0.0);
            this.currentPose.getOrientation().set((FrameQuaternionReadOnly)this.finalOrientation);
            this.currentAngularVelocity.set((FrameTuple3DReadOnly)this.finalAngularVelocity);
            this.currentAcceleration.set(0.0, 0.0, 0.0);
        }
        this.currentOrientationForViz.set((Orientation3DReadOnly)this.currentTrajectoryFrame.getTransformToWorldFrame().getRotation());
        for (int i = 0; i < this.visualizationUpdatables.size(); ++i) {
            ((FixedFrameTuple3DBasics)this.visualizationUpdatables.get(i).getRight()).setMatchingFrame((FrameTuple3DReadOnly)this.visualizationUpdatables.get(i).getLeft());
        }
    }

    private void visualizeTrajectory() {
        for (int i = 0; i < 50; ++i) {
            double t = (double)i / 49.0 * this.trajectoryTime.getDoubleValue();
            this.compute(t);
            this.ballPosition.setIncludingFrame((FrameTuple3DReadOnly)this.currentPose.getPosition());
            this.ballPosition.changeFrame(ReferenceFrame.getWorldFrame());
            this.currentOrientationForViz.set((FrameOrientation3DReadOnly)this.currentPose.getOrientation());
            this.bagOfBalls.setBallLoop((FramePoint3DReadOnly)this.ballPosition);
        }
        this.reset();
    }

    public void showVisualization() {
        if (!this.visualize) {
            return;
        }
        this.showViz.set(true);
    }

    public void hideVisualization() {
        if (!this.visualize) {
            return;
        }
        this.showViz.set(false);
    }

    public FrameVector3DReadOnly getVelocity() {
        return this.currentVelocity;
    }

    public FrameVector3DReadOnly getAcceleration() {
        return this.currentAcceleration;
    }

    public FrameVector3DReadOnly getAngularVelocity() {
        return this.currentAngularVelocity;
    }

    public FrameVector3DReadOnly getAngularAcceleration() {
        return this.currentAngularAcceleration;
    }

    public FramePose3DReadOnly getPose() {
        return this.currentPose;
    }

    public boolean isDone() {
        return this.currentTime.getDoubleValue() >= this.trajectoryTime.getDoubleValue();
    }

    public String toString() {
        String ret = "";
        ret = ret + "Current time: " + this.currentTime.getDoubleValue() + ", trajectory time: " + this.trajectoryTime.getDoubleValue();
        ret = ret + "\nCurrent pose: " + this.currentPose;
        ret = ret + "\nCurrent velocity: " + this.currentVelocity;
        ret = ret + "\nCurrent acceleration: " + this.currentAcceleration;
        ret = ret + "\nCurrent angular velocity: " + this.currentAngularVelocity;
        ret = ret + "\nCurrent angular acceleration: " + this.currentAngularAcceleration;
        return ret;
    }
}

