/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.trajectories;

import java.util.List;
import us.ihmc.commonWalkingControlModules.trajectories.PositionOptimizedTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.trajectories.SwingGenerator;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.trajectories.TrajectoryType;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class TwoWaypointSwingGenerator
implements SwingGenerator {
    private static final int maxTimeIterations = -1;
    private static final int defaultNumberOfWaypoints = 2;
    private static final double[] defaultWaypointProportions = new double[]{0.15, 0.85};
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry;
    private final ReferenceFrame trajectoryFrame;
    private final YoDouble stepTime;
    private final YoDouble timeIntoStep;
    private final YoBoolean isDone;
    private final YoDouble swingHeight;
    private final YoDouble minSwingHeight;
    private final YoDouble maxSwingHeight;
    private final YoDouble defaultSwingHeight;
    private final YoDouble customWaypointAngleThreshold;
    private final double[] waypointProportions = new double[2];
    private TrajectoryType trajectoryType;
    private final PositionOptimizedTrajectoryGenerator trajectory;
    private final FramePoint3D initialPosition = new FramePoint3D();
    private final FrameVector3D initialVelocity = new FrameVector3D();
    private final FramePoint3D finalPosition = new FramePoint3D();
    private final FrameVector3D finalVelocity = new FrameVector3D();
    private final RecyclingArrayList<FramePoint3D> waypointPositions;
    private final FramePoint3D stanceFootPosition = new FramePoint3D();
    private final FrameVector3D interWaypointDisplacement = new FrameVector3D();
    private final FrameVector3D startToWaypointDisplacement = new FrameVector3D();
    private final FrameVector3D desiredVelocity = new FrameVector3D();
    private final FrameVector3D desiredAcceleration = new FrameVector3D();
    private final Vector3D initialPositionWeight = new Vector3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final Vector3D initialVelocityWeight = new Vector3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final Vector3D finalPositionWeight = new Vector3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final Vector3D finalVelocityWeight = new Vector3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final FrameVector3D initialVelocityNoTimeDimension = new FrameVector3D();
    private final FrameVector3D finalVelocityNoTimeDimension = new FrameVector3D();
    private final FrameVector3D tempWaypointVelocity;
    private final FramePoint3D tempPoint3D = new FramePoint3D();
    private final BagOfBalls waypointViz;
    private RobotSide swingSide = null;
    private ReferenceFrame stanceZUpFrame = null;
    private final Vector2D swingOffset = new Vector2D();
    private final YoDouble minDistanceToStance;
    private final YoBoolean needToAdjustedSwingForSelfCollision;
    private final YoBoolean crossOverStep;
    private boolean visualize = true;
    private final FrameVector2D xyDistanceToStance = new FrameVector2D();
    private final Point2D stance2D = new Point2D();
    private final Point2D pointA2D = new Point2D();
    private final Point2D pointB2D = new Point2D();
    private final FramePoint2D pointAInStance = new FramePoint2D();
    private final FramePoint2D pointBInStance = new FramePoint2D();
    private final Point2D tempPoint = new Point2D();

    public TwoWaypointSwingGenerator(String namePrefix, double minSwingHeight, double maxSwingHeight, double defaultSwingHeight, double customWaypointAngleThreshold, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(namePrefix, minSwingHeight, maxSwingHeight, defaultSwingHeight, customWaypointAngleThreshold, worldFrame, parentRegistry, yoGraphicsListRegistry);
    }

    public TwoWaypointSwingGenerator(String namePrefix, double minSwingHeight, double maxSwingHeight, double defaultSwingHeight, double customWaypointAngleThreshold, ReferenceFrame trajectoryFrame, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.trajectoryFrame = trajectoryFrame;
        this.waypointPositions = new RecyclingArrayList(12, this::createNewWaypoint);
        this.tempWaypointVelocity = new FrameVector3D(trajectoryFrame);
        this.stepTime = new YoDouble(namePrefix + "StepTime", this.registry);
        this.timeIntoStep = new YoDouble(namePrefix + "TimeIntoStep", this.registry);
        this.isDone = new YoBoolean(namePrefix + "IsDone", this.registry);
        this.swingHeight = new YoDouble(namePrefix + "SwingHeight", this.registry);
        this.swingHeight.set(minSwingHeight);
        this.maxSwingHeight = new YoDouble(namePrefix + "MaxSwingHeight", this.registry);
        this.maxSwingHeight.set(maxSwingHeight);
        this.minSwingHeight = new YoDouble(namePrefix + "MinSwingHeight", this.registry);
        this.minSwingHeight.set(minSwingHeight);
        this.defaultSwingHeight = new YoDouble(namePrefix + "DefaultSwingHeight", this.registry);
        this.defaultSwingHeight.set(defaultSwingHeight);
        this.minDistanceToStance = new YoDouble(namePrefix + "MinDistanceToStance", this.registry);
        this.minDistanceToStance.set(Double.NEGATIVE_INFINITY);
        this.customWaypointAngleThreshold = new YoDouble(namePrefix + "customWaypointAngleThreshold", this.registry);
        this.customWaypointAngleThreshold.set(customWaypointAngleThreshold);
        for (int i = 0; i < 2; ++i) {
            this.waypointProportions[i] = defaultWaypointProportions[i];
        }
        this.trajectory = new PositionOptimizedTrajectoryGenerator(namePrefix, this.registry, yoGraphicsListRegistry, -1, 12, trajectoryFrame);
        this.waypointViz = yoGraphicsListRegistry != null ? new BagOfBalls(12, 0.02, namePrefix + "Waypoints", YoAppearance.White(), this.registry, yoGraphicsListRegistry) : null;
        this.needToAdjustedSwingForSelfCollision = new YoBoolean(namePrefix + "AdjustedSwing", this.registry);
        this.crossOverStep = new YoBoolean(namePrefix + "CrossOverStep", this.registry);
    }

    @Override
    public void setStepTime(double stepTime) {
        this.stepTime.set(stepTime);
    }

    @Override
    public void setInitialConditions(FramePoint3DReadOnly initialPosition, FrameVector3DReadOnly initialVelocity) {
        this.initialPosition.setIncludingFrame((FrameTuple3DReadOnly)initialPosition);
        this.initialVelocity.setIncludingFrame((FrameTuple3DReadOnly)initialVelocity);
    }

    public void setInitialConditionWeights(Tuple3DReadOnly initialPositionWeight, Tuple3DReadOnly initialVelocityWeight) {
        if (initialPositionWeight == null) {
            this.initialPositionWeight.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        } else {
            this.initialPositionWeight.set(initialPositionWeight);
        }
        if (initialVelocityWeight == null) {
            this.initialVelocityWeight.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        } else {
            this.initialVelocityWeight.set(initialVelocityWeight);
        }
    }

    @Override
    public void setFinalConditions(FramePoint3DReadOnly finalPosition, FrameVector3DReadOnly finalVelocity) {
        this.finalPosition.setIncludingFrame((FrameTuple3DReadOnly)finalPosition);
        this.finalVelocity.setIncludingFrame((FrameTuple3DReadOnly)finalVelocity);
    }

    public void setFinalConditionWeights(Tuple3DReadOnly finalPositionWeight, Tuple3DReadOnly finalVelocityWeight) {
        if (finalPositionWeight == null) {
            this.finalPositionWeight.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        } else {
            this.finalPositionWeight.set(finalPositionWeight);
        }
        if (finalVelocityWeight == null) {
            this.finalVelocityWeight.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        } else {
            this.finalVelocityWeight.set(finalVelocityWeight);
        }
    }

    @Override
    public void setTrajectoryType(TrajectoryType trajectoryType, RecyclingArrayList<FramePoint3D> waypoints) {
        if (trajectoryType == TrajectoryType.CUSTOM && waypoints == null) {
            LogTools.warn((String)"Received no waypoints but trajectory type is custom. Using default trajectory.");
            this.trajectoryType = TrajectoryType.DEFAULT;
        } else if (trajectoryType == TrajectoryType.CUSTOM && (waypoints.isEmpty() || waypoints.size() > 12)) {
            LogTools.warn((String)"Received unexpected amount of waypoints. Using default trajectory.");
            this.trajectoryType = TrajectoryType.DEFAULT;
        } else {
            this.trajectoryType = trajectoryType;
        }
        if (this.trajectoryType != TrajectoryType.CUSTOM) {
            return;
        }
        int initialWaypointIndex = this.computeStartingWaypointIndex(waypoints);
        this.waypointPositions.clear();
        for (int i = initialWaypointIndex; i < waypoints.size(); ++i) {
            FramePoint3D waypoint = (FramePoint3D)waypoints.get(i);
            FramePoint3D waypointToSet = (FramePoint3D)this.waypointPositions.add();
            waypointToSet.setIncludingFrame((FrameTuple3DReadOnly)waypoint);
            waypointToSet.changeFrame(this.trajectoryFrame);
        }
    }

    private int computeStartingWaypointIndex(RecyclingArrayList<FramePoint3D> waypoints) {
        if (waypoints.size() <= 2) {
            return 0;
        }
        this.initialPosition.changeFrame(ReferenceFrame.getWorldFrame());
        this.finalPosition.changeFrame(ReferenceFrame.getWorldFrame());
        double minimumDotProduct = Math.cos(this.customWaypointAngleThreshold.getValue());
        for (int i = 0; i < waypoints.size(); ++i) {
            FramePoint3D waypoint = (FramePoint3D)waypoints.get(i);
            FramePoint3D nextWaypoint = i == waypoints.size() - 1 ? this.finalPosition : (FramePoint3D)waypoints.get(i + 1);
            this.startToWaypointDisplacement.sub((FrameTuple3DReadOnly)waypoint, (FrameTuple3DReadOnly)this.initialPosition);
            this.interWaypointDisplacement.sub((FrameTuple3DReadOnly)nextWaypoint, (FrameTuple3DReadOnly)waypoint);
            this.startToWaypointDisplacement.normalize();
            this.interWaypointDisplacement.normalize();
            double dotProduct = this.startToWaypointDisplacement.dot((FrameVector3DReadOnly)this.interWaypointDisplacement);
            if (!(dotProduct > minimumDotProduct)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void setSwingHeight(double swingHeight) {
        boolean useDefaultSwing;
        boolean bl = useDefaultSwing = Double.isNaN(swingHeight) || swingHeight <= 0.0;
        if (useDefaultSwing) {
            this.swingHeight.set(this.defaultSwingHeight.getDoubleValue());
        } else {
            this.swingHeight.set(MathTools.clamp((double)swingHeight, (double)this.minSwingHeight.getDoubleValue(), (double)this.maxSwingHeight.getDoubleValue()));
        }
    }

    @Override
    public void setStanceFootPosition(FramePoint3DReadOnly stanceFootPosition) {
        this.stanceFootPosition.setIncludingFrame((FrameTuple3DReadOnly)stanceFootPosition);
    }

    public void informDone() {
        this.trajectory.informDone();
    }

    @Override
    public void setWaypointProportions(double[] waypointProportions) {
        this.setWaypointProportions(waypointProportions[0], waypointProportions[1]);
    }

    public void setWaypointProportions(double waypointProportions0, double waypointProportions1) {
        this.waypointProportions[0] = waypointProportions0;
        this.waypointProportions[1] = waypointProportions1;
    }

    public void initialize() {
        this.timeIntoStep.set(0.0);
        this.isDone.set(false);
        this.initialPosition.changeFrame(this.trajectoryFrame);
        this.finalPosition.changeFrame(this.trajectoryFrame);
        this.stanceFootPosition.changeFrame(this.trajectoryFrame);
        this.needToAdjustedSwingForSelfCollision.set(this.computeSwingAdjustment(this.initialPosition, this.finalPosition, this.stanceFootPosition, this.swingOffset));
        double maxStepZ = Math.max(this.initialPosition.getZ(), this.finalPosition.getZ());
        switch (this.trajectoryType) {
            case OBSTACLE_CLEARANCE: {
                int i;
                this.waypointPositions.clear();
                for (i = 0; i < 2; ++i) {
                    this.waypointPositions.add();
                    ((FramePoint3D)this.waypointPositions.get(i)).interpolate((FrameTuple3DReadOnly)this.initialPosition, (FrameTuple3DReadOnly)this.finalPosition, this.waypointProportions[i]);
                    ((FramePoint3D)this.waypointPositions.get(i)).setZ(maxStepZ + this.swingHeight.getDoubleValue());
                    if (!this.needToAdjustedSwingForSelfCollision.getBooleanValue()) continue;
                    ((FramePoint3D)this.waypointPositions.get(i)).add(this.swingOffset.getX(), this.swingOffset.getY(), 0.0);
                }
                break;
            }
            case DEFAULT: {
                int i;
                this.waypointPositions.clear();
                for (i = 0; i < 2; ++i) {
                    this.waypointPositions.add();
                    ((FramePoint3D)this.waypointPositions.get(i)).interpolate((FrameTuple3DReadOnly)this.initialPosition, (FrameTuple3DReadOnly)this.finalPosition, this.waypointProportions[i]);
                    ((FramePoint3D)this.waypointPositions.get(i)).addZ(this.swingHeight.getDoubleValue());
                    if (!this.needToAdjustedSwingForSelfCollision.getBooleanValue()) continue;
                    ((FramePoint3D)this.waypointPositions.get(i)).add(this.swingOffset.getX(), this.swingOffset.getY(), 0.0);
                }
                break;
            }
            case CUSTOM: {
                break;
            }
            default: {
                throw new RuntimeException("Trajectory type not implemented");
            }
        }
        double maxWaypointZ = this.stanceFootPosition.containsNaN() ? maxStepZ + this.maxSwingHeight.getDoubleValue() : Math.max(this.stanceFootPosition.getZ() + this.maxSwingHeight.getDoubleValue(), maxStepZ + this.minSwingHeight.getDoubleValue());
        for (int i = 0; i < this.waypointPositions.size(); ++i) {
            ((FramePoint3D)this.waypointPositions.get(i)).setZ(Math.min(((FramePoint3D)this.waypointPositions.get(i)).getZ(), maxWaypointZ));
        }
        this.initialVelocityNoTimeDimension.setIncludingFrame((FrameTuple3DReadOnly)this.initialVelocity);
        this.finalVelocityNoTimeDimension.setIncludingFrame((FrameTuple3DReadOnly)this.finalVelocity);
        this.initialVelocityNoTimeDimension.scale(this.stepTime.getDoubleValue());
        this.finalVelocityNoTimeDimension.scale(this.stepTime.getDoubleValue());
        this.trajectory.setEndpointConditions((FramePoint3DReadOnly)this.initialPosition, (FrameVector3DReadOnly)this.initialVelocityNoTimeDimension, (FramePoint3DReadOnly)this.finalPosition, (FrameVector3DReadOnly)this.finalVelocityNoTimeDimension);
        this.trajectory.setEndpointWeights((Tuple3DReadOnly)this.initialPositionWeight, (Tuple3DReadOnly)this.initialVelocityWeight, (Tuple3DReadOnly)this.finalPositionWeight, (Tuple3DReadOnly)this.finalVelocityWeight);
        this.trajectory.setWaypoints((List<? extends FramePoint3DReadOnly>)this.waypointPositions);
        this.trajectory.initialize();
        if (this.visualize) {
            this.visualize();
        } else {
            this.hide();
        }
    }

    public void setShouldVisualize(boolean visualize) {
        this.visualize = visualize;
        this.trajectory.setShouldVisualize(visualize);
    }

    private boolean computeSwingAdjustment(FramePoint3D pointA, FramePoint3D pointB, FramePoint3D stance, Vector2D offsetToPack) {
        double distance;
        if (this.swingSide == null || this.stanceZUpFrame == null) {
            offsetToPack.setToZero();
            return false;
        }
        this.pointA2D.set((Tuple3DReadOnly)pointA);
        this.pointB2D.set((Tuple3DReadOnly)pointB);
        this.stance2D.set((Tuple3DReadOnly)stance);
        EuclidGeometryTools.orthogonalProjectionOnLine2D((Point2DReadOnly)this.stance2D, (Point2DReadOnly)this.pointA2D, (Point2DReadOnly)this.pointB2D, (Point2DBasics)this.tempPoint);
        boolean smallAngleChange = !EuclidGeometryTools.isPoint2DOnLineSegment2D((Point2DReadOnly)this.tempPoint, (Point2DReadOnly)this.pointA2D, (Point2DReadOnly)this.pointB2D);
        this.xyDistanceToStance.setToZero(this.trajectoryFrame);
        this.xyDistanceToStance.sub((Tuple2DReadOnly)this.tempPoint, (Tuple2DReadOnly)this.stance2D);
        this.xyDistanceToStance.changeFrame(this.stanceZUpFrame);
        this.pointAInStance.setIncludingFrame(this.trajectoryFrame, (Tuple2DReadOnly)this.pointA2D);
        this.pointBInStance.setIncludingFrame(this.trajectoryFrame, (Tuple2DReadOnly)this.pointB2D);
        this.pointAInStance.changeFrame(this.stanceZUpFrame);
        this.pointBInStance.changeFrame(this.stanceZUpFrame);
        boolean trajectoryIntersectsY = EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)this.pointAInStance.getX(), (double)this.pointAInStance.getY(), (double)this.pointBInStance.getX(), (double)this.pointBInStance.getY(), (Point2DBasics)this.tempPoint);
        boolean crossOver = trajectoryIntersectsY && this.swingSide.negateIfRightSide(this.tempPoint.getY()) < 0.0;
        this.crossOverStep.set(crossOver);
        if (!crossOver && smallAngleChange) {
            offsetToPack.setToZero();
            return false;
        }
        if (crossOver) {
            distance = this.minDistanceToStance.getDoubleValue() + this.xyDistanceToStance.length();
            this.xyDistanceToStance.negate();
        } else {
            distance = this.minDistanceToStance.getDoubleValue() - this.xyDistanceToStance.length();
        }
        if (distance < 0.0) {
            offsetToPack.setToZero();
            return false;
        }
        this.xyDistanceToStance.changeFrame(this.trajectoryFrame);
        this.xyDistanceToStance.normalize();
        this.xyDistanceToStance.scale(distance);
        offsetToPack.set((Tuple2DReadOnly)this.xyDistanceToStance);
        return true;
    }

    public void enableStanceCollisionAvoidance(RobotSide swingSide, ReferenceFrame stanceZUpFrame, double minDistanceToStance) {
        this.swingSide = swingSide;
        this.stanceZUpFrame = stanceZUpFrame;
        this.minDistanceToStance.set(minDistanceToStance);
    }

    private void visualize() {
        if (this.waypointViz == null) {
            return;
        }
        this.tempPoint3D.setToZero(worldFrame);
        this.waypointViz.reset();
        for (int i = 0; i < this.waypointPositions.size(); ++i) {
            this.tempPoint3D.setMatchingFrame((FrameTuple3DReadOnly)this.waypointPositions.get(i));
            this.waypointViz.setBall((FramePoint3DReadOnly)this.tempPoint3D, i);
        }
    }

    public void hide() {
        if (this.waypointViz == null) {
            return;
        }
        this.waypointViz.reset();
    }

    @Override
    public boolean doOptimizationUpdate() {
        return this.trajectory.doOptimizationUpdate();
    }

    public void compute(double time) {
        double trajectoryTime = this.stepTime.getDoubleValue();
        this.isDone.set(time >= trajectoryTime);
        time = MathTools.clamp((double)time, (double)0.0, (double)trajectoryTime);
        this.timeIntoStep.set(time);
        double percent = time / trajectoryTime;
        this.trajectory.compute(percent);
    }

    public boolean isDone() {
        return this.isDone.getBooleanValue();
    }

    public FramePoint3DReadOnly getPosition() {
        return this.trajectory.getPosition();
    }

    public FrameVector3DReadOnly getVelocity() {
        this.desiredVelocity.set((FrameTuple3DReadOnly)this.trajectory.getVelocity());
        this.desiredVelocity.scale(1.0 / this.stepTime.getDoubleValue());
        return this.desiredVelocity;
    }

    public FrameVector3DReadOnly getAcceleration() {
        this.desiredAcceleration.set((FrameTuple3DReadOnly)this.trajectory.getAcceleration());
        this.desiredAcceleration.scale(1.0 / this.stepTime.getDoubleValue());
        this.desiredAcceleration.scale(1.0 / this.stepTime.getDoubleValue());
        return this.desiredAcceleration;
    }

    public void showVisualization() {
        this.trajectory.showVisualization();
    }

    public void hideVisualization() {
        this.waypointViz.hideAll();
        this.tempPoint3D.setToNaN();
        for (int i = 0; i < this.waypointPositions.size(); ++i) {
            this.waypointViz.setBall((FramePoint3DReadOnly)this.tempPoint3D, i);
        }
        this.trajectory.hideVisualization();
    }

    public static double[] getDefaultWaypointProportions() {
        return defaultWaypointProportions;
    }

    @Override
    public int getNumberOfWaypoints() {
        return this.waypointPositions.size();
    }

    @Override
    public void getWaypointData(int waypointIndex, FrameEuclideanTrajectoryPoint waypointDataToPack) {
        double waypointTime = this.getWaypointTime(waypointIndex);
        this.trajectory.getWaypointVelocity(waypointIndex, this.tempWaypointVelocity);
        this.tempWaypointVelocity.scale(1.0 / this.stepTime.getDoubleValue());
        waypointDataToPack.setToNaN(this.trajectoryFrame);
        waypointDataToPack.setTime(waypointTime);
        waypointDataToPack.setPosition((FramePoint3DReadOnly)this.waypointPositions.get(waypointIndex));
        waypointDataToPack.setLinearVelocity((FrameVector3DReadOnly)this.tempWaypointVelocity);
    }

    public void getInitialPosition(FrameVector3DBasics initialPositionToPack) {
        this.trajectory.getInitialPosition(initialPositionToPack);
        initialPositionToPack.scale(1.0 / this.stepTime.getValue());
    }

    public void getInitialVelocity(FrameVector3DBasics initialVelocityToPack) {
        this.trajectory.getInitialVelocity(initialVelocityToPack);
        initialVelocityToPack.scale(1.0 / this.stepTime.getValue());
    }

    public void getFinalPosition(FrameVector3DBasics finalPositionToPack) {
        this.trajectory.getFinalPosition(finalPositionToPack);
        finalPositionToPack.scale(1.0 / this.stepTime.getValue());
    }

    public void getFinalVelocity(FrameVector3DBasics finalVelocityToPack) {
        this.trajectory.getFinalVelocity(finalVelocityToPack);
        finalVelocityToPack.scale(1.0 / this.stepTime.getValue());
    }

    public FramePoint3DReadOnly getWaypoint(int index) {
        return (FramePoint3DReadOnly)this.waypointPositions.get(index);
    }

    public double computeAndGetMaxSpeed() {
        this.trajectory.computeMaxSpeed();
        return this.trajectory.getMaxSpeed() / this.stepTime.getDoubleValue();
    }

    public double getWaypointTime(int waypointIndex) {
        return this.stepTime.getDoubleValue() * this.trajectory.getWaypointTime(waypointIndex);
    }

    private FramePoint3D createNewWaypoint() {
        return new FramePoint3D(this.trajectoryFrame);
    }
}

