/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.trajectories;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePolynomial3DBasics;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.yoVariables.YoFramePolynomial3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SoftTouchdownPoseTrajectoryGenerator
implements FixedFramePoseTrajectoryGenerator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry;
    private final FixedFramePolynomial3DBasics positionTouchdownTrajectory;
    private final YoDouble timeInitial;
    private final YoDouble timeFinal;
    private final YoDouble timeIntoTouchdown;
    private final FramePoint3D initialPosition = new FramePoint3D();
    private final FrameVector3D initialVelocity = new FrameVector3D();
    private final FrameVector3D initialAcceleration = new FrameVector3D();
    private final FrameQuaternion constantOrientation = new FrameQuaternion();
    private final FrameVector3D constantAngularVelocity = new FrameVector3D();
    private final FrameVector3D constantAngularAcceleration = new FrameVector3D();
    private final FramePose3DReadOnly pose;

    public SoftTouchdownPoseTrajectoryGenerator(String namePrefix, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.positionTouchdownTrajectory = new YoFramePolynomial3D(namePrefix + "Trajectory", 3, worldFrame, this.registry);
        this.timeInitial = new YoDouble(namePrefix + "TimeInitial", this.registry);
        this.timeFinal = new YoDouble(namePrefix + "TimeFinal", this.registry);
        this.timeIntoTouchdown = new YoDouble(namePrefix + "TimeIntoTouchdown", this.registry);
        this.pose = new FramePose3DReadOnly(){

            public FramePoint3DReadOnly getPosition() {
                return SoftTouchdownPoseTrajectoryGenerator.this.positionTouchdownTrajectory.getPosition();
            }

            public FrameQuaternionReadOnly getOrientation() {
                return SoftTouchdownPoseTrajectoryGenerator.this.constantOrientation;
            }

            public ReferenceFrame getReferenceFrame() {
                return worldFrame;
            }
        };
        this.timeFinal.set(Double.POSITIVE_INFINITY);
    }

    public void setOrientation(FrameQuaternionReadOnly orientation) {
        this.constantOrientation.setIncludingFrame(orientation);
        this.constantAngularVelocity.setToZero(this.getReferenceFrame());
        this.constantAngularAcceleration.setToZero(this.getReferenceFrame());
    }

    public void setOrientation(FrameQuaternionReadOnly orientation, FrameVector3DReadOnly angularVelocity) {
        this.constantOrientation.setIncludingFrame(orientation);
        this.constantAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)angularVelocity);
        this.constantOrientation.changeFrame(this.getReferenceFrame());
        this.constantAngularVelocity.changeFrame(this.getReferenceFrame());
        this.constantAngularAcceleration.setToZero(this.getReferenceFrame());
    }

    public void setLinearTrajectory(double initialTime, FramePoint3DReadOnly initialPosition, FrameVector3DReadOnly initialVelocity, FrameVector3DReadOnly initialAcceleration) {
        this.timeInitial.set(initialTime);
        this.initialPosition.setIncludingFrame((FrameTuple3DReadOnly)initialPosition);
        this.initialVelocity.setIncludingFrame((FrameTuple3DReadOnly)initialVelocity);
        this.initialAcceleration.setIncludingFrame((FrameTuple3DReadOnly)initialAcceleration);
        this.initialPosition.changeFrame(this.getReferenceFrame());
        this.initialVelocity.changeFrame(this.getReferenceFrame());
        this.initialAcceleration.changeFrame(this.getReferenceFrame());
    }

    public void initialize() {
        double t0 = this.timeInitial.getDoubleValue();
        double tf = this.timeFinal.getDoubleValue();
        this.positionTouchdownTrajectory.setQuadraticUsingInitialAcceleration(t0, tf, (FramePoint3DReadOnly)this.initialPosition, (FrameVector3DReadOnly)this.initialVelocity, (FrameVector3DReadOnly)this.initialAcceleration);
    }

    public void compute(double time) {
        double clippedTime = MathTools.clamp((double)time, (double)this.timeInitial.getDoubleValue(), (double)this.timeFinal.getDoubleValue());
        this.timeIntoTouchdown.set(clippedTime - this.timeInitial.getDoubleValue());
        this.positionTouchdownTrajectory.compute(clippedTime);
    }

    public boolean isDone() {
        return false;
    }

    public FramePose3DReadOnly getPose() {
        return this.pose;
    }

    public FrameVector3DReadOnly getVelocity() {
        return this.positionTouchdownTrajectory.getVelocity();
    }

    public FrameVector3DReadOnly getAcceleration() {
        return this.positionTouchdownTrajectory.getAcceleration();
    }

    public FrameVector3DReadOnly getAngularVelocity() {
        return this.constantAngularVelocity;
    }

    public FrameVector3DReadOnly getAngularAcceleration() {
        return this.constantAngularAcceleration;
    }

    public void showVisualization() {
    }

    public void hideVisualization() {
    }
}

