/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.trajectories;

import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.robotics.math.trajectories.generators.TrajectoryPointOptimizer;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class OptimizedTrajectoryGenerator {
    private static final int dimensions = 1;
    private final String namePrefix;
    private final TrajectoryPointOptimizer optimizer;
    private final YoInteger maxIterations;
    private final RecyclingArrayList<TDoubleArrayList> coefficients;
    private final ArrayList<YoPolynomial> trajectories = new ArrayList();
    private final double[] tempCoeffs = new double[4];
    private double initialPosition;
    private double initialVelocity;
    private double finalPosition;
    private double finalVelocity;
    private final RecyclingArrayList<TDoubleArrayList> waypointPositions;
    private final TIntIntMap indexMap = new TIntIntHashMap(10, 0.5f, -1, -1);
    private final TDoubleArrayList initialPositionArray = new TDoubleArrayList(1);
    private final TDoubleArrayList initialVelocityArray = new TDoubleArrayList(1);
    private final TDoubleArrayList finalPositionArray = new TDoubleArrayList(1);
    private final TDoubleArrayList finalVelocityArray = new TDoubleArrayList(1);
    private final TDoubleArrayList waypointVelocity = new TDoubleArrayList(1);
    private final TDoubleArrayList waypointTimesArray = new TDoubleArrayList();
    private final YoRegistry registry;
    private final YoBoolean isDone;
    private final YoBoolean optimizeInOneTick;
    private final YoBoolean hasConverged;
    private final YoInteger segments;
    private final YoInteger activeSegment;
    private final ArrayList<YoDouble> waypointTimes = new ArrayList();
    private final YoDouble desiredPosition;
    private final YoDouble desiredVelocity;
    private final YoDouble desiredAcceleration;
    private final YoDouble desiredJerk;
    private final YoDouble maxSpeed;
    private final YoDouble maxSpeedTime;

    public OptimizedTrajectoryGenerator(String namePrefix, int maxIterations, int maxWaypoints, YoRegistry parentRegistry) {
        this.namePrefix = namePrefix;
        this.coefficients = new RecyclingArrayList(0, () -> {
            TDoubleArrayList ret = new TDoubleArrayList(4);
            for (int i = 0; i < 4; ++i) {
                ret.add(0.0);
            }
            return ret;
        });
        this.waypointPositions = new RecyclingArrayList(0, () -> {
            TDoubleArrayList ret = new TDoubleArrayList(1);
            for (int i = 0; i < 1; ++i) {
                ret.add(0.0);
            }
            return ret;
        });
        this.registry = new YoRegistry(namePrefix + "Trajectory");
        this.optimizer = new TrajectoryPointOptimizer(namePrefix, 1, this.registry);
        this.maxIterations = new YoInteger(namePrefix + "MaxIterations", this.registry);
        this.maxIterations.set(maxIterations);
        this.isDone = new YoBoolean(namePrefix + "IsDone", this.registry);
        this.optimizeInOneTick = new YoBoolean(namePrefix + "OptimizeInOneTick", this.registry);
        this.hasConverged = new YoBoolean(namePrefix + "HasConverged", this.registry);
        this.segments = new YoInteger(namePrefix + "Segments", this.registry);
        this.activeSegment = new YoInteger(namePrefix + "ActiveSegment", this.registry);
        this.optimizeInOneTick.set(maxIterations >= 0);
        this.hasConverged.set(this.optimizeInOneTick.getBooleanValue());
        this.maxSpeed = new YoDouble("MaxVelocity", this.registry);
        this.maxSpeedTime = new YoDouble("MaxVelocityTime", this.registry);
        this.desiredPosition = new YoDouble(namePrefix + "DesiredPosition", this.registry);
        this.desiredVelocity = new YoDouble(namePrefix + "DesiredVelocity", this.registry);
        this.desiredAcceleration = new YoDouble(namePrefix + "DesiredAcceleration", this.registry);
        this.desiredJerk = new YoDouble(namePrefix + "DesiredJerk", this.registry);
        for (int i = 0; i < 1; ++i) {
            this.initialPositionArray.add(0.0);
            this.initialVelocityArray.add(0.0);
            this.finalPositionArray.add(0.0);
            this.finalVelocityArray.add(0.0);
        }
        while (this.waypointTimes.size() <= maxWaypoints) {
            this.extendBySegment(this.registry);
        }
        this.reset();
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }

    private void extendBySegment(YoRegistry registry) {
        int size = this.waypointTimes.size() + 1;
        this.trajectories.add(new YoPolynomial(this.namePrefix + "Segment" + size, 4, registry));
        this.waypointTimes.add(new YoDouble(this.namePrefix + "WaypointTime" + size, registry));
        this.waypointPositions.add();
    }

    public void reset() {
        this.initialPosition = Double.NaN;
        this.initialVelocity = Double.NaN;
        this.finalPosition = Double.NaN;
        this.finalVelocity = Double.NaN;
        this.segments.set(1);
        this.waypointPositions.clear();
        this.optimizer.setWaypoints(this.waypointPositions);
        this.coefficients.clear();
        this.coefficients.add();
        this.waypointTimesArray.reset();
        for (int i = 0; i < this.waypointTimes.size(); ++i) {
            this.waypointTimes.get(i).setToNaN();
        }
    }

    public void setEndpointConditions(double initialPosition, double initialVelocity, double finalPosition, double finalVelocity) {
        this.initialPosition = initialPosition;
        this.initialVelocity = initialVelocity;
        this.finalPosition = finalPosition;
        this.finalVelocity = finalVelocity;
        this.initialPositionArray.set(0, this.initialPosition);
        this.initialVelocityArray.set(0, this.initialVelocity);
        this.finalPositionArray.set(0, this.finalPosition);
        this.finalVelocityArray.set(0, this.finalVelocity);
        this.optimizer.setEndPoints(this.initialPositionArray, this.initialVelocityArray, this.finalPositionArray, this.finalVelocityArray);
    }

    public void setWaypoints(TDoubleArrayList waypointPositions) {
        if (waypointPositions.size() > this.waypointTimes.size()) {
            throw new RuntimeException("Too many waypoints");
        }
        this.waypointPositions.clear();
        this.coefficients.clear();
        this.indexMap.clear();
        this.coefficients.add();
        int optimizerIndex = 0;
        for (int i = 0; i < waypointPositions.size(); ++i) {
            double waypointPosition = waypointPositions.get(i);
            this.indexMap.put(i, optimizerIndex);
            ++optimizerIndex;
            TDoubleArrayList waypoint = (TDoubleArrayList)this.waypointPositions.add();
            waypoint.set(0, waypointPosition);
            this.coefficients.add();
        }
        this.optimizer.setWaypoints(this.waypointPositions);
        this.segments.set(this.coefficients.size());
    }

    public void setWaypointTimes(TDoubleArrayList waypointTimes) {
        int i;
        if (waypointTimes.size() > this.waypointTimes.size()) {
            throw new RuntimeException("Too many waypoints");
        }
        for (i = 0; i < waypointTimes.size() - 1; ++i) {
            if (!(waypointTimes.get(i + 1) < waypointTimes.get(i))) continue;
            throw new RuntimeException("Waypoint times aren't in ascending order.");
        }
        for (i = 0; i < waypointTimes.size(); ++i) {
            double waypointTime = waypointTimes.get(i);
            this.waypointTimes.get(i).set(waypointTime);
            this.waypointTimesArray.add(waypointTime);
        }
    }

    public void initialize() {
        if (Double.isNaN(this.initialPosition)) {
            throw new RuntimeException("Does not have valid endpoint conditions. Did you call setEndpointConditions?");
        }
        if (this.optimizeInOneTick.getBooleanValue()) {
            this.optimizer.compute(this.maxIterations.getIntegerValue(), this.waypointTimesArray);
            this.hasConverged.set(true);
        } else {
            this.hasConverged.set(false);
            this.optimizer.compute(0, this.waypointTimesArray);
        }
        this.updateVariablesFromOptimizer();
    }

    private void updateVariablesFromOptimizer() {
        int i;
        for (i = 0; i < this.segments.getIntegerValue() - 1; ++i) {
            this.waypointTimes.get(i).set(this.optimizer.getWaypointTime(i));
        }
        this.waypointTimes.get(this.segments.getIntegerValue() - 1).set(1.0);
        for (i = this.segments.getIntegerValue(); i < this.waypointTimes.size(); ++i) {
            this.waypointTimes.get(i).set(Double.NaN);
        }
        this.optimizer.getPolynomialCoefficients(this.coefficients, 0);
        for (i = 0; i < this.segments.getIntegerValue(); ++i) {
            ((TDoubleArrayList)this.coefficients.get(i)).toArray(this.tempCoeffs);
            this.trajectories.get(i).setDirectlyReverse(this.tempCoeffs);
        }
        this.isDone.set(false);
    }

    public boolean doOptimizationUpdate() {
        if (!this.hasConverged.getBooleanValue()) {
            this.hasConverged.set(this.optimizer.doFullTimeUpdate());
            this.updateVariablesFromOptimizer();
        }
        return !this.hasConverged();
    }

    public void compute(double time) {
        double waypointTime;
        this.doOptimizationUpdate();
        this.isDone.set(time > 1.0);
        if (time < 0.0) {
            this.desiredPosition.set(this.initialPosition);
            this.desiredVelocity.set(0.0);
            this.desiredAcceleration.set(0.0);
            this.desiredJerk.set(0.0);
            return;
        }
        if (time > 1.0) {
            this.desiredPosition.set(this.finalPosition);
            this.desiredVelocity.set(0.0);
            this.desiredAcceleration.set(0.0);
            this.desiredJerk.set(0.0);
            return;
        }
        time = MathTools.clamp((double)time, (double)0.0, (double)1.0);
        int activeSegment = 0;
        for (int i = 0; i < this.segments.getIntegerValue() - 1 && time > (waypointTime = this.waypointTimes.get(i).getDoubleValue()); ++i) {
            activeSegment = i + 1;
        }
        this.activeSegment.set(activeSegment);
        YoPolynomial polynomial = this.trajectories.get(activeSegment);
        polynomial.compute(time);
        this.desiredPosition.set(polynomial.getValue());
        this.desiredVelocity.set(polynomial.getVelocity());
        this.desiredAcceleration.set(polynomial.getAcceleration());
        this.desiredJerk.set(polynomial.getJerk());
    }

    public double getWaypointTime(int waypointIndex) {
        return this.optimizer.getWaypointTime(this.indexMap.get(waypointIndex));
    }

    public double getWaypointVelocity(int waypointIndex) {
        this.optimizer.getWaypointVelocity(this.waypointVelocity, this.indexMap.get(waypointIndex));
        return this.waypointVelocity.get(0);
    }

    public boolean isDone() {
        return this.isDone.getBooleanValue();
    }

    public double getPosition() {
        return this.desiredPosition.getDoubleValue();
    }

    public double getVelocity() {
        double duration = this.waypointTimes.get(this.segments.getIntegerValue() - 1).getDoubleValue();
        return this.desiredVelocity.getDoubleValue() / duration;
    }

    public double getAcceleration() {
        double squaredDuration = MathTools.square((double)this.waypointTimes.get(this.segments.getIntegerValue() - 1).getDoubleValue());
        return this.desiredAcceleration.getDoubleValue() / squaredDuration;
    }

    public double getJerk() {
        double duration = this.waypointTimes.get(this.segments.getIntegerValue() - 1).getDoubleValue();
        double cubedDuration = MathTools.pow((double)duration, (int)3);
        return this.desiredJerk.getDoubleValue() / cubedDuration;
    }

    public void informDone() {
        this.desiredPosition.set(0.0);
        this.desiredVelocity.set(0.0);
        this.desiredAcceleration.set(0.0);
    }

    public boolean hasConverged() {
        return this.hasConverged.getBooleanValue();
    }

    public void computeMaxSpeed() {
        this.computeMaxSpeed(1.0E-5);
    }

    public void computeMaxSpeed(double timeIncrement) {
        this.maxSpeed.set(Double.NEGATIVE_INFINITY);
        this.maxSpeedTime.set(Double.NaN);
        for (double time = 0.0; time <= 1.0; time += timeIncrement) {
            this.compute(time);
            double speed = this.getVelocity();
            if (!(speed > this.maxSpeed.getDoubleValue())) continue;
            this.maxSpeed.set(speed);
            this.maxSpeedTime.set(time);
        }
    }

    public double getMaxSpeed() {
        return this.maxSpeed.getDoubleValue();
    }

    public double getMaxSpeedTime() {
        return this.maxSpeedTime.getDoubleValue();
    }
}

