/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.trajectories;

import java.util.ArrayList;
import us.ihmc.commonWalkingControlModules.trajectories.PositionOptimizedTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.trajectories.SwingGenerator;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.trajectories.TrajectoryType;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class OneWaypointSwingGenerator
implements SwingGenerator {
    private static final int maxTimeIterations = -1;
    private static final int numberWaypoints = 1;
    private static final double defaultWaypointProportion = 0.5;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoDouble stepTime;
    private final YoDouble timeIntoStep;
    private final YoBoolean isDone;
    private final YoDouble swingHeight;
    private final YoDouble maxSwingHeight;
    private final YoDouble minSwingHeight;
    private final YoDouble defaultSwingHeight;
    private double waypointProportion;
    private TrajectoryType trajectoryType;
    private final PositionOptimizedTrajectoryGenerator trajectory;
    private final FramePoint3D initialPosition = new FramePoint3D();
    private final FrameVector3D initialVelocity = new FrameVector3D();
    private final FramePoint3D finalPosition = new FramePoint3D();
    private final FrameVector3D finalVelocity = new FrameVector3D();
    private final ArrayList<FramePoint3D> waypointPositions = new ArrayList();
    private final FrameVector3D desiredVelocity = new FrameVector3D();
    private final FrameVector3D desiredAcceleration = new FrameVector3D();
    private final FrameVector3D initialVelocityNoTimeDimension = new FrameVector3D();
    private final FrameVector3D finalVelocityNoTimeDimension = new FrameVector3D();
    private final FrameVector3D tempWaypointVelocity = new FrameVector3D();
    private final BagOfBalls waypointViz;
    private final FramePoint3D tempPoint3D = new FramePoint3D();

    public OneWaypointSwingGenerator(String namePrefix, double minSwingHeight, double maxSwingHeight, double defaultSwingHeight, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        YoRegistry registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.stepTime = new YoDouble(namePrefix + "StepTime", registry);
        this.timeIntoStep = new YoDouble(namePrefix + "TimeIntoStep", registry);
        this.isDone = new YoBoolean(namePrefix + "IsDone", registry);
        this.swingHeight = new YoDouble(namePrefix + "SwingHeight", registry);
        this.swingHeight.set(minSwingHeight);
        this.maxSwingHeight = new YoDouble(namePrefix + "MaxSwingHeight", registry);
        this.maxSwingHeight.set(maxSwingHeight);
        this.minSwingHeight = new YoDouble(namePrefix + "MinSwingHeight", registry);
        this.minSwingHeight.set(minSwingHeight);
        this.defaultSwingHeight = new YoDouble(namePrefix + "DefaultSwingHeight", registry);
        this.defaultSwingHeight.set(defaultSwingHeight);
        this.waypointProportion = 0.5;
        this.trajectory = new PositionOptimizedTrajectoryGenerator(namePrefix, registry, yoGraphicsListRegistry, -1, 1);
        for (int i = 0; i < 1; ++i) {
            this.waypointPositions.add(new FramePoint3D());
        }
        this.waypointViz = yoGraphicsListRegistry != null ? new BagOfBalls(1, 0.02, namePrefix + "Waypoints", YoAppearance.White(), registry, yoGraphicsListRegistry) : null;
        this.hideVisualization();
        parentRegistry.addChild(registry);
    }

    @Override
    public void setStepTime(double stepTime) {
        this.stepTime.set(stepTime);
    }

    @Override
    public void setInitialConditions(FramePoint3DReadOnly initialPosition, FrameVector3DReadOnly initialVelocity) {
        this.initialPosition.setIncludingFrame((FrameTuple3DReadOnly)initialPosition);
        this.initialVelocity.setIncludingFrame((FrameTuple3DReadOnly)initialVelocity);
    }

    @Override
    public void setFinalConditions(FramePoint3DReadOnly finalPosition, FrameVector3DReadOnly finalVelocity) {
        this.finalPosition.setIncludingFrame((FrameTuple3DReadOnly)finalPosition);
        this.finalVelocity.setIncludingFrame((FrameTuple3DReadOnly)finalVelocity);
    }

    @Override
    public void setStanceFootPosition(FramePoint3DReadOnly stanceFootPosition) {
    }

    @Override
    public void setTrajectoryType(TrajectoryType trajectoryType, RecyclingArrayList<FramePoint3D> waypoints) {
        if (trajectoryType == TrajectoryType.CUSTOM && waypoints == null) {
            PrintTools.warn((String)"Received no waypoints but trajectory type is custom. Using default trajectory.");
            this.trajectoryType = TrajectoryType.DEFAULT;
        } else if (trajectoryType == TrajectoryType.CUSTOM && waypoints.size() != 1) {
            PrintTools.warn((String)"Received unexpected amount of waypoints. Using default trajectory.");
            this.trajectoryType = TrajectoryType.DEFAULT;
        } else {
            this.trajectoryType = trajectoryType;
        }
        if (this.trajectoryType != TrajectoryType.CUSTOM) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            this.waypointPositions.get(i).setIncludingFrame((FrameTuple3DReadOnly)waypoints.get(i));
            this.waypointPositions.get(i).changeFrame(worldFrame);
        }
    }

    @Override
    public void setSwingHeight(double swingHeight) {
        boolean useDefaultSwing;
        boolean bl = useDefaultSwing = Double.isNaN(swingHeight) || swingHeight <= 0.0;
        if (useDefaultSwing) {
            this.swingHeight.set(this.defaultSwingHeight.getDoubleValue());
        } else {
            this.swingHeight.set(MathTools.clamp((double)swingHeight, (double)this.minSwingHeight.getDoubleValue(), (double)this.maxSwingHeight.getDoubleValue()));
        }
    }

    @Override
    public void setWaypointProportions(double[] waypointProportions) {
        this.waypointProportion = waypointProportions[0];
    }

    public void setWaypointProportion(double waypointProportion) {
        this.waypointProportion = waypointProportion;
    }

    public void initialize() {
        this.timeIntoStep.set(0.0);
        this.isDone.set(false);
        this.initialPosition.changeFrame(worldFrame);
        this.finalPosition.changeFrame(worldFrame);
        double maxStepZ = Math.max(this.initialPosition.getZ(), this.finalPosition.getZ());
        switch (this.trajectoryType) {
            case OBSTACLE_CLEARANCE: {
                int i;
                for (i = 0; i < 1; ++i) {
                    this.waypointPositions.get(i).interpolate((FrameTuple3DReadOnly)this.initialPosition, (FrameTuple3DReadOnly)this.finalPosition, this.waypointProportion);
                    this.waypointPositions.get(i).setZ(maxStepZ + this.swingHeight.getDoubleValue());
                }
                break;
            }
            case DEFAULT: {
                int i;
                for (i = 0; i < 1; ++i) {
                    this.waypointPositions.get(i).interpolate((FrameTuple3DReadOnly)this.initialPosition, (FrameTuple3DReadOnly)this.finalPosition, this.waypointProportion);
                    this.waypointPositions.get(i).addZ(this.swingHeight.getDoubleValue());
                }
                break;
            }
            case CUSTOM: {
                break;
            }
            default: {
                throw new RuntimeException("Trajectory type not implemented");
            }
        }
        double maxWaypointZ = maxStepZ + this.maxSwingHeight.getDoubleValue();
        for (int i = 0; i < 1; ++i) {
            this.waypointPositions.get(i).setZ(Math.min(this.waypointPositions.get(i).getZ(), maxWaypointZ));
        }
        this.initialVelocityNoTimeDimension.setIncludingFrame((FrameTuple3DReadOnly)this.initialVelocity);
        this.finalVelocityNoTimeDimension.setIncludingFrame((FrameTuple3DReadOnly)this.finalVelocity);
        this.initialVelocityNoTimeDimension.scale(this.stepTime.getDoubleValue());
        this.finalVelocityNoTimeDimension.scale(this.stepTime.getDoubleValue());
        this.trajectory.setEndpointConditions((FramePoint3DReadOnly)this.initialPosition, (FrameVector3DReadOnly)this.initialVelocityNoTimeDimension, (FramePoint3DReadOnly)this.finalPosition, (FrameVector3DReadOnly)this.finalVelocityNoTimeDimension);
        this.trajectory.setWaypoints(this.waypointPositions);
        this.trajectory.initialize();
        this.visualize();
    }

    private void visualize() {
        if (this.waypointViz == null) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            this.waypointViz.setBall((FramePoint3DReadOnly)this.waypointPositions.get(i), i);
        }
    }

    @Override
    public boolean doOptimizationUpdate() {
        return this.trajectory.doOptimizationUpdate();
    }

    public void compute(double time) {
        double trajectoryTime = this.stepTime.getDoubleValue();
        this.isDone.set(time >= trajectoryTime);
        time = MathTools.clamp((double)time, (double)0.0, (double)trajectoryTime);
        this.timeIntoStep.set(time);
        double percent = time / trajectoryTime;
        this.trajectory.compute(percent);
    }

    public boolean isDone() {
        return this.isDone.getBooleanValue();
    }

    public FramePoint3DReadOnly getPosition() {
        return this.trajectory.getPosition();
    }

    public FrameVector3DReadOnly getVelocity() {
        this.desiredVelocity.set((FrameTuple3DReadOnly)this.trajectory.getVelocity());
        this.desiredVelocity.scale(1.0 / this.stepTime.getDoubleValue());
        return this.desiredVelocity;
    }

    public FrameVector3DReadOnly getAcceleration() {
        this.desiredAcceleration.set((FrameTuple3DReadOnly)this.trajectory.getAcceleration());
        this.desiredAcceleration.scale(1.0 / (this.stepTime.getDoubleValue() * this.stepTime.getDoubleValue()));
        return this.desiredAcceleration;
    }

    public void showVisualization() {
        this.trajectory.showVisualization();
    }

    public void hideVisualization() {
        this.waypointViz.hideAll();
        this.tempPoint3D.setToNaN();
        for (int i = 0; i < 1; ++i) {
            this.waypointViz.setBall((FramePoint3DReadOnly)this.tempPoint3D, i);
        }
        this.trajectory.hideVisualization();
    }

    @Override
    public int getNumberOfWaypoints() {
        return 1;
    }

    @Override
    public void getWaypointData(int waypointIndex, FrameEuclideanTrajectoryPoint waypointDataToPack) {
        double waypointTime = this.stepTime.getDoubleValue() * this.trajectory.getWaypointTime(waypointIndex);
        this.trajectory.getWaypointVelocity(waypointIndex, this.tempWaypointVelocity);
        this.tempWaypointVelocity.scale(1.0 / this.stepTime.getDoubleValue());
        waypointDataToPack.setToNaN(worldFrame);
        waypointDataToPack.setTime(waypointTime);
        waypointDataToPack.setPosition((FramePoint3DReadOnly)this.waypointPositions.get(waypointIndex));
        waypointDataToPack.setLinearVelocity((FrameVector3DReadOnly)this.tempWaypointVelocity);
    }
}

