/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.touchdownDetector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commonWalkingControlModules.touchdownDetector.WrenchCalculator;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.math.filters.WeightedAverageYoFrameVector3D;
import us.ihmc.tools.lists.PairList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class WeightedAverageWrenchCalculator
implements WrenchCalculator {
    private final WeightedAverageYoFrameVector3D averageLinearForce;
    private final WeightedAverageYoFrameVector3D averageAngularForce;
    private final HashMap<WrenchCalculator, YoFrameVector3D> angularForces = new HashMap();
    private final HashMap<WrenchCalculator, YoFrameVector3D> linearForces = new HashMap();
    private final List<WrenchCalculator> wrenchCalculators = new ArrayList<WrenchCalculator>();
    private final Wrench wrench = new Wrench();
    private final FrameVector3D tempLinearVector = new FrameVector3D();
    private final FrameVector3D tempAngularVector = new FrameVector3D();

    public WeightedAverageWrenchCalculator(String prefix, String variableSuffix, YoRegistry registry, PairList<DoubleProvider, WrenchCalculator> wrenchCalculatorPairs) {
        this.wrench.setToZero(ReferenceFrame.getWorldFrame());
        this.averageAngularForce = new WeightedAverageYoFrameVector3D(prefix + "_WeightedAverageAngularForce" + variableSuffix, ReferenceFrame.getWorldFrame(), registry);
        this.averageLinearForce = new WeightedAverageYoFrameVector3D(prefix + "_WeightedAverageLinearForce" + variableSuffix, ReferenceFrame.getWorldFrame(), registry);
        for (ImmutablePair wrenchCalculatorPair : wrenchCalculatorPairs) {
            WrenchCalculator wrenchCalculator = (WrenchCalculator)wrenchCalculatorPair.getRight();
            YoFrameVector3D linearForce = new YoFrameVector3D(wrenchCalculator.getName() + "LinearForce" + variableSuffix, ReferenceFrame.getWorldFrame(), registry);
            YoFrameVector3D angularForce = new YoFrameVector3D(wrenchCalculator.getName() + "AngularForce" + variableSuffix, ReferenceFrame.getWorldFrame(), registry);
            this.linearForces.put(wrenchCalculator, linearForce);
            this.angularForces.put(wrenchCalculator, angularForce);
            this.averageLinearForce.addFrameVector3DToAverage((DoubleProvider)wrenchCalculatorPair.getLeft(), linearForce);
            this.averageAngularForce.addFrameVector3DToAverage((DoubleProvider)wrenchCalculatorPair.getLeft(), angularForce);
            this.wrenchCalculators.add(wrenchCalculator);
        }
    }

    @Override
    public void calculate() {
        ReferenceFrame originalFrame = this.wrenchCalculators.get(0).getWrench().getReferenceFrame();
        for (int i = 0; i < this.wrenchCalculators.size(); ++i) {
            WrenchCalculator wrenchCalculator = this.wrenchCalculators.get(i);
            wrenchCalculator.calculate();
            WrenchReadOnly wrench = wrenchCalculator.getWrench();
            this.linearForces.get(wrenchCalculator).setMatchingFrame((FrameTuple3DReadOnly)wrench.getLinearPart());
            this.angularForces.get(wrenchCalculator).setMatchingFrame((FrameTuple3DReadOnly)wrench.getAngularPart());
        }
        this.averageAngularForce.update();
        this.averageLinearForce.update();
        this.tempAngularVector.setIncludingFrame((FrameTuple3DReadOnly)this.averageAngularForce);
        this.tempLinearVector.setIncludingFrame((FrameTuple3DReadOnly)this.averageLinearForce);
        this.tempAngularVector.changeFrame(originalFrame);
        this.tempLinearVector.changeFrame(originalFrame);
        this.wrench.setToZero(originalFrame);
        this.wrench.set((FrameVector3DReadOnly)this.tempAngularVector, (FrameVector3DReadOnly)this.tempLinearVector);
    }

    @Override
    public WrenchReadOnly getWrench() {
        return this.wrench;
    }

    @Override
    public boolean isTorquingIntoJointLimit() {
        for (int i = 0; i < this.wrenchCalculators.size(); ++i) {
            if (!this.wrenchCalculators.get(i).isTorquingIntoJointLimit()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

