/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.touchdownDetector;

import us.ihmc.commonWalkingControlModules.touchdownDetector.TouchdownDetector;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.math.filters.GlitchFilteredYoBoolean;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class JointVelocityFiniteDifferenceBasedTouchdownDetector
implements TouchdownDetector {
    private final OneDoFJointBasics joint;
    private final AlphaFilteredYoVariable velocityFiniteDifferenceFiltered;
    private final YoDouble footInSwingThreshold;
    private final YoDouble touchdownThreshold;
    private final YoDouble touchdownForSureThreshold;
    private final YoDouble finiteDifferenceAlphaFilter;
    private final GlitchFilteredYoBoolean footInSwingFiltered;
    private final YoBoolean controllerSetFootSwitch;
    private final YoBoolean touchdownDetected;
    private final YoBoolean touchdownForSureDetected;
    private double previousVelocity;
    private boolean initialized = false;

    public JointVelocityFiniteDifferenceBasedTouchdownDetector(OneDoFJointBasics joint, YoBoolean controllerSetFootSwitch, YoRegistry registry) {
        this.joint = joint;
        this.controllerSetFootSwitch = controllerSetFootSwitch;
        this.finiteDifferenceAlphaFilter = new YoDouble(joint.getName() + "_velocityFiniteDifferenceAlpha", registry);
        this.finiteDifferenceAlphaFilter.set(0.99);
        this.velocityFiniteDifferenceFiltered = new AlphaFilteredYoVariable(joint.getName() + "_velocityFiniteDifferenceFiltered", registry, (DoubleProvider)this.finiteDifferenceAlphaFilter);
        this.footInSwingThreshold = new YoDouble(joint.getName() + "_footInSwingThreshold", registry);
        this.touchdownThreshold = new YoDouble(joint.getName() + "__velocityFiniteDifferenceTouchdownThreshold", registry);
        this.touchdownForSureThreshold = new YoDouble(joint.getName() + "__velocityFiniteDifferenceTouchdownForSureThreshold", registry);
        this.footInSwingFiltered = new GlitchFilteredYoBoolean(joint.getName() + "_footInSwingFiltered", registry, 50);
        this.touchdownDetected = new YoBoolean(joint.getName() + "_velocityFiniteDifferenceTouchdownDetected", registry);
        this.touchdownForSureDetected = new YoBoolean(joint.getName() + "_velocityFiniteDifferenceTouchdownForSureDetected", registry);
    }

    public void setFootInSwingThreshold(double footInSwingThreshold) {
        this.footInSwingThreshold.set(footInSwingThreshold);
    }

    public void setTouchdownThreshold(double touchdownThreshold) {
        this.touchdownThreshold.set(touchdownThreshold);
    }

    public void setTouchdownForSureThreshold(double touchdownThreshold) {
        this.touchdownForSureThreshold.set(touchdownThreshold);
    }

    @Override
    public boolean hasTouchedDown() {
        return this.touchdownDetected.getBooleanValue();
    }

    @Override
    public boolean hasForSureTouchedDown() {
        return this.touchdownForSureDetected.getBooleanValue();
    }

    @Override
    public void update() {
        if (this.initialized) {
            this.velocityFiniteDifferenceFiltered.update(Math.abs(this.joint.getQd() - this.previousVelocity) * 1000.0);
            this.previousVelocity = this.joint.getQd();
            if (!this.controllerSetFootSwitch.getBooleanValue() || !this.touchdownDetected.getBooleanValue()) {
                this.footInSwingFiltered.update(this.velocityFiniteDifferenceFiltered.getDoubleValue() < this.footInSwingThreshold.getDoubleValue());
                if (this.footInSwingFiltered.getBooleanValue()) {
                    this.touchdownDetected.set(this.velocityFiniteDifferenceFiltered.getDoubleValue() > this.touchdownThreshold.getDoubleValue());
                    this.touchdownForSureDetected.set(this.velocityFiniteDifferenceFiltered.getDoubleValue() > this.touchdownForSureThreshold.getDoubleValue());
                }
            } else {
                this.footInSwingFiltered.set(false);
            }
        } else {
            this.previousVelocity = this.joint.getQd();
            this.initialized = true;
        }
    }

    @Override
    public void reset() {
        this.touchdownDetected.set(false);
        this.touchdownForSureDetected.set(false);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

