/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.touchdownDetector;

import us.ihmc.commonWalkingControlModules.touchdownDetector.TouchdownDetector;
import us.ihmc.commons.MathTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class JointTorqueBasedTouchdownDetector
implements TouchdownDetector {
    private final OneDoFJointBasics joint;
    private final YoDouble jointTorque;
    private final YoDouble torqueThreshold;
    private final YoDouble torqueForSureThreshold;
    private final YoBoolean touchdownDetected;
    private final YoBoolean touchdownForSureDetected;
    private final boolean dontDetectTouchdownIfAtJointLimit;
    private double signum;
    private double forSureSignum;

    public JointTorqueBasedTouchdownDetector(String suffix, OneDoFJointBasics joint, YoRegistry registry) {
        this(suffix, joint, false, registry);
    }

    public JointTorqueBasedTouchdownDetector(String suffix, OneDoFJointBasics joint, boolean dontDetectTouchdownIfAtJointLimit, YoRegistry registry) {
        this.joint = joint;
        this.dontDetectTouchdownIfAtJointLimit = dontDetectTouchdownIfAtJointLimit;
        this.jointTorque = new YoDouble(joint.getName() + "_torqueUsedForTouchdownDetection" + suffix, registry);
        this.torqueThreshold = new YoDouble(joint.getName() + "_touchdownTorqueThreshold" + suffix, registry);
        this.torqueForSureThreshold = new YoDouble(joint.getName() + "_touchdownTorqueForSureThreshold" + suffix, registry);
        this.touchdownDetected = new YoBoolean(joint.getName() + "_torqueBasedTouchdownDetected" + suffix, registry);
        this.touchdownForSureDetected = new YoBoolean(joint.getName() + "_torqueBasedTouchdownForSureDetected" + suffix, registry);
    }

    public void setTorqueThreshold(double torqueThreshold) {
        this.torqueThreshold.set(torqueThreshold);
        this.signum = Math.signum(torqueThreshold);
    }

    public void setTorqueForSureThreshold(double torqueThreshold) {
        this.torqueForSureThreshold.set(torqueThreshold);
        this.forSureSignum = Math.signum(torqueThreshold);
    }

    @Override
    public boolean hasTouchedDown() {
        return this.touchdownDetected.getBooleanValue();
    }

    @Override
    public boolean hasForSureTouchedDown() {
        return this.touchdownForSureDetected.getBooleanValue();
    }

    private boolean isAtJointLimit() {
        double jointLimitUpper;
        double jointLimitLower;
        double q = this.joint.getQ();
        return !MathTools.intervalContains((double)q, (double)(jointLimitLower = this.joint.getJointLimitLower()), (double)(jointLimitUpper = this.joint.getJointLimitUpper()), (boolean)false, (boolean)false);
    }

    @Override
    public void update() {
        double threshold = this.torqueThreshold.getDoubleValue() * this.signum;
        double forSureThreshold = this.torqueForSureThreshold.getDoubleValue() * this.forSureSignum;
        double torque = this.joint.getTau() * this.signum;
        double forSureTorque = this.joint.getTau() * this.forSureSignum;
        this.jointTorque.set(this.joint.getTau());
        if (this.dontDetectTouchdownIfAtJointLimit && this.isAtJointLimit()) {
            this.touchdownDetected.set(false);
            this.touchdownForSureDetected.set(false);
        } else {
            this.touchdownDetected.set(torque > threshold);
            this.touchdownForSureDetected.set(forSureTorque > forSureThreshold);
        }
    }

    @Override
    public void reset() {
        this.jointTorque.set(0.0);
        this.touchdownDetected.set(false);
        this.touchdownForSureDetected.set(false);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

