/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.touchdownDetector;

import us.ihmc.commonWalkingControlModules.touchdownDetector.TouchdownDetector;
import us.ihmc.commonWalkingControlModules.touchdownDetector.WrenchCalculator;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ForceBasedTouchDownDetection
implements TouchdownDetector {
    private final String name = "ForceTchdwnDetect";
    private final YoRegistry registry;
    private final YoBoolean isInContact;
    private final YoBoolean isDefinitelyInContact;
    private final DoubleProvider zForceThreshold;
    private final DoubleProvider zForceForSureThreshold;
    private final YoDouble measuredZForce;
    private final YoBoolean isTorquingIntoJointLimit;
    private final FrameVector3D footForce = new FrameVector3D();
    private final WrenchCalculator wrenchCalculator;
    private final boolean dontDetectTouchdownIfAtJointLimit;

    public ForceBasedTouchDownDetection(String suffix, WrenchCalculator wrenchCalculator, RobotQuadrant robotQuadrant, boolean dontDetectTouchdownIfAtJointLimit, DoubleProvider zForceThreshold, DoubleProvider zForceForSureThreshold, YoRegistry parentRegistry) {
        this.wrenchCalculator = wrenchCalculator;
        this.dontDetectTouchdownIfAtJointLimit = dontDetectTouchdownIfAtJointLimit;
        this.zForceThreshold = zForceThreshold;
        this.zForceForSureThreshold = zForceForSureThreshold;
        String prefix = robotQuadrant.getShortName() + "ForceTchdwnDetect";
        this.registry = new YoRegistry(prefix);
        this.isInContact = new YoBoolean(prefix + "IsInContact" + suffix, this.registry);
        this.isDefinitelyInContact = new YoBoolean(prefix + "IsDefinitelyInContact" + suffix, this.registry);
        this.measuredZForce = new YoDouble(prefix + "MeasuredZForce" + suffix, this.registry);
        this.isTorquingIntoJointLimit = new YoBoolean(prefix + "IsTorquingIntoJointLimit" + suffix, this.registry);
        parentRegistry.addChild(this.registry);
    }

    @Override
    public boolean hasTouchedDown() {
        return this.isInContact.getBooleanValue();
    }

    @Override
    public boolean hasForSureTouchedDown() {
        return this.isDefinitelyInContact.getBooleanValue();
    }

    @Override
    public void update() {
        this.footForce.setIncludingFrame((FrameTuple3DReadOnly)this.wrenchCalculator.getWrench().getLinearPart());
        this.footForce.changeFrame(ReferenceFrame.getWorldFrame());
        this.measuredZForce.set(this.footForce.getZ());
        this.isTorquingIntoJointLimit.set(this.wrenchCalculator.isTorquingIntoJointLimit());
        if (this.dontDetectTouchdownIfAtJointLimit && this.isTorquingIntoJointLimit.getBooleanValue()) {
            this.isInContact.set(false);
            this.isDefinitelyInContact.set(false);
        } else {
            this.isInContact.set(this.measuredZForce.getDoubleValue() > this.zForceThreshold.getValue());
            this.isDefinitelyInContact.set(this.measuredZForce.getDoubleValue() > this.zForceForSureThreshold.getValue());
        }
    }

    @Override
    public void reset() {
        this.measuredZForce.set(0.0);
        this.isInContact.set(false);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

