/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.staticEquilibrium;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.StaticEquilibriumContactPoint;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.StaticEquilibriumSolverInput;
import us.ihmc.commons.MathTools;
import us.ihmc.convexOptimization.quadraticProgram.SimpleEfficientActiveSetQPSolverWithInactiveVariables;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.simulationconstructionset.util.TickAndUpdatable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class StaticEquilibriumSolver {
    private static final boolean updateGraphicsEachIteration = false;
    private static final int numberOfDirectionsToOptimize = 16;
    private static final int maximumNumberOfIterations = 8000;
    private static final double convergenceThreshold = 1.0E-7;
    private static final double rhoMax = 20.0;
    private static final double alphaQuadraticCost = 0.1;
    static final double mass = 1.0;
    private static final Mode mode = Mode.CUSTOM;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoGraphicsListRegistry graphicsListRegistry = new YoGraphicsListRegistry();
    private TickAndUpdatable tickAndUpdatable = null;
    private final List<StaticEquilibriumContactPoint> contactPoints = new ArrayList<StaticEquilibriumContactPoint>();
    private StaticEquilibriumSolverInput input;
    private int numberOfDecisionVariables;
    private final DMatrixRMaj Aeq = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj beq = new DMatrixRMaj(0, 0);
    private final SimpleEfficientActiveSetQPSolverWithInactiveVariables qpSolver = new SimpleEfficientActiveSetQPSolverWithInactiveVariables();
    private final DMatrixRMaj quadraticCost = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj linearCost = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj lowerBound = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj upperBound = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Ain = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj bin = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj AeqActive = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj activeDiagonal = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj xTrial = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj xSolution = new DMatrixRMaj(0, 0);
    private final ConvexPolygon2D supportRegion = new ConvexPolygon2D();
    private final YoFramePoint3D directionToOptimizeBase = new YoFramePoint3D("directionToOptimizeBase", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D directionToOptimize = new YoFrameVector3D("directionToOptimize", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D candidateCoM = new YoFramePoint3D("candidateCoM", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D optimizedCoM = new YoFramePoint3D("optimizedCoM", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoInteger iterations = new YoInteger("iterations", this.registry);
    private static final List<Vector2D> directionsToOptimize = new ArrayList<Vector2D>();
    private final YoDouble deltaCoM = new YoDouble("deltaCoM", this.registry);
    private final YoInteger activeBetaSize = new YoInteger("activeBetaSize", this.registry);
    private final DMatrixRMaj p0 = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj p1 = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj xProjected = new DMatrixRMaj(0, 0);

    public StaticEquilibriumSolver() {
        for (int i = 0; i < 50; ++i) {
            this.contactPoints.add(new StaticEquilibriumContactPoint(i, this.registry, this.graphicsListRegistry));
        }
        YoGraphicVector directionToOptimizeGraphic = new YoGraphicVector("directionToOptimizeGraphic", this.directionToOptimizeBase, this.directionToOptimize, 0.5);
        this.graphicsListRegistry.registerYoGraphic(this.getClass().getSimpleName(), (YoGraphic)directionToOptimizeGraphic);
        this.directionToOptimizeBase.set(0.0, 0.0, 0.4);
        YoGraphicPosition optimizedCoMGraphic = new YoGraphicPosition("optimizedCoMGraphic", this.optimizedCoM, 0.03, YoAppearance.DarkRed());
        this.graphicsListRegistry.registerYoGraphic(this.getClass().getSimpleName(), (YoGraphic)optimizedCoMGraphic);
        YoGraphicPosition candidateCoMGraphic = new YoGraphicPosition("candidateCoM", this.candidateCoM, 0.03, YoAppearance.Blue());
        this.graphicsListRegistry.registerYoGraphic(this.getClass().getSimpleName(), (YoGraphic)candidateCoMGraphic);
    }

    public void initialize(StaticEquilibriumSolverInput input) {
        int i;
        this.input = input;
        this.numberOfDecisionVariables = 4 * input.getNumberOfContacts() + 2;
        this.Aeq.reshape(6, this.numberOfDecisionVariables);
        this.beq.reshape(6, 1);
        for (i = 0; i < this.contactPoints.size(); ++i) {
            this.contactPoints.get(i).clear();
        }
        for (i = 0; i < input.getNumberOfContacts(); ++i) {
            StaticEquilibriumContactPoint contactPoint = this.contactPoints.get(i);
            contactPoint.initialize(input);
            FramePoint3D contactPointPosition = input.getContactPointPositions().get(i);
            for (int j = 0; j < 4; ++j) {
                YoFrameVector3D basisVector = contactPoint.getBasisVector(j);
                int column = 4 * i + j;
                this.Aeq.set(0, column, basisVector.getX());
                this.Aeq.set(1, column, basisVector.getY());
                this.Aeq.set(2, column, basisVector.getZ());
                double xMomentScale = contactPointPosition.getY() * basisVector.getZ() - contactPointPosition.getZ() * basisVector.getY();
                this.Aeq.set(3, column, xMomentScale);
                double yMomentScale = contactPointPosition.getZ() * basisVector.getX() - contactPointPosition.getX() * basisVector.getZ();
                this.Aeq.set(4, column, yMomentScale);
                double zMomentScale = contactPointPosition.getX() * basisVector.getY() - contactPointPosition.getY() * basisVector.getX();
                this.Aeq.set(5, column, zMomentScale);
            }
        }
        this.Aeq.set(3, this.numberOfDecisionVariables - 1, -1.0 * input.getGravityMagnitude());
        this.Aeq.set(4, this.numberOfDecisionVariables - 2, 1.0 * input.getGravityMagnitude());
        this.beq.set(2, 0, 1.0 * input.getGravityMagnitude());
        this.xTrial.reshape(this.numberOfDecisionVariables, 1);
        this.xSolution.reshape(this.numberOfDecisionVariables, 1);
        if (mode == Mode.CUSTOM) {
            this.AeqActive.reshape(6, this.numberOfDecisionVariables);
            this.activeDiagonal.reshape(this.numberOfDecisionVariables, this.numberOfDecisionVariables);
            CommonOps_DDRM.setIdentity((DMatrix1Row)this.activeDiagonal);
        } else if (mode == Mode.QP) {
            this.quadraticCost.reshape(this.numberOfDecisionVariables, this.numberOfDecisionVariables);
            this.linearCost.reshape(this.numberOfDecisionVariables, 1);
            this.lowerBound.reshape(this.numberOfDecisionVariables, 1);
            this.upperBound.reshape(this.numberOfDecisionVariables, 1);
            this.Ain.reshape(this.numberOfDecisionVariables - 2, this.numberOfDecisionVariables);
            this.bin.reshape(this.numberOfDecisionVariables - 2, 1);
            CommonOps_DDRM.fill((DMatrixD1)this.lowerBound, (double)0.0);
            CommonOps_DDRM.fill((DMatrixD1)this.upperBound, (double)100.0);
            this.lowerBound.set(this.numberOfDecisionVariables - 2, -100.0);
            this.lowerBound.set(this.numberOfDecisionVariables - 1, -100.0);
            CommonOps_DDRM.fill((DMatrixD1)this.bin, (double)-1.0E-5);
            for (i = 0; i < this.numberOfDecisionVariables - 2; ++i) {
                this.Ain.set(i, i, -1.0);
            }
            CommonOps_DDRM.setIdentity((DMatrix1Row)this.quadraticCost);
            CommonOps_DDRM.scale((double)0.1, (DMatrixD1)this.quadraticCost);
        }
    }

    public void solve() {
        this.supportRegion.clear();
        for (int i = 0; i < directionsToOptimize.size(); ++i) {
            Vector2D directionToOptimize = directionsToOptimize.get(i);
            this.directionToOptimize.set((Tuple2DReadOnly)directionToOptimize);
            switch (mode) {
                case QP: {
                    this.linearCost.set(this.numberOfDecisionVariables - 2, -100.0 * directionToOptimize.getX());
                    this.linearCost.set(this.numberOfDecisionVariables - 1, -100.0 * directionToOptimize.getY());
                    this.qpSolver.clear();
                    this.qpSolver.resetActiveSet();
                    this.qpSolver.setUseWarmStart(false);
                    this.qpSolver.setConvergenceThreshold(1.0E-8);
                    this.qpSolver.setMaxNumberOfIterations(400);
                    this.qpSolver.setQuadraticCostFunction((DMatrix)this.quadraticCost, (DMatrix)this.linearCost);
                    this.qpSolver.setLinearEqualityConstraints((DMatrix)this.Aeq, (DMatrix)this.beq);
                    this.qpSolver.setVariableBounds((DMatrix)this.lowerBound, (DMatrix)this.upperBound);
                    this.qpSolver.setLinearInequalityConstraints((DMatrix)this.Ain, (DMatrix)this.bin);
                    this.qpSolver.solve((DMatrix)this.xSolution);
                    break;
                }
                default: {
                    this.computeExtremeFeasibleCoM(directionToOptimize);
                }
            }
            this.setFinalGraphics();
            double comExtremumX = this.xSolution.get(this.numberOfDecisionVariables - 2, 0);
            double comExtremumY = this.xSolution.get(this.numberOfDecisionVariables - 1, 0);
            this.supportRegion.addVertex(comExtremumX, comExtremumY);
        }
        this.supportRegion.update();
    }

    private void computeExtremeFeasibleCoM(Vector2D directionToOptimize) {
        this.iterations.set(0);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.activeDiagonal);
        this.computeProjectionMatrices();
        this.computeInitialInteriorPoint();
        this.xSolution.set((DMatrixD1)this.xTrial);
        boolean[] activeBetas = new boolean[this.numberOfDecisionVariables - 2];
        Arrays.fill(activeBetas, true);
        while (this.iterations.getValue() < 8000) {
            int i;
            this.iterations.increment();
            if (this.iterations.getIntegerValue() > 1 && this.terminate()) break;
            boolean foundInvalidFrictionConstraint = false;
            for (i = 0; i < this.numberOfDecisionVariables - 2; ++i) {
                if (this.xTrial.get(i) < 0.0) {
                    foundInvalidFrictionConstraint = true;
                    this.xTrial.set(i, 1.0E-5);
                    this.activeDiagonal.set(i, i, 0.0);
                    activeBetas[i] = false;
                    continue;
                }
                if (!(this.xTrial.get(i) > 20.0)) continue;
                foundInvalidFrictionConstraint = true;
                this.xTrial.set(i, 19.0);
            }
            if (foundInvalidFrictionConstraint) {
                this.computeProjectionMatrices();
            }
            this.activeBetaSize.set(0);
            for (i = 0; i < activeBetas.length; ++i) {
                if (!activeBetas[i]) continue;
                this.activeBetaSize.increment();
            }
            if (!foundInvalidFrictionConstraint) {
                if (this.terminate()) break;
                this.xSolution.set((DMatrixD1)this.xTrial);
                double shiftAmount = 0.3;
                this.xTrial.add(this.numberOfDecisionVariables - 2, 0, shiftAmount * directionToOptimize.getX());
                this.xTrial.add(this.numberOfDecisionVariables - 1, 0, shiftAmount * directionToOptimize.getY());
            }
            this.projectToEqualityConstraints(this.xTrial);
        }
    }

    private void setIntermediateGraphics() {
        if (this.tickAndUpdatable == null) {
            return;
        }
        for (int j = 0; j < this.input.getNumberOfContacts(); ++j) {
            this.contactPoints.get(j).setResolvedForce(this.xTrial);
        }
        this.optimizedCoM.setX(this.xSolution.get(this.numberOfDecisionVariables - 2));
        this.optimizedCoM.setY(this.xSolution.get(this.numberOfDecisionVariables - 1));
        this.optimizedCoM.setZ(0.1);
        this.candidateCoM.setX(this.xTrial.get(this.numberOfDecisionVariables - 2));
        this.candidateCoM.setY(this.xTrial.get(this.numberOfDecisionVariables - 1));
        this.candidateCoM.setZ(0.1);
        this.tickAndUpdatable.tickAndUpdate();
    }

    private void setFinalGraphics() {
        if (this.tickAndUpdatable == null) {
            return;
        }
        for (int j = 0; j < this.input.getNumberOfContacts(); ++j) {
            this.contactPoints.get(j).setResolvedForce(this.xSolution);
        }
        this.candidateCoM.setToNaN();
        this.optimizedCoM.setX(this.xSolution.get(this.numberOfDecisionVariables - 2));
        this.optimizedCoM.setY(this.xSolution.get(this.numberOfDecisionVariables - 1));
        this.optimizedCoM.setZ(0.1);
        this.tickAndUpdatable.tickAndUpdate();
    }

    private void computeProjectionMatrices() {
        CommonOps_DDRM.mult((DMatrix1Row)this.Aeq, (DMatrix1Row)this.activeDiagonal, (DMatrix1Row)this.AeqActive);
        DMatrixRMaj AATinv = new DMatrixRMaj(0, 0);
        CommonOps_DDRM.multOuter((DMatrix1Row)this.AeqActive, (DMatrix1Row)AATinv);
        CommonOps_DDRM.invert((DMatrixRMaj)AATinv);
        DMatrixRMaj ATAATinv = new DMatrixRMaj(0, 0);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.AeqActive, (DMatrix1Row)AATinv, (DMatrix1Row)ATAATinv);
        CommonOps_DDRM.mult((DMatrix1Row)ATAATinv, (DMatrix1Row)this.beq, (DMatrix1Row)this.p1);
        CommonOps_DDRM.mult((DMatrix1Row)ATAATinv, (DMatrix1Row)this.AeqActive, (DMatrix1Row)this.p0);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.p0);
        CommonOps_DDRM.addEquals((DMatrixD1)this.p0, (DMatrixD1)CommonOps_DDRM.identity((int)this.numberOfDecisionVariables));
    }

    private boolean terminate() {
        boolean hasConverged;
        if (this.iterations.getIntegerValue() <= 1) {
            return false;
        }
        if (this.activeBetaSize.getValue() <= 4) {
            return true;
        }
        double pX = this.xTrial.get(this.numberOfDecisionVariables - 2);
        double pY = this.xTrial.get(this.numberOfDecisionVariables - 1);
        double bestX = this.xSolution.get(this.numberOfDecisionVariables - 2);
        double bestY = this.xSolution.get(this.numberOfDecisionVariables - 1);
        double distance = EuclidCoreTools.norm((double)(pX - bestX), (double)(pY - bestY));
        this.deltaCoM.set(Math.sqrt(distance));
        boolean bl = hasConverged = distance < 1.0E-7;
        if (hasConverged) {
            // empty if block
        }
        return hasConverged;
    }

    private void computeInitialInteriorPoint() {
        Point2D averageContactPointXY = new Point2D();
        for (int i = 0; i < this.input.getNumberOfContacts(); ++i) {
            averageContactPointXY.add(this.input.getContactPointPositions().get(i).getX(), this.input.getContactPointPositions().get(i).getY());
        }
        averageContactPointXY.scale(1.0 / (double)this.input.getNumberOfContacts());
        double flatGroundBetaZ = 1.0 / Math.sqrt(1.0 + MathTools.square((double)this.input.getCoefficientOfFriction()));
        double rhoGuess = 1.0 * this.input.getGravityMagnitude() / (4.0 * (double)this.input.getNumberOfContacts() * flatGroundBetaZ);
        CommonOps_DDRM.fill((DMatrixD1)this.xTrial, (double)rhoGuess);
        this.xTrial.set(this.numberOfDecisionVariables - 2, averageContactPointXY.getX());
        this.xTrial.set(this.numberOfDecisionVariables - 1, averageContactPointXY.getY());
        this.projectToEqualityConstraints(this.xTrial);
    }

    private void projectToEqualityConstraints(DMatrixRMaj x) {
        CommonOps_DDRM.mult((DMatrix1Row)this.p0, (DMatrix1Row)x, (DMatrix1Row)this.xProjected);
        CommonOps_DDRM.addEquals((DMatrixD1)this.xProjected, (DMatrixD1)this.p1);
        x.set((DMatrixD1)this.xProjected);
    }

    public ConvexPolygon2D getSupportRegion() {
        this.supportRegion.update();
        return new ConvexPolygon2D((Vertex2DSupplier)this.supportRegion);
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public YoGraphicsListRegistry getGraphicsListRegistry() {
        return this.graphicsListRegistry;
    }

    public void setTickAndUpdatable(TickAndUpdatable tickAndUpdatable) {
        this.tickAndUpdatable = tickAndUpdatable;
    }

    public DMatrixRMaj getAeq() {
        return this.Aeq;
    }

    public DMatrixRMaj getBeq() {
        return this.beq;
    }

    static {
        double dTheta = 0.39269908169872414;
        for (int i = 0; i < 16; ++i) {
            directionsToOptimize.add(new Vector2D(Math.cos((double)i * dTheta), Math.sin((double)i * dTheta)));
        }
    }

    private static enum Mode {
        CUSTOM,
        QP;

    }
}

