/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.staticEquilibrium;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.StaticEquilibriumContactPoint;
import us.ihmc.commonWalkingControlModules.staticEquilibrium.StaticEquilibriumSolverInput;
import us.ihmc.convexOptimization.quadraticProgram.SimpleEfficientActiveSetQPSolverWithInactiveVariables;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class StaticEquilibriumForceOptimizer {
    private static final int maximumNumberOfIterations = 600;
    private static final double convergenceThreshold = 1.0E-7;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoGraphicsListRegistry graphicsListRegistry = new YoGraphicsListRegistry();
    private final SimpleEfficientActiveSetQPSolverWithInactiveVariables qpSolver = new SimpleEfficientActiveSetQPSolverWithInactiveVariables();
    private final List<StaticEquilibriumContactPoint> contactPoints = new ArrayList<StaticEquilibriumContactPoint>();
    private int numberOfDecisionVariables;
    private final DMatrixRMaj Aeq = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj beq = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj quadraticCost = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj linearCost = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj solution = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj lowerBounds = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj upperBounds = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Ain = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj bin = new DMatrixRMaj(0, 0);
    private boolean feasibleSolutionFound;

    public StaticEquilibriumForceOptimizer() {
        for (int i = 0; i < 50; ++i) {
            this.contactPoints.add(new StaticEquilibriumContactPoint(i, this.registry, this.graphicsListRegistry));
        }
    }

    public boolean solve(StaticEquilibriumSolverInput input, Point2DReadOnly centerOfMassXY) {
        int i;
        this.numberOfDecisionVariables = 4 * input.getNumberOfContacts();
        this.Aeq.reshape(6, this.numberOfDecisionVariables);
        this.beq.reshape(6, 1);
        for (i = 0; i < this.contactPoints.size(); ++i) {
            this.contactPoints.get(i).clear();
        }
        for (i = 0; i < input.getNumberOfContacts(); ++i) {
            StaticEquilibriumContactPoint contactPoint = this.contactPoints.get(i);
            contactPoint.initialize(input);
            FramePoint3D contactPointPosition = input.getContactPointPositions().get(i);
            for (int j = 0; j < 4; ++j) {
                YoFrameVector3D basisVector = contactPoint.getBasisVector(j);
                int column = 4 * i + j;
                this.Aeq.set(0, column, basisVector.getX());
                this.Aeq.set(1, column, basisVector.getY());
                this.Aeq.set(2, column, basisVector.getZ());
                double xMomentScale = contactPointPosition.getY() * basisVector.getZ() - contactPointPosition.getZ() * basisVector.getY();
                this.Aeq.set(3, column, xMomentScale);
                double yMomentScale = contactPointPosition.getZ() * basisVector.getX() - contactPointPosition.getX() * basisVector.getZ();
                this.Aeq.set(4, column, yMomentScale);
                double zMomentScale = contactPointPosition.getX() * basisVector.getY() - contactPointPosition.getY() * basisVector.getX();
                this.Aeq.set(5, column, zMomentScale);
            }
        }
        this.beq.set(2, 0, 1.0 * input.getGravityMagnitude());
        this.beq.set(3, 0, 1.0 * input.getGravityMagnitude() * centerOfMassXY.getY());
        this.beq.set(4, 0, -1.0 * input.getGravityMagnitude() * centerOfMassXY.getX());
        this.quadraticCost.reshape(this.numberOfDecisionVariables, this.numberOfDecisionVariables);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.quadraticCost);
        this.linearCost.reshape(this.numberOfDecisionVariables, 1);
        this.lowerBounds.reshape(this.numberOfDecisionVariables, 1);
        this.upperBounds.reshape(this.numberOfDecisionVariables, 1);
        this.Ain.reshape(this.numberOfDecisionVariables, this.numberOfDecisionVariables);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.Ain);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.Ain);
        this.bin.reshape(this.numberOfDecisionVariables, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.bin, (double)-1.0E-5);
        CommonOps_DDRM.fill((DMatrixD1)this.lowerBounds, (double)1.0E-5);
        CommonOps_DDRM.fill((DMatrixD1)this.upperBounds, (double)1000.0);
        this.qpSolver.clear();
        this.qpSolver.resetActiveSet();
        this.qpSolver.setUseWarmStart(false);
        this.qpSolver.setMaxNumberOfIterations(600);
        this.qpSolver.setConvergenceThreshold(1.0E-7);
        this.qpSolver.setQuadraticCostFunction((DMatrix)this.quadraticCost, (DMatrix)this.linearCost);
        this.qpSolver.setLinearEqualityConstraints((DMatrix)this.Aeq, (DMatrix)this.beq);
        this.qpSolver.setVariableBounds((DMatrix)this.lowerBounds, (DMatrix)this.upperBounds);
        this.qpSolver.setLinearInequalityConstraints((DMatrix)this.Ain, (DMatrix)this.bin);
        try {
            this.qpSolver.solve((DMatrix)this.solution);
        }
        catch (Exception e) {
            this.feasibleSolutionFound = false;
            return false;
        }
        this.feasibleSolutionFound = true;
        for (i = 0; i < this.numberOfDecisionVariables; ++i) {
            if (!Double.isNaN(this.solution.get(i))) continue;
            this.feasibleSolutionFound = false;
            break;
        }
        for (i = 0; i < input.getNumberOfContacts(); ++i) {
            this.contactPoints.get(i).setResolvedForce(this.solution);
        }
        return this.feasibleSolutionFound;
    }

    public boolean feasibleSolutionFound() {
        return this.feasibleSolutionFound;
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public YoGraphicsListRegistry getGraphicsListRegistry() {
        return this.graphicsListRegistry;
    }
}

